/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.core;

import com.atlassian.plugin.spring.scanner.annotation.component.ClasspathComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.core.SpringIndexWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import javax.inject.Named;
import javax.inject.Singleton;
import org.springframework.stereotype.Component;

@NotThreadSafe
class AnnotationValidator {
    private final Set<String> declaredComponentAnnotationTypes;
    private final Set<String> importedComponentAnnotationTypes;
    private final AnnotationReferences declaredComponents = new AnnotationReferences();
    private final AnnotationReferences importedComponents;

    AnnotationValidator() {
        this.declaredComponentAnnotationTypes = new HashSet<String>();
        this.declaredComponentAnnotationTypes.add(ExportAsService.class.getCanonicalName());
        this.declaredComponentAnnotationTypes.add(Component.class.getCanonicalName());
        this.declaredComponentAnnotationTypes.add(Named.class.getCanonicalName());
        this.declaredComponentAnnotationTypes.add(Singleton.class.getCanonicalName());
        this.importedComponents = new AnnotationReferences();
        this.importedComponentAnnotationTypes = new HashSet<String>();
        this.importedComponentAnnotationTypes.add(ComponentImport.class.getCanonicalName());
        this.importedComponentAnnotationTypes.add(ClasspathComponent.class.getCanonicalName());
        this.importedComponentAnnotationTypes.addAll(SpringIndexWriter.KNOWN_PRODUCT_IMPORT_ANNOTATIONS);
    }

    public void encounteredAnnotation(String annotationType, String component, String whereReferenced) {
        if (this.importedComponentAnnotationTypes.contains(annotationType)) {
            this.importedComponents.addReference(component, whereReferenced);
        } else if (this.declaredComponentAnnotationTypes.contains(annotationType)) {
            this.declaredComponents.addReference(component, whereReferenced);
        }
    }

    @Nonnull
    public List<String> validate() {
        Set<String> conflictingComponents = this.importedComponents.intersect(this.declaredComponents);
        return conflictingComponents.stream().map(this::getError).collect(Collectors.toList());
    }

    private String getError(String conflictingComponent) {
        List<String> imports = this.importedComponents.getReferences(conflictingComponent);
        List<String> declarations = this.declaredComponents.getReferences(conflictingComponent);
        return String.format("Cannot import a component within a plugin that declares the same component. Component '%s' was declared in %s but imported in %s", conflictingComponent, Arrays.toString(declarations.toArray()), Arrays.toString(imports.toArray()));
    }

    @NotThreadSafe
    static class AnnotationReferences {
        private final Map<String, List<String>> references = new HashMap<String, List<String>>();

        public void addReference(String component, String whereReferenced) {
            List sources = this.references.computeIfAbsent(component, k -> new ArrayList());
            sources.add(whereReferenced);
        }

        public List<String> getReferences(String component) {
            return this.references.get(component);
        }

        public Set<String> intersect(AnnotationReferences that) {
            HashSet<String> intersection = new HashSet<String>(this.references.keySet());
            intersection.retainAll(that.references.keySet());
            return intersection;
        }
    }
}

