/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.core;

import com.atlassian.plugin.spring.scanner.core.AtlassianSpringByteCodeScanner;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteCodeScannerConfiguration {
    private final Logger log;
    private final Set<URL> classPathUrls;
    private final String includeExclude;
    private final String outputDirectory;
    private final boolean verbose;
    private final boolean permitDuplicateImports;

    ByteCodeScannerConfiguration(Logger log, Set<URL> classPathUrls, String includeExclude, String outputDirectory, boolean verbose, boolean permitDuplicateImports) {
        this.log = log;
        this.classPathUrls = classPathUrls;
        this.includeExclude = includeExclude;
        this.outputDirectory = outputDirectory;
        this.verbose = verbose;
        this.permitDuplicateImports = permitDuplicateImports;
    }

    public Set<URL> getClassPathUrls() {
        return this.classPathUrls;
    }

    public String getIncludeExclude() {
        return this.includeExclude;
    }

    public Logger getLog() {
        return this.log;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isPermitDuplicateImports() {
        return this.permitDuplicateImports;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Logger log;
        private Set<URL> classPathUrls = Collections.emptySet();
        private String includeExclude = "";
        private String outputDirectory;
        private boolean verbose;
        private boolean permitDuplicateImports;

        Builder() {
            this.log = LoggerFactory.getLogger((String)AtlassianSpringByteCodeScanner.class.getName());
        }

        public Builder setLog(Logger log) {
            this.log = log;
            return this;
        }

        public Builder setIncludeExclude(String includeExclude) {
            this.includeExclude = includeExclude;
            return this;
        }

        public Builder setClassPathUrls(Set<URL> classPathUrls) {
            this.classPathUrls = classPathUrls;
            return this;
        }

        public Builder setOutputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        public Builder setVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder setPermitDuplicateImports(boolean permitDuplicateImports) {
            this.permitDuplicateImports = permitDuplicateImports;
            return this;
        }

        public ByteCodeScannerConfiguration build() {
            return new ByteCodeScannerConfiguration(this.log, this.classPathUrls, this.includeExclude, this.outputDirectory, this.verbose, this.permitDuplicateImports);
        }
    }
}

