/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.core;

import com.atlassian.plugin.spring.scanner.annotation.export.ModuleType;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.core.ByteCodeScannerConfiguration;
import com.atlassian.plugin.spring.scanner.core.JavassistHelper;
import com.atlassian.plugin.spring.scanner.core.ProfileFinder;
import com.atlassian.plugin.spring.scanner.core.SpringIndexWriter;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.AbstractScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

public class AtlassianSpringByteCodeScanner
extends AbstractScanner {
    private final Logger log;
    private final Stats stats;
    private final Errors errors;
    private final SpringIndexWriter springIndexWriter;
    private final ProfileFinder profileFinder;
    private final JavassistHelper javassistHelper;
    private boolean dbg;

    public AtlassianSpringByteCodeScanner(ByteCodeScannerConfiguration configuration) {
        this.log = configuration.getLog();
        this.springIndexWriter = new SpringIndexWriter(configuration.getOutputDirectory());
        this.javassistHelper = new JavassistHelper();
        this.profileFinder = new ProfileFinder(configuration.getClassPathUrls(), this.log);
        this.stats = new Stats();
        this.errors = new Errors();
        this.dbg = this.log.isDebugEnabled() || configuration.isVerbose();
        this.go(configuration);
    }

    private void go(ByteCodeScannerConfiguration configuration) {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.setUrls(configuration.getClassPathUrls());
        if (!Strings.isNullOrEmpty((String)configuration.getIncludeExclude())) {
            config.filterInputsBy((Predicate)FilterBuilder.parse((String)configuration.getIncludeExclude()));
        }
        config.setScanners(new Scanner[]{this});
        try {
            Reflections.log = null;
        }
        catch (Error error) {
            // empty catch block
        }
        new Reflections((Configuration)config);
        this.springIndexWriter.writeIndexes();
    }

    public Stats getStats() {
        return this.stats;
    }

    public Errors getErrors() {
        return this.errors;
    }

    public void scan(Object cls) {
        ClassFile classFile = (ClassFile)cls;
        try {
            this.scanClass(classFile);
        }
        catch (Exception e) {
            this.log.error(String.format("Unable to run byte code scanner on class %s. Continuing to the next class...", cls));
        }
    }

    private void scanClass(ClassFile classFile) throws Exception {
        this.stats.classesEncountered++;
        Set<String> profiles = this.profileFinder.getProfiles(classFile);
        String className = this.getMetadataAdapter().getClassName((Object)classFile);
        List classAnnotationNames = this.getMetadataAdapter().getClassAnnotationNames((Object)classFile);
        for (String annotationType : classAnnotationNames) {
            if (!this.isSuitableClassAnnotation(annotationType)) continue;
            if (!this.isSuitableClass(classFile)) {
                this.debug(String.format("\t(X) Class not suitable '%s' for annotation '%s'", className, annotationType));
                return;
            }
            this.stats.componentClassesEncountered++;
            String nameFromAnnotation = this.javassistHelper.getAnnotationMember(classFile, annotationType, "value");
            this.debug(String.format("(/) Found annotation '%s' inside class '%s'", annotationType, className));
            this.springIndexWriter.encounteredAnnotation(profiles, annotationType, nameFromAnnotation, className);
            if (!ModuleType.class.getCanonicalName().equals(annotationType)) continue;
            this.springIndexWriter.encounteredAnnotation(profiles, Component.class.getCanonicalName(), "", "com.atlassian.plugin.osgi.bridge.external.SpringHostContainer");
        }
        this.visitConstructors(classFile, profiles);
        this.visitFields(classFile, profiles);
    }

    private void debug(String msg) {
        if (this.dbg) {
            this.log.info("\t" + msg);
        }
    }

    private boolean isSuitableClass(ClassFile classFile) {
        String className = classFile.getName();
        if (classFile.isInterface()) {
            this.log.error(String.format("Found a type [%s] annotated as a component, but the type is not a concrete class. NOT adding to index file!!", className));
            return false;
        }
        if (classFile.isAbstract()) {
            this.log.error(String.format("Found a type [%s] annotated as a component, but the type is abstract. NOT adding to index file!!", className));
            return false;
        }
        return !this.profileFinder.isPackageClass(classFile);
    }

    private boolean isSuitableClassAnnotation(String annotationType) {
        return super.acceptResult(annotationType) && this.springIndexWriter.isInteresting(annotationType);
    }

    private void visitConstructors(ClassFile classFile, Set<String> profiles) {
        String className = classFile.getName();
        List methods = classFile.getMethods();
        for (MethodInfo method : methods) {
            String methodName = method.getName();
            if (!method.isConstructor()) continue;
            List parameterTypes = this.getMetadataAdapter().getParameterNames((Object)method);
            for (int i = 0; i < parameterTypes.size(); ++i) {
                String parameterType = (String)parameterTypes.get(i);
                List<Annotation> parameterAnnotationNames = this.javassistHelper.getParameterAnnotations(method, i);
                for (Annotation annotation : parameterAnnotationNames) {
                    String annotationType = annotation.getTypeName();
                    if (!this.acceptResult(annotationType) || !this.springIndexWriter.isParameterOrFieldAnnotation(annotationType)) continue;
                    String nameFromAnnotation = this.javassistHelper.getAnnotationMember(annotation, "value");
                    this.debug(String.format("(/) Found '%s' inside class '%s' method '%s' parameter '%s'", annotationType, className, methodName, parameterType));
                    this.springIndexWriter.encounteredAnnotation(profiles, annotationType, nameFromAnnotation, parameterType);
                }
            }
        }
    }

    private void visitFields(ClassFile classFile, Set<String> profiles) {
        String className = classFile.getName();
        List fields = classFile.getFields();
        for (FieldInfo field : fields) {
            LinkedList<String> annotationTypes = new LinkedList<String>();
            String fieldName = field.getName();
            AnnotationsAttribute annotations = (AnnotationsAttribute)field.getAttribute("RuntimeVisibleAnnotations");
            if (annotations != null) {
                for (Annotation annotation : annotations.getAnnotations()) {
                    String annotationType = annotation.getTypeName();
                    annotationTypes.add(annotationType);
                    if (!this.acceptResult(annotationType) || !this.springIndexWriter.isParameterOrFieldAnnotation(annotationType)) continue;
                    String fieldType = Descriptor.toClassName((String)field.getDescriptor());
                    String nameFromAnnotation = this.javassistHelper.getAnnotationMember(annotation, "value");
                    this.debug(String.format("(/) Found '%s' inside class '%s' on field '%s' of type '%s'", annotationType, className, fieldName, fieldType));
                    this.springIndexWriter.encounteredAnnotation(profiles, annotationType, nameFromAnnotation, fieldType);
                }
            }
            if (!annotationTypes.contains(ComponentImport.class.getCanonicalName())) continue;
            ArrayList<String> productImportsPresentOnField = new ArrayList<String>(SpringIndexWriter.KNOWN_PRODUCT_IMPORT_ANNOTATIONS);
            productImportsPresentOnField.retainAll(annotationTypes);
            if (productImportsPresentOnField.isEmpty()) continue;
            this.errors.addError(String.format("ComponentImport annotation cannot be used with product specific component imports: %s found on %s.%s", Arrays.toString(productImportsPresentOnField.toArray()), classFile.getName(), fieldName));
        }
    }

    public static class Errors {
        private final List<String> errorsEncountered = new ArrayList<String>();

        public void addError(String error) {
            this.errorsEncountered.add(error);
        }

        public List<String> getErrorsEncountered() {
            return this.errorsEncountered;
        }
    }

    public static class Stats {
        private int classesEncountered;
        private int componentClassesEncountered;

        public int getClassesEncountered() {
            return this.classesEncountered;
        }

        public int getComponentClassesEncountered() {
            return this.componentClassesEncountered;
        }
    }
}

