/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.core.vfs;

import com.atlassian.plugin.spring.scanner.core.vfs.CommonIO;
import com.atlassian.plugin.spring.scanner.core.vfs.VirtualFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class FilerBasedVirtualFile
implements VirtualFile {
    private final Filer filer;
    private final String fileName;

    public FilerBasedVirtualFile(Filer filer, String fileName) {
        this.filer = filer;
        this.fileName = StringUtils.replaceChars((String)fileName, (char)'\\', (char)'/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> readLines() throws IOException {
        FileObject fileObject = this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", this.fileName);
        InputStream in = null;
        try {
            in = fileObject.openInputStream();
            Collection<String> collection = CommonIO.readLines(new InputStreamReader(in));
            return collection;
        }
        catch (FileNotFoundException fne) {
            List<String> list = Collections.emptyList();
            return list;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLines(Iterable<String> lines) throws IOException {
        FileObject fileObject = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", this.fileName, new Element[0]);
        OutputStream out = null;
        try {
            out = fileObject.openOutputStream();
            CommonIO.writeLines(new OutputStreamWriter(out), lines);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeProperties(Properties properties, String comment) throws IOException {
        FileObject fileObject = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", this.fileName, new Element[0]);
        OutputStream out = null;
        try {
            out = fileObject.openOutputStream();
            CommonIO.writeProperties(new OutputStreamWriter(out), properties, comment);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }
}

