/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.server.PathContainer;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

class PathResourceLookupFunction
implements Function<ServerRequest, Optional<Resource>> {
    private final PathPattern pattern;
    private final Resource location;

    public PathResourceLookupFunction(String pattern, Resource location) {
        Assert.hasLength(pattern, "'pattern' must not be empty");
        Assert.notNull((Object)location, "'location' must not be null");
        this.pattern = PathPatternParser.defaultInstance.parse(pattern);
        this.location = location;
    }

    @Override
    public Optional<Resource> apply(ServerRequest request) {
        PathContainer pathContainer = request.requestPath().pathWithinApplication();
        if (!this.pattern.matches(pathContainer)) {
            return Optional.empty();
        }
        String path = this.processPath((pathContainer = this.pattern.extractPathWithinPattern(pathContainer)).value());
        if (!StringUtils.hasText(path) || this.isInvalidPath(path)) {
            return Optional.empty();
        }
        if (this.isInvalidEncodedInputPath(path)) {
            return Optional.empty();
        }
        if (!(this.location instanceof UrlResource)) {
            path = UriUtils.decode(path, StandardCharsets.UTF_8);
        }
        try {
            Resource resource = this.location.createRelative(path);
            if (resource.isReadable() && this.isResourceUnderLocation(resource)) {
                return Optional.of(resource);
            }
            return Optional.empty();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    protected String processPath(String path) {
        path = StringUtils.replace(path, "\\", "/");
        path = this.cleanDuplicateSlashes(path);
        return this.cleanLeadingSlash(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cleanDuplicateSlashes(String path) {
        StringBuilder sb = null;
        char prev = '\u0000';
        for (int i2 = 0; i2 < path.length(); ++i2) {
            char curr = path.charAt(i2);
            try {
                if (curr == '/' && prev == '/') {
                    if (sb != null) continue;
                    sb = new StringBuilder(path.substring(0, i2));
                    continue;
                }
                if (sb == null) continue;
                sb.append(path.charAt(i2));
                continue;
            }
            finally {
                prev = curr;
            }
        }
        return sb != null ? sb.toString() : path;
    }

    private String cleanLeadingSlash(String path) {
        boolean slash = false;
        for (int i2 = 0; i2 < path.length(); ++i2) {
            if (path.charAt(i2) == '/') {
                slash = true;
                continue;
            }
            if (path.charAt(i2) <= ' ' || path.charAt(i2) == '\u007f') continue;
            if (i2 == 0 || i2 == 1 && slash) {
                return path;
            }
            return slash ? "/" + path.substring(i2) : path.substring(i2);
        }
        return slash ? "/" : "";
    }

    private boolean isInvalidPath(String path) {
        if (path.contains("WEB-INF") || path.contains("META-INF")) {
            return true;
        }
        if (path.contains(":/")) {
            String relativePath;
            String string = relativePath = path.charAt(0) == '/' ? path.substring(1) : path;
            if (ResourceUtils.isUrl(relativePath) || relativePath.startsWith("url:")) {
                return true;
            }
        }
        return path.contains("..") && StringUtils.cleanPath(path).contains("../");
    }

    private boolean isInvalidEncodedInputPath(String path) {
        if (path.contains("%")) {
            try {
                String decodedPath = URLDecoder.decode(path, "UTF-8");
                if (this.isInvalidPath(decodedPath)) {
                    return true;
                }
                if (this.isInvalidPath(decodedPath = this.processPath(decodedPath))) {
                    return true;
                }
            }
            catch (UnsupportedEncodingException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isResourceUnderLocation(Resource resource) throws IOException {
        String locationPath;
        String resourcePath;
        if (resource.getClass() != this.location.getClass()) {
            return false;
        }
        if (resource instanceof UrlResource) {
            resourcePath = resource.getURL().toExternalForm();
            locationPath = StringUtils.cleanPath(this.location.getURL().toString());
        } else if (resource instanceof ClassPathResource) {
            resourcePath = ((ClassPathResource)resource).getPath();
            locationPath = StringUtils.cleanPath(((ClassPathResource)this.location).getPath());
        } else if (resource instanceof ServletContextResource) {
            resourcePath = ((ServletContextResource)resource).getPath();
            locationPath = StringUtils.cleanPath(((ServletContextResource)this.location).getPath());
        } else {
            resourcePath = resource.getURL().getPath();
            locationPath = StringUtils.cleanPath(this.location.getURL().getPath());
        }
        if (locationPath.equals(resourcePath)) {
            return true;
        }
        locationPath = locationPath.endsWith("/") || locationPath.isEmpty() ? locationPath : locationPath + "/";
        return resourcePath.startsWith(locationPath) && !this.isInvalidEncodedResourcePath(resourcePath);
    }

    private boolean isInvalidEncodedResourcePath(String resourcePath) {
        if (resourcePath.contains("%")) {
            try {
                String decodedPath = URLDecoder.decode(resourcePath, "UTF-8");
                if (decodedPath.contains("../") || decodedPath.contains("..\\")) {
                    return true;
                }
            }
            catch (UnsupportedEncodingException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        return this.pattern + " -> " + this.location;
    }
}

