/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.workspace.api.git;

import com.atlassian.performance.tools.workspace.api.git.HardcodedGitRepo;
import com.atlassian.performance.tools.workspace.git.LocalGitRepo;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.lib.Repository;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/performance/tools/workspace/api/git/GitRepo;", "", "getHead", "", "Locator", "workspace"})
public interface GitRepo {
    public static final Locator Locator = com.atlassian.performance.tools.workspace.api.git.GitRepo$Locator.$$INSTANCE;

    @NotNull
    public String getHead();

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/performance/tools/workspace/api/git/GitRepo$Locator;", "", "()V", "findFromCurrentDirectory", "Lcom/atlassian/performance/tools/workspace/api/git/GitRepo;", "findFromDirectory", "pathName", "", "findInAncestors", "Lorg/eclipse/jgit/lib/Repository;", "descendant", "Ljava/io/File;", "toGitFolder", "file", "workspace"})
    public static final class Locator {
        static final /* synthetic */ Locator $$INSTANCE;

        @NotNull
        public final GitRepo findFromCurrentDirectory() {
            return this.findFromDirectory(".");
        }

        @NotNull
        public final GitRepo findFromDirectory(@NotNull String pathName) {
            GitRepo gitRepo;
            Intrinsics.checkParameterIsNotNull((Object)pathName, (String)"pathName");
            File file = new File(pathName).getAbsoluteFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"File(pathName).absoluteFile");
            Repository repository = this.findInAncestors(file);
            if (repository != null) {
                Repository repository2;
                Repository it = repository2 = repository;
                boolean bl = false;
                gitRepo = new LocalGitRepo(it);
            } else {
                gitRepo = new HardcodedGitRepo("not found");
            }
            return gitRepo;
        }

        private final Repository findInAncestors(File descendant) {
            File parent;
            File[] fileArray;
            if (descendant.isDirectory() && (fileArray = descendant.listFiles()) != null) {
                File[] fileArray2;
                File[] $receiver$iv;
                block4: {
                    $receiver$iv = fileArray;
                    File[] single$iv = null;
                    boolean found$iv = false;
                    File[] fileArray3 = $receiver$iv;
                    int n = fileArray3.length;
                    for (int i = 0; i < n; ++i) {
                        File[] element$iv;
                        File[] it = element$iv = fileArray3[i];
                        boolean bl = false;
                        File[] fileArray4 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)fileArray4, (String)"it");
                        if (!Intrinsics.areEqual((Object)fileArray4.getName(), (Object)".git")) continue;
                        if (found$iv) {
                            fileArray2 = null;
                            break block4;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    fileArray2 = fileArray = !found$iv ? null : single$iv;
                }
                if (fileArray2 != null) {
                    File[] it = $receiver$iv = fileArray;
                    boolean bl = false;
                    return (Repository)new FileRepository(this.toGitFolder((File)it));
                }
            }
            return (parent = descendant.getParentFile()) == null ? null : this.findInAncestors(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final File toGitFolder(File file) {
            MatchResult match;
            Object object;
            if (file.isDirectory()) {
                return file;
            }
            Object object2 = file;
            Object object3 = Charsets.UTF_8;
            int n = 8192;
            Object object4 = object = object2;
            object = new InputStreamReader((InputStream)(object4 = (InputStream)new FileInputStream((File)object4)), (Charset)object3);
            object2 = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
            object3 = null;
            try {
                Object it = (BufferedReader)object2;
                boolean bl = false;
                it = ((BufferedReader)it).readLine();
            }
            catch (Throwable it) {
                object3 = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
            }
            Object line = it;
            object3 = "gitdir: (.*)";
            Regex pattern = new Regex((String)object3);
            Object object5 = line;
            Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"line");
            MatchResult matchResult = match = Regex.find$default((Regex)pattern, (CharSequence)((CharSequence)object5), (int)0, (int)2, null);
            if (matchResult == null) {
                Intrinsics.throwNpe();
            }
            String path = (String)matchResult.getGroupValues().get(1);
            String gitFolderPath = StringsKt.replaceAfter$default((String)path, (String)".git", (String)"", null, (int)4, null);
            return new File(gitFolderPath);
        }

        private Locator() {
        }

        static {
            Locator locator;
            $$INSTANCE = locator = new Locator();
        }
    }
}

