/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.virtualusers.api.users;

import com.atlassian.data.generators.NameGenerator;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u0006\u0010\u000e\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/users/UserNameGenerator;", "", "()V", "collisionsSinceReset", "Ljava/util/concurrent/atomic/AtomicInteger;", "givenNamesCnt", "nameGenerator", "Lcom/atlassian/data/generators/NameGenerator;", "successesSinceLastCollision", "getNumberOfGivenNamesToGenerate", "", "onCollision", "", "givenNamesUsedOnCollision", "onSuccess", "pickRandomUnique", "", "virtual-users"})
public final class UserNameGenerator {
    private final NameGenerator nameGenerator = new NameGenerator();
    private final AtomicInteger givenNamesCnt = new AtomicInteger(1);
    private final AtomicInteger collisionsSinceReset = new AtomicInteger();
    private final AtomicInteger successesSinceLastCollision = new AtomicInteger();

    @NotNull
    public final String pickRandomUnique(int givenNamesCnt) {
        return this.nameGenerator.pickRandomUnique(givenNamesCnt);
    }

    public final int getNumberOfGivenNamesToGenerate() {
        return this.givenNamesCnt.intValue();
    }

    public final void onCollision(int givenNamesUsedOnCollision) {
        this.successesSinceLastCollision.set(0);
        int currentGivenNamesCnt = this.givenNamesCnt.get();
        if (currentGivenNamesCnt <= givenNamesUsedOnCollision && this.collisionsSinceReset.incrementAndGet() >= 2) {
            this.givenNamesCnt.compareAndSet(currentGivenNamesCnt, givenNamesUsedOnCollision + 1);
        }
    }

    public final void onSuccess() {
        if (this.successesSinceLastCollision.incrementAndGet() % 100 == 0) {
            this.collisionsSinceReset.set(0);
        }
    }
}

