/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.virtualusers.api.load;

import com.atlassian.performance.tools.jiraactions.api.SeededRandom;
import com.atlassian.performance.tools.jiraactions.api.WebJira;
import com.atlassian.performance.tools.jiraactions.api.action.Action;
import com.atlassian.performance.tools.jiraactions.api.measure.ActionMeter;
import com.atlassian.performance.tools.jiraactions.api.memories.User;
import com.atlassian.performance.tools.jiraactions.api.memories.UserMemory;
import com.atlassian.performance.tools.jiraactions.api.memories.adaptive.AdaptiveUserMemory;
import com.atlassian.performance.tools.jiraactions.api.scenario.Scenario;
import com.atlassian.performance.tools.virtualusers.BestEffortCloseable;
import com.atlassian.performance.tools.virtualusers.api.TemporalRate;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserLoad;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserOptions;
import com.atlassian.performance.tools.virtualusers.api.browsers.Browser;
import com.atlassian.performance.tools.virtualusers.api.browsers.CloseableRemoteWebDriver;
import com.atlassian.performance.tools.virtualusers.api.config.LoadThreadContainer;
import com.atlassian.performance.tools.virtualusers.api.config.VirtualUserBehavior;
import com.atlassian.performance.tools.virtualusers.api.config.VirtualUserTarget;
import com.atlassian.performance.tools.virtualusers.api.diagnostics.DiagnosisLimit;
import com.atlassian.performance.tools.virtualusers.api.diagnostics.DiagnosisPatience;
import com.atlassian.performance.tools.virtualusers.api.diagnostics.Diagnostics;
import com.atlassian.performance.tools.virtualusers.api.diagnostics.ImpatientDiagnostics;
import com.atlassian.performance.tools.virtualusers.api.diagnostics.LimitedDiagnostics;
import com.atlassian.performance.tools.virtualusers.api.diagnostics.WebDriverDiagnostics;
import com.atlassian.performance.tools.virtualusers.api.load.LoadThread;
import com.atlassian.performance.tools.virtualusers.api.load.LoadThreadFactory;
import com.atlassian.performance.tools.virtualusers.api.load.ScenarioThread;
import com.atlassian.performance.tools.virtualusers.api.load.ThrottlingActionLoop;
import com.atlassian.performance.tools.virtualusers.measure.ClusterNodeCounter;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.jcip.annotations.ThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

@ThreadSafe
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 '2\u00020\u0001:\u0003&'(B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J0\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/load/ScenarioThreadFactory;", "Lcom/atlassian/performance/tools/virtualusers/api/load/LoadThreadFactory;", "scenario", "Lcom/atlassian/performance/tools/jiraactions/api/scenario/Scenario;", "users", "", "Lcom/atlassian/performance/tools/jiraactions/api/memories/User;", "browser", "Lcom/atlassian/performance/tools/virtualusers/api/browsers/Browser;", "setUpActionRan", "Ljava/util/concurrent/atomic/AtomicBoolean;", "nodeCounter", "Lcom/atlassian/performance/tools/virtualusers/measure/ClusterNodeCounter;", "(Lcom/atlassian/performance/tools/jiraactions/api/scenario/Scenario;Ljava/util/List;Lcom/atlassian/performance/tools/virtualusers/api/browsers/Browser;Ljava/util/concurrent/atomic/AtomicBoolean;Lcom/atlassian/performance/tools/virtualusers/measure/ClusterNodeCounter;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "unallocatedUsers", "Ljava/util/Queue;", "allocateUser", "Lcom/atlassian/performance/tools/jiraactions/api/memories/UserMemory;", "random", "Lcom/atlassian/performance/tools/jiraactions/api/SeededRandom;", "prepareThread", "Lcom/atlassian/performance/tools/virtualusers/api/load/LoadThread;", "container", "Lcom/atlassian/performance/tools/virtualusers/api/config/LoadThreadContainer;", "setUpOnce", "", "behavior", "Lcom/atlassian/performance/tools/virtualusers/api/config/VirtualUserBehavior;", "webJira", "Lcom/atlassian/performance/tools/jiraactions/api/WebJira;", "meter", "Lcom/atlassian/performance/tools/jiraactions/api/measure/ActionMeter;", "target", "Lcom/atlassian/performance/tools/virtualusers/api/config/VirtualUserTarget;", "looper", "Lcom/atlassian/performance/tools/virtualusers/api/load/ThrottlingActionLoop;", "AdminUserMemory", "Companion", "CountClusterNode", "virtual-users"})
public final class ScenarioThreadFactory
implements LoadThreadFactory {
    private final Logger logger;
    private final Queue<User> unallocatedUsers;
    private final Scenario scenario;
    private final List<User> users;
    private final Browser browser;
    private final AtomicBoolean setUpActionRan;
    private final ClusterNodeCounter nodeCounter;
    private static final Duration DRIVER_CLOSE_TIMEOUT;
    public static final Companion Companion;

    @Override
    @NotNull
    public LoadThread prepareThread(@NotNull LoadThreadContainer container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        VirtualUserOptions options = container.loadProcessContainer().options();
        VirtualUserBehavior behavior = options.getBehavior();
        CloseableRemoteWebDriver closeableWebDriver = this.browser.start();
        AutoCloseable autoCloseable = closeableWebDriver;
        Duration duration = DRIVER_CLOSE_TIMEOUT;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"DRIVER_CLOSE_TIMEOUT");
        container.addCloseable(new BestEffortCloseable(autoCloseable, duration, "WebDriver", this.logger));
        RemoteWebDriver webDriver = closeableWebDriver.getDriver();
        VirtualUserTarget target = options.getTarget();
        WebJira webJira = new WebJira((WebDriver)webDriver, target.getWebApplication$virtual_users(), target.getPassword$virtual_users());
        SeededRandom random = container.seededRandom();
        UserMemory userMemory = this.allocateUser(random);
        ActionMeter meter = container.actionMeter();
        Diagnostics diagnostics = new WebDriverDiagnostics((WebDriver)webDriver, (TakesScreenshot)webDriver, container.threadResult().getDiagnoses());
        Duration duration2 = Duration.ofSeconds(5L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofSeconds(5)");
        LimitedDiagnostics diagnostics2 = new LimitedDiagnostics(new ImpatientDiagnostics(diagnostics, new DiagnosisPatience(duration2)), new DiagnosisLimit(behavior.getDiagnosticsLimit$virtual_users()));
        Action userLogin = this.scenario.getLogInAction(webJira, meter, userMemory);
        CountClusterNode countNode = new CountClusterNode(this.nodeCounter, webJira, diagnostics2);
        VirtualUserLoad load = container.singleThreadLoad();
        List list = this.scenario.getActions(webJira, random, meter);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"scenario.getActions(webJira, random, meter)");
        Diagnostics diagnostics3 = diagnostics2;
        ActionMeter actionMeter = container.taskMeter();
        TemporalRate temporalRate = load.getMaxOverallLoad();
        Iterable iterable = list;
        ThrottlingActionLoop looper = new ThrottlingActionLoop(temporalRate, actionMeter, iterable, diagnostics3);
        this.setUpOnce(behavior, webJira, meter, target, looper);
        Action action = userLogin;
        Intrinsics.checkExpressionValueIsNotNull((Object)action, (String)"userLogin");
        return new ScenarioThread(load, looper, action, countNode);
    }

    private final UserMemory allocateUser(SeededRandom random) {
        AdaptiveUserMemory memory = new AdaptiveUserMemory(random);
        User user = this.unallocatedUsers.poll();
        if (user == null) {
            throw (Throwable)new Exception("Asked for another user but all " + this.users + " are already taken");
        }
        User user2 = user;
        memory.remember((Collection)CollectionsKt.listOf((Object)user2));
        return (UserMemory)memory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setUpOnce(VirtualUserBehavior behavior, WebJira webJira, ActionMeter meter, VirtualUserTarget target, ThrottlingActionLoop looper) {
        if (!behavior.getSkipSetup$virtual_users()) {
            AtomicBoolean atomicBoolean = this.setUpActionRan;
            synchronized (atomicBoolean) {
                boolean bl = false;
                if (!this.setUpActionRan.get()) {
                    Action adminLogin = this.scenario.getLogInAction(webJira, meter, (UserMemory)new AdminUserMemory(target));
                    Action setUpAction = this.scenario.getSetupAction(webJira, meter);
                    this.logger.info("Setting up Jira...");
                    Action action = adminLogin;
                    Intrinsics.checkExpressionValueIsNotNull((Object)action, (String)"adminLogin");
                    looper.runWithDiagnostics$virtual_users(action);
                    Action action2 = setUpAction;
                    Intrinsics.checkExpressionValueIsNotNull((Object)action2, (String)"setUpAction");
                    looper.runWithDiagnostics$virtual_users(action2);
                    this.logger.info("Jira is set up");
                    this.setUpActionRan.set(true);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public ScenarioThreadFactory(@NotNull Scenario scenario, @NotNull List<User> users, @NotNull Browser browser, @NotNull AtomicBoolean setUpActionRan, @NotNull ClusterNodeCounter nodeCounter) {
        Intrinsics.checkParameterIsNotNull((Object)scenario, (String)"scenario");
        Intrinsics.checkParameterIsNotNull(users, (String)"users");
        Intrinsics.checkParameterIsNotNull((Object)browser, (String)"browser");
        Intrinsics.checkParameterIsNotNull((Object)setUpActionRan, (String)"setUpActionRan");
        Intrinsics.checkParameterIsNotNull((Object)nodeCounter, (String)"nodeCounter");
        this.scenario = scenario;
        this.users = users;
        this.browser = browser;
        this.setUpActionRan = setUpActionRan;
        this.nodeCounter = nodeCounter;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        this.unallocatedUsers = new ConcurrentLinkedQueue(this.users);
    }

    static {
        Companion = new Companion(null);
        DRIVER_CLOSE_TIMEOUT = Duration.ofSeconds(30L);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/load/ScenarioThreadFactory$AdminUserMemory;", "Lcom/atlassian/performance/tools/jiraactions/api/memories/UserMemory;", "target", "Lcom/atlassian/performance/tools/virtualusers/api/config/VirtualUserTarget;", "(Lcom/atlassian/performance/tools/virtualusers/api/config/VirtualUserTarget;)V", "recall", "Lcom/atlassian/performance/tools/jiraactions/api/memories/User;", "remember", "", "memories", "", "virtual-users"})
    private static final class AdminUserMemory
    implements UserMemory {
        private final VirtualUserTarget target;

        @NotNull
        public User recall() {
            return new User(this.target.getUserName$virtual_users(), this.target.getPassword$virtual_users());
        }

        public void remember(@NotNull Collection<User> memories) {
            Intrinsics.checkParameterIsNotNull(memories, (String)"memories");
        }

        public AdminUserMemory(@NotNull VirtualUserTarget target) {
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            this.target = target;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/load/ScenarioThreadFactory$CountClusterNode;", "Lcom/atlassian/performance/tools/jiraactions/api/action/Action;", "nodeCounter", "Lcom/atlassian/performance/tools/virtualusers/measure/ClusterNodeCounter;", "webJira", "Lcom/atlassian/performance/tools/jiraactions/api/WebJira;", "diagnostics", "Lcom/atlassian/performance/tools/virtualusers/api/diagnostics/Diagnostics;", "(Lcom/atlassian/performance/tools/virtualusers/measure/ClusterNodeCounter;Lcom/atlassian/performance/tools/jiraactions/api/WebJira;Lcom/atlassian/performance/tools/virtualusers/api/diagnostics/Diagnostics;)V", "run", "", "virtual-users"})
    private static final class CountClusterNode
    implements Action {
        private final ClusterNodeCounter nodeCounter;
        private final WebJira webJira;
        private final Diagnostics diagnostics;

        public void run() {
            this.nodeCounter.count(new Supplier<String>(this){
                final /* synthetic */ CountClusterNode this$0;

                @NotNull
                public final String get() {
                    return CountClusterNode.access$getWebJira$p(this.this$0).getJiraNode();
                }
                {
                    this.this$0 = countClusterNode;
                }
            }, this.diagnostics);
        }

        public CountClusterNode(@NotNull ClusterNodeCounter nodeCounter, @NotNull WebJira webJira, @NotNull Diagnostics diagnostics) {
            Intrinsics.checkParameterIsNotNull((Object)nodeCounter, (String)"nodeCounter");
            Intrinsics.checkParameterIsNotNull((Object)webJira, (String)"webJira");
            Intrinsics.checkParameterIsNotNull((Object)diagnostics, (String)"diagnostics");
            this.nodeCounter = nodeCounter;
            this.webJira = webJira;
            this.diagnostics = diagnostics;
        }

        public static final /* synthetic */ WebJira access$getWebJira$p(CountClusterNode $this) {
            return $this.webJira;
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/load/ScenarioThreadFactory$Companion;", "", "()V", "DRIVER_CLOSE_TIMEOUT", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getDRIVER_CLOSE_TIMEOUT$virtual_users", "()Ljava/time/Duration;", "virtual-users"})
    public static final class Companion {
        public final Duration getDRIVER_CLOSE_TIMEOUT$virtual_users() {
            return DRIVER_CLOSE_TIMEOUT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

