/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.virtualusers.api.diagnostics;

import com.atlassian.performance.tools.io.api.DirectoriesKt;
import com.atlassian.performance.tools.virtualusers.api.diagnostics.Diagnostics;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.remote.RemoteWebDriver;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/diagnostics/WebDriverDiagnostics;", "Lcom/atlassian/performance/tools/virtualusers/api/diagnostics/Diagnostics;", "driver", "Lorg/openqa/selenium/WebDriver;", "display", "Lorg/openqa/selenium/TakesScreenshot;", "(Lorg/openqa/selenium/WebDriver;Lorg/openqa/selenium/TakesScreenshot;)V", "Lorg/openqa/selenium/remote/RemoteWebDriver;", "(Lorg/openqa/selenium/remote/RemoteWebDriver;)V", "dump", "Ljava/nio/file/Path;", "(Lorg/openqa/selenium/WebDriver;Lorg/openqa/selenium/TakesScreenshot;Ljava/nio/file/Path;)V", "counter", "Ljava/util/concurrent/atomic/AtomicLong;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "diagnose", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "dumpHtml", "", "dumpDirectory", "Ljava/io/File;", "dumpLogs", "getPageSource", "saveScreenshot", "virtual-users"})
public final class WebDriverDiagnostics
implements Diagnostics {
    private final Logger logger;
    private final AtomicLong counter;
    private final WebDriver driver;
    private final TakesScreenshot display;
    private final Path dump;

    @Override
    public void diagnose(@NotNull Exception exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        File file = this.dump.resolve(String.valueOf(this.counter.incrementAndGet())).toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"dump\n            .resolv\u2026())\n            .toFile()");
        File dumpDir = DirectoriesKt.ensureDirectory((File)file);
        this.logger.error("URL: " + this.driver.getCurrentUrl() + ", " + this.dumpHtml(dumpDir) + ", " + this.saveScreenshot(dumpDir) + ", " + this.dumpLogs(dumpDir), (Throwable)exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String dumpLogs(File dumpDirectory) {
        Object object;
        File browserLogFile = new File(dumpDirectory, "browser.log");
        LogEntries logEntries = this.driver.manage().logs().get("browser");
        Intrinsics.checkExpressionValueIsNotNull((Object)logEntries, (String)"driver.manage().logs().get(LogType.BROWSER)");
        String browserLog = CollectionsKt.joinToString$default((Iterable)((Iterable)logEntries), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        Object object2 = browserLogFile;
        Object object3 = Charsets.UTF_8;
        int n = 8192;
        Object object4 = object = object2;
        object4 = new FileOutputStream((File)object4);
        object = new OutputStreamWriter((OutputStream)object4, (Charset)object3);
        object2 = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        object3 = null;
        try {
            BufferedWriter it = (BufferedWriter)object2;
            boolean bl = false;
            it.write(browserLog);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        return "Browser log dumped at " + browserLogFile.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String dumpHtml(File dumpDirectory) {
        String string;
        String pageSource = this.getPageSource(this.driver);
        if (pageSource != null) {
            Object object;
            File htmlDumpFile = new File(dumpDirectory, "dump.html");
            Object object2 = htmlDumpFile;
            Object object3 = Charsets.UTF_8;
            int n = 8192;
            Object object4 = object = object2;
            object = new OutputStreamWriter((OutputStream)(object4 = (OutputStream)new FileOutputStream((File)object4)), (Charset)object3);
            object2 = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
            object3 = null;
            try {
                BufferedWriter it = (BufferedWriter)object2;
                boolean bl = false;
                it.write(pageSource);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
            }
            string = "HTML dumped at " + htmlDumpFile.getPath();
        } else {
            string = "The page had no HTML.";
        }
        return string;
    }

    private final String getPageSource(WebDriver driver) {
        WebDriver webDriver = driver;
        if (webDriver == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.openqa.selenium.JavascriptExecutor");
        }
        JavascriptExecutor javascriptExecutor = (JavascriptExecutor)webDriver;
        Object html = javascriptExecutor.executeScript("return document.documentElement && (document.documentElement.outerHTML || document.documentElement.innerHTML)", new Object[0]);
        return (String)html;
    }

    private final String saveScreenshot(File dumpDirectory) {
        String string;
        try {
            String string2;
            File screenshot = new File(dumpDirectory, "screenshot.png");
            File temporaryScreenshot = (File)this.display.getScreenshotAs(OutputType.FILE);
            boolean moved = temporaryScreenshot.renameTo(screenshot);
            if (moved) {
                string2 = "screenshot saved to " + screenshot.getPath();
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("screenshot failed to migrate from ");
                File file = temporaryScreenshot;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"temporaryScreenshot");
                string2 = stringBuilder.append(file.getPath()).toString();
            }
            string = string2;
        }
        catch (Exception e) {
            this.logger.error("Failed to take a screenshot", (Throwable)e);
            string = "screenshot failed";
        }
        return string;
    }

    public WebDriverDiagnostics(@NotNull WebDriver driver, @NotNull TakesScreenshot display, @NotNull Path dump) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull((Object)display, (String)"display");
        Intrinsics.checkParameterIsNotNull((Object)dump, (String)"dump");
        this.driver = driver;
        this.display = display;
        this.dump = dump;
        this.logger = LogManager.getLogger(this.getClass());
        this.counter = new AtomicLong(0L);
    }

    public WebDriverDiagnostics(@NotNull WebDriver driver, @NotNull TakesScreenshot display) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull((Object)display, (String)"display");
        Path path = Paths.get("diagnoses", new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(\"diagnoses\")");
        this(driver, display, path);
    }

    public WebDriverDiagnostics(@NotNull RemoteWebDriver driver) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        this((WebDriver)driver, (TakesScreenshot)driver);
    }
}

