/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.virtualusers.api;

import com.atlassian.performance.tools.virtualusers.LoadTest;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserOptions;
import com.atlassian.performance.tools.virtualusers.logs.LogConfiguration;
import com.atlassian.performance.tools.virtualusers.logs.LogConfigurationFactory;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0019\u0010\u000e\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/performance/tools/virtualusers/api/Application;", "", "()V", "defaultLogConfigFactory", "Lcom/atlassian/performance/tools/virtualusers/logs/LogConfigurationFactory;", "run", "", "args", "", "", "([Ljava/lang/String;)V", "setLoggingConfiguration", "options", "Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserOptions;", "tryRunning", "virtual-users"})
public final class Application {
    private final LogConfigurationFactory defaultLogConfigFactory = new LogConfigurationFactory(new LogConfiguration());

    public final void tryRunning(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)this.defaultLogConfigFactory);
        try {
            this.run(args);
        }
        catch (Exception e) {
            String errorMessage = "Failed to run with " + ArraysKt.toList((Object[])args);
            LogManager.getLogger(this.getClass()).error(errorMessage);
            throw (Throwable)new Exception(errorMessage, e);
        }
    }

    private final void run(String[] args) {
        VirtualUserOptions options = new VirtualUserOptions.Parser().parse(args);
        this.setLoggingConfiguration(options);
        if (options.getHelp()) {
            options.printHelp();
        } else {
            new LoadTest(options).run();
        }
    }

    private final void setLoggingConfiguration(VirtualUserOptions options) {
        Class<? extends AbstractConfiguration> logging = options.getBehavior().getLogging$virtual_users();
        AbstractConfiguration abstractConfiguration = logging.getConstructor(new Class[0]).newInstance(new Object[0]);
        if (abstractConfiguration == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.logging.log4j.core.config.AbstractConfiguration");
        }
        AbstractConfiguration logConfig = abstractConfiguration;
        LogConfigurationFactory logConfigurationFactory = new LogConfigurationFactory(logConfig);
        ConfigurationFactory.setConfigurationFactory((ConfigurationFactory)logConfigurationFactory);
        org.apache.logging.log4j.spi.LoggerContext loggerContext = LogManager.getContext((boolean)false);
        if (loggerContext == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.apache.logging.log4j.core.LoggerContext");
        }
        LoggerContext context = (LoggerContext)loggerContext;
        context.start(logConfigurationFactory.getConfiguration(null, ConfigurationSource.NULL_SOURCE));
    }
}

