/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.ssh.api;

import com.atlassian.performance.tools.ssh.api.DetachedProcess;
import com.atlassian.performance.tools.ssh.api.SshHost;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmDefault;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001:\u0001\u001bJ\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0017J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0017J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH&J\b\u0010\u0010\u001a\u00020\u0011H\u0017J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0017J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0017J(\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH&J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u0005H'J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0014H'J\u0018\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u0091(0\u0001\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "Ljava/io/Closeable;", "download", "", "remoteSource", "", "localDestination", "Ljava/nio/file/Path;", "execute", "Lcom/atlassian/performance/tools/ssh/api/SshConnection$SshResult;", "cmd", "timeout", "Ljava/time/Duration;", "stdout", "Lorg/apache/logging/log4j/Level;", "stderr", "getHost", "Lcom/atlassian/performance/tools/ssh/api/SshHost;", "safeExecute", "startProcess", "Lcom/atlassian/performance/tools/ssh/api/DetachedProcess;", "stopProcess", "process", "upload", "localSource", "Ljava/io/File;", "remoteDestination", "SshResult", "ssh"})
public interface SshConnection
extends Closeable {
    @JvmDefault
    @NotNull
    default public SshResult execute(@NotNull String cmd) {
        Intrinsics.checkParameterIsNotNull((Object)cmd, (String)"cmd");
        Duration duration = Duration.ofSeconds(30L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(30)");
        Level level = Level.DEBUG;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.DEBUG");
        Level level2 = Level.WARN;
        Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.WARN");
        return this.execute(cmd, duration, level, level2);
    }

    @JvmDefault
    @NotNull
    default public SshResult execute(@NotNull String cmd, @NotNull Duration timeout) {
        Intrinsics.checkParameterIsNotNull((Object)cmd, (String)"cmd");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        Level level = Level.DEBUG;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.DEBUG");
        Level level2 = Level.WARN;
        Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.WARN");
        return this.execute(cmd, timeout, level, level2);
    }

    @NotNull
    public SshResult execute(@NotNull String var1, @NotNull Duration var2, @NotNull Level var3, @NotNull Level var4);

    @JvmDefault
    @NotNull
    default public SshResult safeExecute(@NotNull String cmd) {
        Intrinsics.checkParameterIsNotNull((Object)cmd, (String)"cmd");
        Duration duration = Duration.ofSeconds(30L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(30)");
        Level level = Level.TRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.TRACE");
        Level level2 = Level.DEBUG;
        Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.DEBUG");
        return this.safeExecute(cmd, duration, level, level2);
    }

    @JvmDefault
    @NotNull
    default public SshResult safeExecute(@NotNull String cmd, @NotNull Duration timeout) {
        Intrinsics.checkParameterIsNotNull((Object)cmd, (String)"cmd");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        Level level = Level.TRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.TRACE");
        Level level2 = Level.DEBUG;
        Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.DEBUG");
        return this.safeExecute(cmd, timeout, level, level2);
    }

    @NotNull
    public SshResult safeExecute(@NotNull String var1, @NotNull Duration var2, @NotNull Level var3, @NotNull Level var4);

    @Deprecated(message="Use Ssh.runInBackground instead")
    @NotNull
    public DetachedProcess startProcess(@NotNull String var1);

    @Deprecated(message="Use BackgroundProcess.stop instead")
    public void stopProcess(@NotNull DetachedProcess var1);

    public void download(@NotNull String var1, @NotNull Path var2);

    public void upload(@NotNull File var1, @NotNull String var2);

    @JvmDefault
    @NotNull
    default public SshHost getHost() {
        throw (Throwable)new Exception("Not implemented");
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\u0015\u001a\u00020\u0012J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/performance/tools/ssh/api/SshConnection$SshResult;", "", "exitStatus", "", "output", "", "errorOutput", "(ILjava/lang/String;Ljava/lang/String;)V", "getErrorOutput", "()Ljava/lang/String;", "getExitStatus", "()I", "getOutput", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "isSuccessful", "toString", "ssh"})
    public static final class SshResult {
        private final int exitStatus;
        @NotNull
        private final String output;
        @NotNull
        private final String errorOutput;

        public final boolean isSuccessful() {
            return this.exitStatus == 0;
        }

        public final int getExitStatus() {
            return this.exitStatus;
        }

        @NotNull
        public final String getOutput() {
            return this.output;
        }

        @NotNull
        public final String getErrorOutput() {
            return this.errorOutput;
        }

        public SshResult(int exitStatus, @NotNull String output, @NotNull String errorOutput) {
            Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
            Intrinsics.checkParameterIsNotNull((Object)errorOutput, (String)"errorOutput");
            this.exitStatus = exitStatus;
            this.output = output;
            this.errorOutput = errorOutput;
        }

        public final int component1() {
            return this.exitStatus;
        }

        @NotNull
        public final String component2() {
            return this.output;
        }

        @NotNull
        public final String component3() {
            return this.errorOutput;
        }

        @NotNull
        public final SshResult copy(int exitStatus, @NotNull String output, @NotNull String errorOutput) {
            Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
            Intrinsics.checkParameterIsNotNull((Object)errorOutput, (String)"errorOutput");
            return new SshResult(exitStatus, output, errorOutput);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ SshResult copy$default(SshResult sshResult, int n, String string, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = sshResult.exitStatus;
            }
            if ((n2 & 2) != 0) {
                string = sshResult.output;
            }
            if ((n2 & 4) != 0) {
                string2 = sshResult.errorOutput;
            }
            return sshResult.copy(n, string, string2);
        }

        @NotNull
        public String toString() {
            return "SshResult(exitStatus=" + this.exitStatus + ", output=" + this.output + ", errorOutput=" + this.errorOutput + ")";
        }

        public int hashCode() {
            String string = this.output;
            String string2 = this.errorOutput;
            return (Integer.hashCode(this.exitStatus) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SshResult)) break block3;
                    SshResult sshResult = (SshResult)object;
                    if (!(this.exitStatus == sshResult.exitStatus) || !Intrinsics.areEqual((Object)this.output, (Object)sshResult.output) || !Intrinsics.areEqual((Object)this.errorOutput, (Object)sshResult.errorOutput)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

