/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.ssh.api;

import com.atlassian.performance.tools.jvmtasks.api.Backoff;
import com.atlassian.performance.tools.jvmtasks.api.ExponentialBackoff;
import com.atlassian.performance.tools.jvmtasks.api.IdempotentAction;
import com.atlassian.performance.tools.ssh.PerformanceDefaultConfig;
import com.atlassian.performance.tools.ssh.SshjBackgroundProcess;
import com.atlassian.performance.tools.ssh.SshjConnection;
import com.atlassian.performance.tools.ssh.api.BackgroundProcess;
import com.atlassian.performance.tools.ssh.api.Ssh;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import com.atlassian.performance.tools.ssh.api.SshHost;
import com.atlassian.performance.tools.ssh.port.LocalPort;
import com.atlassian.performance.tools.ssh.port.RemotePort;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.schmizz.keepalive.KeepAlive;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0006H\u00c2\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\t\u0010\u001e\u001a\u00020\u001dH\u00d6\u0001J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0019H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Lcom/atlassian/performance/tools/ssh/api/Ssh;", "", "host", "Lcom/atlassian/performance/tools/ssh/api/SshHost;", "(Lcom/atlassian/performance/tools/ssh/api/SshHost;)V", "connectivityPatience", "", "(Lcom/atlassian/performance/tools/ssh/api/SshHost;I)V", "getHost", "()Lcom/atlassian/performance/tools/ssh/api/SshHost;", "component1", "component2", "copy", "equals", "", "other", "forwardLocalPort", "Ljava/lang/AutoCloseable;", "localPort", "remotePort", "forwardRemotePort", "hashCode", "newConnection", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "prepareClient", "Lnet/schmizz/sshj/SSHClient;", "runInBackground", "Lcom/atlassian/performance/tools/ssh/api/BackgroundProcess;", "cmd", "", "toString", "waitForConnectivity", "", "ssh"})
public final class Ssh {
    @NotNull
    private final SshHost host;
    private final int connectivityPatience;

    @NotNull
    public final SshConnection newConnection() {
        return new SshjConnection(this.prepareClient(), this.host);
    }

    @NotNull
    public final BackgroundProcess runInBackground(@NotNull String cmd) {
        Intrinsics.checkParameterIsNotNull((Object)cmd, (String)"cmd");
        Session session = this.prepareClient().startSession();
        session.allocateDefaultPTY();
        Session.Command command = session.exec(cmd);
        Session session2 = session;
        Intrinsics.checkExpressionValueIsNotNull((Object)session2, (String)"session");
        Session.Command command2 = command;
        Intrinsics.checkExpressionValueIsNotNull((Object)command2, (String)"command");
        return new SshjBackgroundProcess(session2, command2);
    }

    @NotNull
    public final AutoCloseable forwardLocalPort(int localPort, int remotePort) {
        return LocalPort.Companion.create$ssh(localPort).forward$ssh(this.prepareClient(), remotePort);
    }

    @NotNull
    public final AutoCloseable forwardRemotePort(int localPort, int remotePort) {
        return RemotePort.Companion.create$ssh(remotePort).forward$ssh(this.prepareClient(), localPort);
    }

    private final SSHClient prepareClient() {
        SSHClient ssh = new SSHClient((Config)new PerformanceDefaultConfig());
        Connection connection = ssh.getConnection();
        Intrinsics.checkExpressionValueIsNotNull((Object)connection, (String)"ssh.connection");
        KeepAlive keepAlive = connection.getKeepAlive();
        Intrinsics.checkExpressionValueIsNotNull((Object)keepAlive, (String)"ssh.connection.keepAlive");
        keepAlive.setKeepAliveInterval(60);
        ssh.addHostKeyVerifier((HostKeyVerifier)prepareClient.1.INSTANCE);
        this.waitForConnectivity(ssh);
        this.host.getAuthentication().authenticate$ssh(this.host.getUserName(), ssh);
        return ssh;
    }

    private final void waitForConnectivity(SSHClient ssh) {
        String address = this.host.getIpAddress();
        int port = this.host.getPort();
        IdempotentAction idempotentAction = new IdempotentAction("connect to " + address + " on port " + port, (Function0)new Function0<Unit>(ssh, address, port){
            final /* synthetic */ SSHClient $ssh;
            final /* synthetic */ String $address;
            final /* synthetic */ int $port;

            public final void invoke() {
                this.$ssh.connect(this.$address, this.$port);
            }
            {
                this.$ssh = sSHClient;
                this.$address = string;
                this.$port = n;
                super(0);
            }
        });
        Duration duration = Duration.ofSeconds(1L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(1)");
        idempotentAction.retry(this.connectivityPatience, (Backoff)new ExponentialBackoff(duration, 0.0, 2, null));
    }

    @NotNull
    public final SshHost getHost() {
        return this.host;
    }

    public Ssh(@NotNull SshHost host, int connectivityPatience) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        this.host = host;
        this.connectivityPatience = connectivityPatience;
    }

    public Ssh(@NotNull SshHost host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        this(host, 4);
    }

    @NotNull
    public final SshHost component1() {
        return this.host;
    }

    private final int component2() {
        return this.connectivityPatience;
    }

    @NotNull
    public final Ssh copy(@NotNull SshHost host, int connectivityPatience) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        return new Ssh(host, connectivityPatience);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Ssh copy$default(Ssh ssh, SshHost sshHost, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            sshHost = ssh.host;
        }
        if ((n2 & 2) != 0) {
            n = ssh.connectivityPatience;
        }
        return ssh.copy(sshHost, n);
    }

    @NotNull
    public String toString() {
        return "Ssh(host=" + this.host + ", connectivityPatience=" + this.connectivityPatience + ")";
    }

    public int hashCode() {
        SshHost sshHost = this.host;
        return (sshHost != null ? ((Object)sshHost).hashCode() : 0) * 31 + Integer.hashCode(this.connectivityPatience);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Ssh)) break block3;
                Ssh ssh = (Ssh)object;
                if (!Intrinsics.areEqual((Object)this.host, (Object)ssh.host) || !(this.connectivityPatience == ssh.connectivityPatience)) break block3;
            }
            return true;
        }
        return false;
    }
}

