/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.ssh;

import com.atlassian.performance.tools.io.api.DirectoriesKt;
import com.atlassian.performance.tools.ssh.WaitingCommand;
import com.atlassian.performance.tools.ssh.api.DetachedProcess;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import com.atlassian.performance.tools.ssh.api.SshHost;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.xfer.scp.SCPFileTransfer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J(\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J0\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\rH\u0016J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u001dH\u0016J\u0018\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\rH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0002"}, d2={"Lcom/atlassian/performance/tools/ssh/SshjConnection;", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "ssh", "Lnet/schmizz/sshj/SSHClient;", "sshHost", "Lcom/atlassian/performance/tools/ssh/api/SshHost;", "(Lnet/schmizz/sshj/SSHClient;Lcom/atlassian/performance/tools/ssh/api/SshHost;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "close", "", "download", "remoteSource", "", "localDestination", "Ljava/nio/file/Path;", "execute", "Lcom/atlassian/performance/tools/ssh/api/SshConnection$SshResult;", "cmd", "timeout", "Ljava/time/Duration;", "stdout", "Lorg/apache/logging/log4j/Level;", "stderr", "getHost", "safeExecute", "session", "Lnet/schmizz/sshj/connection/channel/direct/Session;", "startProcess", "Lcom/atlassian/performance/tools/ssh/api/DetachedProcess;", "stopProcess", "process", "upload", "localSource", "Ljava/io/File;", "remoteDestination"})
public final class SshjConnection
implements SshConnection {
    private final Logger logger;
    private final SSHClient ssh;
    private final SshHost sshHost;

    @Override
    @NotNull
    public SshConnection.SshResult execute(@NotNull String cmd, @NotNull Duration timeout, @NotNull Level stdout, @NotNull Level stderr) {
        Intrinsics.checkParameterIsNotNull((Object)cmd, (String)"cmd");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        Intrinsics.checkParameterIsNotNull((Object)stdout, (String)"stdout");
        Intrinsics.checkParameterIsNotNull((Object)stderr, (String)"stderr");
        SshConnection.SshResult sshResult = this.safeExecute(cmd, timeout, stdout, stderr);
        if (!sshResult.isSuccessful()) {
            throw (Throwable)new Exception("Error while executing " + cmd + ". Exit status code " + sshResult);
        }
        return sshResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public SshConnection.SshResult safeExecute(@NotNull String cmd, @NotNull Duration timeout, @NotNull Level stdout, @NotNull Level stderr) {
        SshConnection.SshResult sshResult;
        Intrinsics.checkParameterIsNotNull((Object)cmd, (String)"cmd");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        Intrinsics.checkParameterIsNotNull((Object)stdout, (String)"stdout");
        Intrinsics.checkParameterIsNotNull((Object)stderr, (String)"stderr");
        Closeable closeable = (Closeable)this.ssh.startSession();
        Throwable throwable = null;
        try {
            Session it;
            Session session = it = (Session)closeable;
            Intrinsics.checkExpressionValueIsNotNull((Object)session, (String)"it");
            sshResult = this.safeExecute(session, cmd, timeout, stdout, stderr);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return sshResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SshConnection.SshResult safeExecute(Session session, String cmd, Duration timeout, Level stdout, Level stderr) {
        SshConnection.SshResult sshResult;
        this.logger.debug(this.sshHost.getUserName() + '@' + this.sshHost.getIpAddress() + "$ " + cmd);
        Closeable closeable = (Closeable)session.exec(cmd);
        Throwable throwable = null;
        try {
            Session.Command command;
            Session.Command command2 = command = (Session.Command)closeable;
            Intrinsics.checkExpressionValueIsNotNull((Object)command2, (String)"command");
            sshResult = new WaitingCommand(command2, timeout, stdout, stderr).waitForResult();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return sshResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public DetachedProcess startProcess(@NotNull String cmd) {
        DetachedProcess detachedProcess;
        Intrinsics.checkParameterIsNotNull((Object)cmd, (String)"cmd");
        Closeable closeable = (Closeable)this.ssh.startSession();
        Throwable throwable = null;
        try {
            Session it;
            Session session = it = (Session)closeable;
            Intrinsics.checkExpressionValueIsNotNull((Object)session, (String)"it");
            detachedProcess = DetachedProcess.Companion.start(cmd, session);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return detachedProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopProcess(@NotNull DetachedProcess process) {
        Intrinsics.checkParameterIsNotNull((Object)process, (String)"process");
        Closeable closeable = (Closeable)this.ssh.startSession();
        Throwable throwable = null;
        try {
            Session it;
            Session session = it = (Session)closeable;
            Intrinsics.checkExpressionValueIsNotNull((Object)session, (String)"it");
            process.stop$ssh(session);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    public void download(@NotNull String remoteSource, @NotNull Path localDestination) {
        Intrinsics.checkParameterIsNotNull((Object)remoteSource, (String)"remoteSource");
        Intrinsics.checkParameterIsNotNull((Object)localDestination, (String)"localDestination");
        File file = localDestination.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"localDestination.toFile()");
        File file2 = file.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"localDestination.toFile().parentFile");
        DirectoriesKt.ensureDirectory((File)file2);
        SCPFileTransfer scpFileTransfer = this.ssh.newSCPFileTransfer();
        scpFileTransfer.download(remoteSource, ((Object)localDestination).toString());
    }

    @Override
    public void upload(@NotNull File localSource, @NotNull String remoteDestination) {
        Intrinsics.checkParameterIsNotNull((Object)localSource, (String)"localSource");
        Intrinsics.checkParameterIsNotNull((Object)remoteDestination, (String)"remoteDestination");
        SCPFileTransfer scpFileTransfer = this.ssh.newSCPFileTransfer();
        scpFileTransfer.upload(localSource.getAbsolutePath(), remoteDestination);
    }

    @Override
    @NotNull
    public SshHost getHost() {
        return this.sshHost;
    }

    @Override
    public void close() {
        this.ssh.close();
    }

    public SshjConnection(@NotNull SSHClient ssh, @NotNull SshHost sshHost) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)sshHost, (String)"sshHost");
        this.ssh = ssh;
        this.sshHost = sshHost;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }
}

