/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.testutils.parser;

import java.io.DataOutput;
import java.io.IOException;
import org.openjdk.jmc.flightrecorder.testutils.parser.RecordingStream;

public final class ChunkHeader {
    public static final byte[] MAGIC = new byte[]{70, 76, 82, 0};
    public final short major;
    public final short minor;
    public final long size;
    public final long checkpointEventOffset;
    public final long metadataOffset;
    public final long startNanos;
    public final long durationNanos;
    public final long startTicks;
    public final long frequency;
    public final boolean compressed;
    public static int SIZE = MAGIC.length + 4 + 56 + 4;

    public static ChunkHeader read(RecordingStream recording) throws IOException {
        byte[] buffer = new byte[MAGIC.length];
        recording.read(buffer, 0, MAGIC.length);
        for (int i = 0; i < MAGIC.length; ++i) {
            if (buffer[i] == MAGIC[i]) continue;
            throw new IOException("Invalid JFR Magic Number: " + ChunkHeader.bytesToString(buffer, 0, MAGIC.length));
        }
        return new Builder().major(recording.readShort()).minor(recording.readShort()).size(recording.readLong()).cpOffset(recording.readLong()).metaOffset(recording.readLong()).startNanos(recording.readLong()).duration(recording.readLong()).startTicks(recording.readLong()).frequency(recording.readLong()).compressed(recording.readInt() != 0).build();
    }

    public void write(DataOutput output) throws IOException {
        output.write(MAGIC);
        output.writeShort(this.major);
        output.writeShort(this.minor);
        output.writeLong(this.size);
        output.writeLong(this.checkpointEventOffset);
        output.writeLong(this.metadataOffset);
        output.writeLong(this.startNanos);
        output.writeLong(this.durationNanos);
        output.writeLong(this.startTicks);
        output.writeLong(this.frequency);
        output.writeInt(this.compressed ? 1 : 0);
    }

    ChunkHeader(Builder builder) {
        this.major = builder.major;
        this.minor = builder.minor;
        this.size = builder.size;
        this.checkpointEventOffset = builder.cpOffset;
        this.metadataOffset = builder.metaOffset;
        this.startNanos = builder.startNanos;
        this.durationNanos = builder.duration;
        this.startTicks = builder.startTicks;
        this.frequency = builder.frequency;
        this.compressed = builder.compressed;
    }

    public String toString() {
        return "ChunkHeader{major=" + this.major + ", minor=" + this.minor + ", size=" + this.size + ", cpOffset=" + this.checkpointEventOffset + ", metaOffset=" + this.metadataOffset + ", startNanos=" + this.startNanos + ", duration=" + this.durationNanos + ", startTicks=" + this.startTicks + ", frequency=" + this.frequency + ", compressed=" + this.compressed + "}";
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private static String bytesToString(byte[] array, int offset, int len) {
        StringBuilder sb = new StringBuilder("[");
        boolean comma = false;
        for (int i = 0; i < len; ++i) {
            if (comma) {
                sb.append(", ");
            } else {
                comma = true;
            }
            sb.append(array[i + offset]);
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkHeader that = (ChunkHeader)o;
        if (this.major != that.major) {
            return false;
        }
        if (this.minor != that.minor) {
            return false;
        }
        if (this.size != that.size) {
            return false;
        }
        if (this.checkpointEventOffset != that.checkpointEventOffset) {
            return false;
        }
        if (this.metadataOffset != that.metadataOffset) {
            return false;
        }
        if (this.startNanos != that.startNanos) {
            return false;
        }
        if (this.durationNanos != that.durationNanos) {
            return false;
        }
        if (this.startTicks != that.startTicks) {
            return false;
        }
        if (this.frequency != that.frequency) {
            return false;
        }
        return this.compressed == that.compressed;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (int)(this.checkpointEventOffset ^ this.checkpointEventOffset >>> 32);
        result = 31 * result + (int)(this.metadataOffset ^ this.metadataOffset >>> 32);
        result = 31 * result + (int)(this.startNanos ^ this.startNanos >>> 32);
        result = 31 * result + (int)(this.durationNanos ^ this.durationNanos >>> 32);
        result = 31 * result + (int)(this.startTicks ^ this.startTicks >>> 32);
        result = 31 * result + (int)(this.frequency ^ this.frequency >>> 32);
        result = 31 * result + (this.compressed ? 1 : 0);
        return result;
    }

    public static class Builder {
        private short major;
        private short minor;
        private long size;
        private long cpOffset;
        private long metaOffset;
        private long startNanos;
        private long duration;
        private long startTicks;
        private long frequency;
        private boolean compressed;

        public Builder() {
        }

        public Builder(ChunkHeader header) {
            this.major = header.major;
            this.minor = header.minor;
            this.size = header.size;
            this.cpOffset = header.checkpointEventOffset;
            this.metaOffset = header.metadataOffset;
            this.startNanos = header.startNanos;
            this.duration = header.durationNanos;
            this.startTicks = header.startTicks;
            this.frequency = header.frequency;
            this.compressed = header.compressed;
        }

        public Builder major(short major) {
            this.major = major;
            return this;
        }

        public Builder minor(short minor) {
            this.minor = minor;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public Builder cpOffset(long cpOffset) {
            this.cpOffset = cpOffset;
            return this;
        }

        public Builder metaOffset(long metaOffset) {
            this.metaOffset = metaOffset;
            return this;
        }

        public Builder startNanos(long startNanos) {
            this.startNanos = startNanos;
            return this;
        }

        public Builder duration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder startTicks(long startTicks) {
            this.startTicks = startTicks;
            return this;
        }

        public Builder frequency(long frequency) {
            this.frequency = frequency;
            return this;
        }

        public Builder compressed(boolean compressed) {
            this.compressed = compressed;
            return this;
        }

        public ChunkHeader build() {
            return new ChunkHeader(this);
        }
    }
}

