/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.vmstat;

import com.atlassian.performance.tools.infrastructure.api.metric.Dimension;
import com.atlassian.performance.tools.infrastructure.api.metric.SystemMetric;
import com.atlassian.performance.tools.report.vmstat.VmstatHeader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/performance/tools/report/vmstat/VmstatParser;", "", "()V", "parse", "", "Lcom/atlassian/performance/tools/infrastructure/api/metric/SystemMetric;", "inputStream", "Ljava/io/InputStream;", "system", "", "parse$report", "parseRecord", "record", "Lorg/apache/commons/csv/CSVRecord;", "parseStart", "Ljava/time/Instant;", "parseValue", "", "report"})
public final class VmstatParser {
    @NotNull
    public final List<SystemMetric> parse$report(@NotNull InputStream inputStream, @NotNull String system) {
        CSVParser cSVParser;
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        Intrinsics.checkParameterIsNotNull((Object)system, (String)"system");
        InputStream inputStream2 = inputStream;
        CSVParser cSVParser2 = cSVParser;
        CSVParser cSVParser3 = cSVParser;
        Charset charset = Charsets.UTF_8;
        Closeable closeable = inputStream2;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        int n = 8192;
        BufferedReader bufferedReader = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        cSVParser2((Reader)bufferedReader, CSVFormat.DEFAULT.withHeader(VmstatHeader.class));
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)cSVParser3)), (Function1)((Function1)new Function1<CSVRecord, SystemMetric>(this, system){
            final /* synthetic */ VmstatParser this$0;
            final /* synthetic */ String $system;

            @NotNull
            public final SystemMetric invoke(CSVRecord record) {
                CSVRecord cSVRecord = record;
                Intrinsics.checkExpressionValueIsNotNull((Object)cSVRecord, (String)"record");
                return VmstatParser.access$parseRecord(this.this$0, cSVRecord, this.$system);
            }
            {
                this.this$0 = vmstatParser;
                this.$system = string;
                super(1);
            }
        })));
    }

    private final SystemMetric parseRecord(CSVRecord record, String system) {
        return new SystemMetric(this.parseStart(record), Dimension.CPU_LOAD, this.parseValue(record), system);
    }

    private final Instant parseStart(CSVRecord record) {
        Instant instant = ZonedDateTime.of(LocalDate.parse(record.get((Enum)VmstatHeader.DATE)), LocalTime.parse(record.get((Enum)VmstatHeader.TIME)), ZoneId.of("UTC")).toInstant();
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"ZonedDateTime.of(\n      \u2026C\")\n        ).toInstant()");
        return instant;
    }

    private final double parseValue(CSVRecord record) {
        String string = record.get((Enum)VmstatHeader.US);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"record.get(VmstatHeader.US)");
        String string2 = string;
        double d = Double.parseDouble(string2);
        String string3 = record.get((Enum)VmstatHeader.SY);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"record.get(VmstatHeader.SY)");
        string2 = string3;
        double d2 = d;
        double d3 = Double.parseDouble(string2);
        return d2 + d3;
    }

    @NotNull
    public static final /* synthetic */ SystemMetric access$parseRecord(VmstatParser $this, @NotNull CSVRecord record, @NotNull String system) {
        return $this.parseRecord(record, system);
    }
}

