/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.result;

import com.atlassian.performance.tools.jiraactions.api.ActionMetric;
import com.atlassian.performance.tools.jiraactions.api.ActionMetricStatistics;
import com.atlassian.performance.tools.jiraactions.api.ActionType;
import com.atlassian.performance.tools.report.ActionMetricsReader;
import com.atlassian.performance.tools.report.api.OutlierTrimming;
import com.atlassian.performance.tools.report.api.result.DurationData;
import com.atlassian.performance.tools.report.api.result.EdibleResult;
import com.atlassian.performance.tools.report.api.result.Stats;
import com.atlassian.performance.tools.report.result.PerformanceStats;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J7\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u000e2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000fJ>\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u000e2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\u000eH\u0002J=\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0016\u0010\u0010\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0017\u0012\u0004\u0012\u00020\r0\u000eH\u0000\u00a2\u0006\u0002\b\u0018J\"\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/performance/tools/report/result/InternalStatsMeter;", "", "()V", "calculate", "Ljava/time/Duration;", "label", "", "metrics", "", "Lcom/atlassian/performance/tools/jiraactions/api/ActionMetric;", "metric", "Lorg/apache/commons/math3/stat/descriptive/UnivariateStatistic;", "outlierTrimming", "Lcom/atlassian/performance/tools/report/api/OutlierTrimming;", "", "calculate$report", "trimmingPerType", "measurePerformance", "Lcom/atlassian/performance/tools/report/api/result/Stats;", "result", "Lcom/atlassian/performance/tools/report/api/result/EdibleResult;", "centralTendencyMetric", "dispersionMetric", "Lcom/atlassian/performance/tools/jiraactions/api/ActionType;", "measurePerformance$report", "measureWithoutOutliers", "data", "Lcom/atlassian/performance/tools/report/api/result/DurationData;", "Companion", "report"})
public final class InternalStatsMeter {
    private static final OutlierTrimming DEFAULT_TRIMMING;
    @Deprecated
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Stats measurePerformance$report(@NotNull EdibleResult result, @NotNull UnivariateStatistic centralTendencyMetric, @NotNull UnivariateStatistic dispersionMetric, @NotNull Map<ActionType<?>, OutlierTrimming> trimmingPerType) {
        Object object;
        void $receiver$iv$iv;
        Map<ActionType<?>, OutlierTrimming> $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)centralTendencyMetric, (String)"centralTendencyMetric");
        Intrinsics.checkParameterIsNotNull((Object)dispersionMetric, (String)"dispersionMetric");
        Intrinsics.checkParameterIsNotNull(trimmingPerType, (String)"trimmingPerType");
        if (result.getFailure() != null) {
            return new PerformanceStats(result.getCohort(), MapsKt.emptyMap(), MapsKt.emptyMap(), MapsKt.emptyMap(), MapsKt.emptyMap());
        }
        List<ActionMetric> metrics = result.getActionMetrics();
        ActionMetricStatistics statistics = new ActionMetricStatistics(metrics);
        Map<ActionType<?>, OutlierTrimming> map2 = $receiver$iv = trimmingPerType;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it$iv$iv;
            void it;
            object = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            String string = ((ActionType)it.getKey()).getLabel();
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            String string2 = string;
            Map map4 = map3;
            Object v = it$iv$iv.getValue();
            map4.put(string2, v);
        }
        Map outliersPerLabel = destination$iv$iv;
        Map<String, Duration> centers = this.calculate(metrics, centralTendencyMetric, outliersPerLabel);
        Map<String, Duration> dispersions = this.calculate(metrics, dispersionMetric, outliersPerLabel);
        Map sampleSizes = new LinkedHashMap();
        Map errors = new LinkedHashMap();
        for (String label : result.getActionLabels()) {
            object = sampleSizes;
            Number number = ((Number)statistics.getSampleSize().getOrDefault(label, 0)).intValue();
            object.put(label, number);
            object = errors;
            number = statistics.getErrors().getOrDefault(label, 0);
            object.put(label, number);
        }
        return new PerformanceStats(result.getCohort(), sampleSizes, centers, dispersions, errors);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Duration> calculate$report(@NotNull List<ActionMetric> metrics, @NotNull UnivariateStatistic metric, @NotNull OutlierTrimming outlierTrimming) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(metrics, (String)"metrics");
        Intrinsics.checkParameterIsNotNull((Object)metric, (String)"metric");
        Intrinsics.checkParameterIsNotNull((Object)outlierTrimming, (String)"outlierTrimming");
        Iterable iterable = $receiver$iv = (Iterable)metrics;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ActionMetric actionMetric = (ActionMetric)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = it.getLabel();
            collection.add(string);
        }
        Set labels = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return MapsKt.toMap((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)labels), (Function1)((Function1)new Function1<String, Pair<? extends String, ? extends Duration>>(this, metrics, metric, outlierTrimming){
            final /* synthetic */ InternalStatsMeter this$0;
            final /* synthetic */ List $metrics;
            final /* synthetic */ UnivariateStatistic $metric;
            final /* synthetic */ OutlierTrimming $outlierTrimming;

            @NotNull
            public final Pair<String, Duration> invoke(@NotNull String label) {
                Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
                return TuplesKt.to((Object)label, (Object)InternalStatsMeter.access$calculate(this.this$0, label, this.$metrics, this.$metric, this.$outlierTrimming));
            }
            {
                this.this$0 = internalStatsMeter;
                this.$metrics = list;
                this.$metric = univariateStatistic;
                this.$outlierTrimming = outlierTrimming;
                super(1);
            }
        })));
    }

    private final Duration calculate(String label, List<ActionMetric> metrics, UnivariateStatistic metric, OutlierTrimming outlierTrimming) {
        DurationData durationData = new ActionMetricsReader().read(metrics).get(label);
        if (durationData == null) {
            durationData = DurationData.Factory.createEmptyMilliseconds();
        }
        DurationData durationData2 = durationData;
        return this.measureWithoutOutliers(durationData2, metric, outlierTrimming);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Duration> calculate(List<ActionMetric> metrics, UnivariateStatistic metric, Map<String, OutlierTrimming> trimmingPerType) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)metrics;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ActionMetric actionMetric = (ActionMetric)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = it.getLabel();
            collection.add(string);
        }
        Set labels = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return MapsKt.toMap((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)labels), (Function1)((Function1)new Function1<String, Pair<? extends String, ? extends Duration>>(this, metrics, metric, trimmingPerType){
            final /* synthetic */ InternalStatsMeter this$0;
            final /* synthetic */ List $metrics;
            final /* synthetic */ UnivariateStatistic $metric;
            final /* synthetic */ Map $trimmingPerType;

            @NotNull
            public final Pair<String, Duration> invoke(@NotNull String label) {
                Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
                return TuplesKt.to((Object)label, (Object)InternalStatsMeter.access$calculate(this.this$0, label, this.$metrics, this.$metric, (OutlierTrimming)this.$trimmingPerType.get(label)));
            }
            {
                this.this$0 = internalStatsMeter;
                this.$metrics = list;
                this.$metric = univariateStatistic;
                this.$trimmingPerType = map2;
                super(1);
            }
        })));
    }

    private final Duration measureWithoutOutliers(DurationData data, UnivariateStatistic metric, OutlierTrimming outlierTrimming) {
        OutlierTrimming outlierTrimming2 = outlierTrimming;
        if (outlierTrimming2 == null) {
            outlierTrimming2 = DEFAULT_TRIMMING;
        }
        OutlierTrimming trimmer = outlierTrimming2;
        double measurement = trimmer.measureWithoutOutliers(data.getStats(), metric);
        return (Duration)data.getDurationMapping$report().invoke((Object)measurement);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_TRIMMING = new OutlierTrimming(0.0, 1.0);
    }

    @NotNull
    public static final /* synthetic */ Duration access$calculate(InternalStatsMeter $this, @NotNull String label, @NotNull List metrics, @NotNull UnivariateStatistic metric, @Nullable OutlierTrimming outlierTrimming) {
        return $this.calculate(label, metrics, metric, outlierTrimming);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/performance/tools/report/result/InternalStatsMeter$Companion;", "", "()V", "DEFAULT_TRIMMING", "Lcom/atlassian/performance/tools/report/api/OutlierTrimming;", "report"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

