/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.chart.waterfall;

import com.atlassian.performance.tools.io.api.DirectoriesKt;
import com.atlassian.performance.tools.jiraactions.api.ActionMetric;
import com.atlassian.performance.tools.jiraactions.api.w3c.PerformanceNavigationTiming;
import com.atlassian.performance.tools.jiraactions.api.w3c.PerformanceResourceTiming;
import com.atlassian.performance.tools.jiraactions.api.w3c.RecordedPerformanceEntries;
import com.atlassian.performance.tools.report.JsonProviderSingleton;
import com.atlassian.performance.tools.report.chart.waterfall.Phase;
import com.atlassian.performance.tools.report.chart.waterfall.PhaseStackBuilder;
import com.atlassian.performance.tools.report.chart.waterfall.ProcessingModel;
import com.atlassian.performance.tools.report.chart.waterfall.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J&\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J>\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0016\u0010 \u001a\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/atlassian/performance/tools/report/chart/waterfall/WaterfallChart;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getDataset", "Ljavax/json/JsonObject;", "phase", "Lcom/atlassian/performance/tools/report/chart/waterfall/Phase;", "requests", "", "Lcom/atlassian/performance/tools/report/chart/waterfall/ProcessingModel;", "getDatasets", "Ljavax/json/JsonArray;", "getTitle", "actionLabel", "", "duration", "Ljava/time/Duration;", "plot", "", "metric", "Lcom/atlassian/performance/tools/jiraactions/api/ActionMetric;", "output", "Ljava/io/File;", "domLoaded", "loadEnd", "resourceToStack", "Lcom/atlassian/performance/tools/report/chart/waterfall/PhaseStackBuilder;", "resource", "Lcom/atlassian/performance/tools/jiraactions/api/w3c/PerformanceResourceTiming;", "toJson", "toProcessingModel", "navigation", "Lcom/atlassian/performance/tools/jiraactions/api/w3c/PerformanceNavigationTiming;", "report"})
public final class WaterfallChart {
    private final Logger logger = LogManager.getLogger(this.getClass());

    public final void plot(@NotNull ActionMetric metric, @NotNull File output) {
        Object object;
        PerformanceResourceTiming it;
        Collection collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)metric, (String)"metric");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        RecordedPerformanceEntries performance = metric.getDrilldown();
        if (performance == null) {
            this.logger.debug("Drilldown for " + metric.getLabel() + " is missing, so waterfall chart is skipped.");
            return;
        }
        if (performance.getNavigations().isEmpty() && performance.getResources().isEmpty()) {
            this.logger.debug("No navigations or resources data in the drilldown data, so waterfall chart is skipped.");
            return;
        }
        Iterable iterable = $receiver$iv = (Iterable)performance.getNavigations();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            PerformanceNavigationTiming performanceNavigationTiming = (PerformanceNavigationTiming)item$iv$iv;
            collection = destination$iv$iv;
            object = this.toProcessingModel((PerformanceNavigationTiming)it);
            collection.add(object);
        }
        List requests = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        $receiver$iv = performance.getResources();
        collection = requests;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (PerformanceResourceTiming)item$iv$iv;
            object = destination$iv$iv;
            ProcessingModel processingModel = this.toProcessingModel(it);
            object.add(processingModel);
        }
        object = (List)destination$iv$iv;
        collection.addAll((Collection)object);
        this.plot(metric.getLabel(), metric.getDuration(), ((PerformanceNavigationTiming)performance.getNavigations().get(0)).getDomContentLoadedEventEnd(), ((PerformanceNavigationTiming)performance.getNavigations().get(0)).getLoadEventEnd(), requests, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void plot(String actionLabel, Duration duration, Duration domLoaded, Duration loadEnd, Collection<ProcessingModel> requests, File output) {
        Object object;
        Object it2;
        InputStream inputStream = this.getClass().getResourceAsStream("waterfall-chart-template.html");
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"this::class\n            \u2026all-chart-template.html\")");
        Object object2 = inputStream;
        Object object3 = Charsets.UTF_8;
        Closeable closeable = object2;
        closeable = new InputStreamReader((InputStream)closeable, (Charset)object3);
        int n = 8192;
        object2 = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        object3 = null;
        try {
            it2 = (BufferedReader)object2;
            it2 = TextStreamsKt.readText((Reader)((Reader)it2));
        }
        catch (Throwable it2) {
            object3 = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        String report = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)it2, (String)"'<%= waterfallChartData =%>'", (String)new Utils().prettyPrint(this.toJson(requests)), (boolean)false, (int)4, null), (String)"'<%= waterfallChartTitle =%>'", (String)new Utils().prettyPrint(this.getTitle(actionLabel, requests, duration)), (boolean)false, (int)4, null), (String)"'<%= waterfallChartDOMLoadedValue =%>'", (String)String.valueOf(domLoaded.toMillis()), (boolean)false, (int)4, null), (String)"'<%= waterfallChartLoadEndValue =%>'", (String)String.valueOf(loadEnd.toMillis()), (boolean)false, (int)4, null);
        object2 = DirectoriesKt.ensureParentDirectory((File)output);
        object3 = Charsets.UTF_8;
        Object $i$a$1$use = object2;
        n = 8192;
        Object object4 = object = $i$a$1$use;
        object4 = new FileOutputStream((File)object4);
        object = new OutputStreamWriter((OutputStream)object4, (Charset)object3);
        BufferedWriter bufferedWriter = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        Writer writer = bufferedWriter;
        object2 = new PrintWriter(writer);
        object3 = null;
        try {
            it2 = (PrintWriter)object2;
            ((PrintWriter)it2).print(report);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        this.logger.info("Waterfall chart is available at " + output.toURI());
    }

    private final ProcessingModel toProcessingModel(PerformanceNavigationTiming navigation) {
        Duration duration;
        PerformanceResourceTiming resource = navigation.getResource();
        boolean bl = navigation.getDomComplete().isZero();
        if (bl) {
            duration = navigation.getDomContentLoadedEventEnd();
        } else if (!bl) {
            duration = navigation.getDomComplete();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Duration domComplete = duration;
        Map<Phase, Duration> phases = this.resourceToStack(resource).push(Phase.P11_DOM_PARSING, Phase.P12_PROCESSING, navigation.getDomInteractive(), domComplete).push(Phase.P13_IDLE, Phase.P14_LOAD, navigation.getLoadEventStart(), navigation.getLoadEventEnd()).build();
        return new ProcessingModel(resource.getEntry().getName(), phases, resource.getInitiatorType(), resource.getTransferSize(), resource.getDecodedBodySize(), resource.getEntry().getDuration());
    }

    private final ProcessingModel toProcessingModel(PerformanceResourceTiming resource) {
        PhaseStackBuilder phaseStackBuilder = this.resourceToStack(resource);
        Duration duration = Duration.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ZERO");
        Duration duration2 = Duration.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ZERO");
        PhaseStackBuilder phaseStackBuilder2 = phaseStackBuilder.push(Phase.P11_DOM_PARSING, Phase.P12_PROCESSING, duration, duration2);
        Duration duration3 = Duration.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ZERO");
        Duration duration4 = Duration.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration4, (String)"Duration.ZERO");
        Map<Phase, Duration> phases = phaseStackBuilder2.push(Phase.P13_IDLE, Phase.P14_LOAD, duration3, duration4).build();
        return new ProcessingModel(resource.getEntry().getName(), phases, resource.getInitiatorType(), resource.getTransferSize(), resource.getDecodedBodySize(), resource.getEntry().getDuration());
    }

    private final PhaseStackBuilder resourceToStack(PerformanceResourceTiming resource) {
        Duration duration;
        Duration duration2;
        Duration duration3;
        Duration duration4;
        Duration duration5;
        boolean bl;
        boolean timingAllowCheckFailed = resource.getDomainLookupStart().isZero() && resource.getDomainLookupEnd().isZero() && resource.getConnectStart().isZero() && resource.getConnectEnd().isZero() && resource.getRequestStart().isZero() && resource.getResponseStart().isZero();
        boolean bl2 = bl = resource.getResponseEnd().isZero() && !resource.getRequestStart().isZero();
        if (bl) {
            duration5 = resource.getResponseStart();
        } else if (!bl) {
            duration5 = resource.getResponseEnd();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Duration responseEnd = duration5;
        PhaseStackBuilder phaseStackBuilder = new PhaseStackBuilder();
        Duration duration6 = Duration.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration6, (String)"Duration.ZERO");
        PhaseStackBuilder phaseStackBuilder2 = phaseStackBuilder.push(null, Phase.P0_IDLE, duration6, resource.getEntry().getStartTime()).push(null, Phase.P1_REDIRECT, resource.getRedirectStart(), resource.getRedirectEnd());
        Duration duration7 = resource.getFetchStart();
        bl = timingAllowCheckFailed;
        if (bl) {
            duration4 = resource.getResponseEnd();
        } else if (!bl) {
            duration4 = resource.getDomainLookupStart();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        PhaseStackBuilder phaseStackBuilder3 = phaseStackBuilder2.push(Phase.P2_IDLE, Phase.P3_APPCHACHE, duration7, duration4).push(null, Phase.P4_DNS, resource.getDomainLookupStart(), resource.getDomainLookupEnd());
        Duration duration8 = resource.getConnectStart();
        bl = resource.getSecureConnectionStart().isZero();
        if (bl) {
            duration3 = resource.getConnectEnd();
        } else if (!bl) {
            duration3 = resource.getSecureConnectionStart();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        PhaseStackBuilder phaseStackBuilder4 = phaseStackBuilder3.push(Phase.P5_IDLE, Phase.P6_TCP, duration8, duration3);
        Duration duration9 = resource.getSecureConnectionStart();
        bl = resource.getSecureConnectionStart().isZero();
        if (bl) {
            duration2 = Duration.ZERO;
        } else if (!bl) {
            duration2 = resource.getConnectEnd();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"when (resource.secureCon\u2026nectEnd\n                }");
        PhaseStackBuilder phaseStackBuilder5 = phaseStackBuilder4.push(null, Phase.P7_SSL, duration9, duration2).push(Phase.P8_IDLE, Phase.P9_REQUEST, resource.getRequestStart(), resource.getResponseStart());
        bl = timingAllowCheckFailed;
        if (bl) {
            duration = resource.getResponseEnd();
        } else if (!bl) {
            duration = resource.getResponseStart();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return phaseStackBuilder5.push(null, Phase.P10_RESPONSE, duration, responseEnd);
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject getTitle(String actionLabel, Collection<ProcessingModel> requests, Duration duration) {
        Collection<Long> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = requests;
        Utils utils = new Utils();
        void var6_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ProcessingModel processingModel = (ProcessingModel)item$iv$iv;
            collection = destination$iv$iv;
            Long l = it.getTransferSize();
            collection.add(l);
        }
        collection = (List)destination$iv$iv;
        String size = utils.toHumanReadableSize(CollectionsKt.sumOfLong((Iterable)collection));
        JsonObject jsonObject = JsonProviderSingleton.INSTANCE.getJSON().createObjectBuilder().add("display", true).add("text", (JsonValue)JsonProviderSingleton.INSTANCE.getJSON().createArrayBuilder((Collection)CollectionsKt.listOf((Object[])new String[]{'\"' + actionLabel + "\" action requests waterfall chart", "requests: " + requests.size() + ", total duration: " + duration.toMillis() + " ms, total transfer: " + size})).build()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"JSON.createObjectBuilder\u2026d())\n            .build()");
        return jsonObject;
    }

    private final JsonObject toJson(Collection<ProcessingModel> requests) {
        Object object;
        ProcessingModel it;
        Collection<String> collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = requests;
        JsonProvider jsonProvider = JsonProviderSingleton.INSTANCE.getJSON();
        String string = "labels";
        JsonObjectBuilder jsonObjectBuilder = JsonProviderSingleton.INSTANCE.getJSON().createObjectBuilder();
        void var3_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            ProcessingModel processingModel = (ProcessingModel)item$iv$iv;
            collection = destination$iv$iv;
            object = new Utils().prettyPrint(it.getAddress());
            collection.add((String)object);
        }
        collection = (List)destination$iv$iv;
        JsonObjectBuilder jsonObjectBuilder2 = jsonObjectBuilder.add(string, (JsonValue)jsonProvider.createArrayBuilder((Collection)collection).build());
        $receiver$iv = requests;
        jsonProvider = JsonProviderSingleton.INSTANCE.getJSON();
        string = "fullLabels";
        jsonObjectBuilder = jsonObjectBuilder2;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (ProcessingModel)item$iv$iv;
            collection = destination$iv$iv;
            object = it.getAddress();
            collection.add((String)object);
        }
        collection = (List)destination$iv$iv;
        JsonObjectBuilder jsonObjectBuilder3 = jsonObjectBuilder.add(string, (JsonValue)jsonProvider.createArrayBuilder(collection).build());
        $receiver$iv = requests;
        jsonProvider = JsonProviderSingleton.INSTANCE.getJSON();
        string = "initiatorTypes";
        jsonObjectBuilder = jsonObjectBuilder3;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (ProcessingModel)item$iv$iv;
            collection = destination$iv$iv;
            object = it.getInitiatorType();
            collection.add((String)object);
        }
        collection = (List)destination$iv$iv;
        JsonObjectBuilder jsonObjectBuilder4 = jsonObjectBuilder.add(string, (JsonValue)jsonProvider.createArrayBuilder(collection).build());
        $receiver$iv = requests;
        jsonProvider = JsonProviderSingleton.INSTANCE.getJSON();
        string = "transferSizes";
        jsonObjectBuilder = jsonObjectBuilder4;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (ProcessingModel)item$iv$iv;
            collection = destination$iv$iv;
            object = it.getTransferSize();
            collection.add((String)object);
        }
        collection = (List)destination$iv$iv;
        JsonObjectBuilder jsonObjectBuilder5 = jsonObjectBuilder.add(string, (JsonValue)jsonProvider.createArrayBuilder(collection).build());
        $receiver$iv = requests;
        jsonProvider = JsonProviderSingleton.INSTANCE.getJSON();
        string = "decodedBodySizes";
        jsonObjectBuilder = jsonObjectBuilder5;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (ProcessingModel)item$iv$iv;
            collection = destination$iv$iv;
            object = it.getDecodedBodySize();
            collection.add((String)object);
        }
        collection = (List)destination$iv$iv;
        JsonObjectBuilder jsonObjectBuilder6 = jsonObjectBuilder.add(string, (JsonValue)jsonProvider.createArrayBuilder(collection).build());
        $receiver$iv = requests;
        jsonProvider = JsonProviderSingleton.INSTANCE.getJSON();
        string = "totalDurations";
        jsonObjectBuilder = jsonObjectBuilder6;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (ProcessingModel)item$iv$iv;
            collection = destination$iv$iv;
            object = it.getTotalDuration().toMillis();
            collection.add((String)object);
        }
        collection = (List)destination$iv$iv;
        JsonObject jsonObject = jsonObjectBuilder.add(string, (JsonValue)jsonProvider.createArrayBuilder(collection).build()).add("datasets", (JsonValue)this.getDatasets(requests)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"JSON.createObjectBuilder\u2026quests))\n        .build()");
        return jsonObject;
    }

    private final JsonArray getDatasets(Collection<ProcessingModel> requests) {
        JsonArrayBuilder datasetBuilder = JsonProviderSingleton.INSTANCE.getJSON().createArrayBuilder();
        Phase[] $receiver$iv = Phase.values();
        int n = $receiver$iv.length;
        for (int i = 0; i < n; ++i) {
            Phase element$iv;
            Phase it = element$iv = $receiver$iv[i];
            datasetBuilder.add((JsonValue)this.getDataset(it, requests));
        }
        JsonArray jsonArray = datasetBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"datasetBuilder.build()");
        return jsonArray;
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject getDataset(Phase phase, Collection<ProcessingModel> requests) {
        Collection<Long> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = requests;
        JsonProvider jsonProvider = JsonProviderSingleton.INSTANCE.getJSON();
        String string = "data";
        JsonObjectBuilder jsonObjectBuilder = JsonProviderSingleton.INSTANCE.getJSON().createObjectBuilder().add("label", phase.getLabel()).add("backgroundColor", phase.getColor());
        void var4_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ProcessingModel processingModel = (ProcessingModel)item$iv$iv;
            collection = destination$iv$iv;
            Duration duration = it.getPhases().get((Object)phase);
            if (duration == null) {
                Intrinsics.throwNpe();
            }
            Long l = duration.toMillis();
            collection.add(l);
        }
        collection = (List)destination$iv$iv;
        JsonObject jsonObject = jsonObjectBuilder.add(string, (JsonValue)jsonProvider.createArrayBuilder((Collection)collection).build()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"JSON.createObjectBuilder\u2026build())\n        .build()");
        return jsonObject;
    }
}

