/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.chart.waterfall;

import com.atlassian.performance.tools.report.chart.waterfall.Phase;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u0007J(\u0010\n\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/performance/tools/report/chart/waterfall/PhaseStackBuilder;", "", "()V", "latestEvent", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "phases", "", "Lcom/atlassian/performance/tools/report/chart/waterfall/Phase;", "build", "push", "precedingIdle", "phase", "start", "end", "put", "", "report"})
public final class PhaseStackBuilder {
    private final Map<Phase, Duration> phases;
    private Duration latestEvent;

    @NotNull
    public final PhaseStackBuilder push(@Nullable Phase precedingIdle, @NotNull Phase phase, @NotNull Duration start, @NotNull Duration end) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)phase), (String)"phase");
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        if (precedingIdle != null) {
            if (start.isZero()) {
                Map<Phase, Duration> map2 = this.phases;
                Duration duration = Duration.ZERO;
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ZERO");
                Duration duration2 = duration;
                map2.put(precedingIdle, duration2);
            } else {
                Duration duration = this.latestEvent;
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"latestEvent");
                this.put(precedingIdle, duration, start);
            }
        }
        this.put(phase, start, end);
        return this;
    }

    @NotNull
    public final Map<Phase, Duration> build() {
        return this.phases;
    }

    private final void put(Phase phase, Duration start, Duration end) {
        Duration duration;
        Duration duration2 = duration = end.minus(start);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"duration");
        if (duration2.isNegative()) {
            throw (Throwable)new Exception("Phase of negative duration is not allowed");
        }
        if (Intrinsics.areEqual((Object)duration, (Object)Duration.ZERO) ^ true && start.compareTo(this.latestEvent) < 0) {
            throw (Throwable)new Exception("The start of this phase is before the end of previously added phase");
        }
        Map<Phase, Duration> map2 = this.phases;
        Duration duration3 = duration;
        map2.put(phase, duration3);
        this.latestEvent = this.latestEvent.plus(duration);
    }

    public PhaseStackBuilder() {
        Map map2;
        PhaseStackBuilder phaseStackBuilder = this;
        phaseStackBuilder.phases = map2 = (Map)new LinkedHashMap();
        this.latestEvent = Duration.ZERO;
    }
}

