/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.chart;

import com.atlassian.performance.tools.report.Point;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/performance/tools/report/chart/Tick;", "Lcom/atlassian/performance/tools/report/Point;", "Ljava/time/Instant;", "time", "value", "", "(Ljava/time/Instant;D)V", "x", "getX", "()Ljava/time/Instant;", "y", "Ljava/math/BigDecimal;", "getY", "()Ljava/math/BigDecimal;", "labelX", "", "report"})
public final class Tick
implements Point<Instant> {
    @NotNull
    private final Instant x;
    @NotNull
    private final BigDecimal y;
    private final Instant time;

    @Override
    @NotNull
    public Instant getX() {
        return this.x;
    }

    @Override
    @NotNull
    public BigDecimal getY() {
        return this.y;
    }

    @Override
    @NotNull
    public String labelX() {
        String string = LocalDateTime.ofInstant(this.time, ZoneId.of("UTC")).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LocalDateTime.ofInstant(\u2026eId.of(\"UTC\")).toString()");
        return string;
    }

    public Tick(@NotNull Instant time, double value) {
        Intrinsics.checkParameterIsNotNull((Object)time, (String)"time");
        this.x = this.time = time;
        BigDecimal bigDecimal = BigDecimal.valueOf(value).setScale(2, RoundingMode.HALF_UP);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal, (String)"valueOf(value).setScale(2, RoundingMode.HALF_UP)");
        this.y = bigDecimal;
    }
}

