/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.chart;

import com.atlassian.performance.tools.report.JsonProviderSingleton;
import com.atlassian.performance.tools.report.Point;
import java.util.List;
import java.util.Random;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003BE\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/performance/tools/report/chart/ChartLine;", "X", "", "", "data", "", "Lcom/atlassian/performance/tools/report/Point;", "label", "", "type", "yAxisId", "hidden", "", "cohort", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;)V", "getData", "()Ljava/util/List;", "getColor", "toJson", "Ljavax/json/JsonObject;", "report"})
public final class ChartLine<X extends Comparable<? super X>> {
    @NotNull
    private final List<Point<X>> data;
    private final String label;
    private final String type;
    private final String yAxisId;
    private final boolean hidden;
    private final String cohort;

    @NotNull
    public final JsonObject toJson() {
        JsonArrayBuilder dataBuilder = JsonProviderSingleton.INSTANCE.getJSON().createArrayBuilder();
        Iterable $receiver$iv = this.data;
        for (Object element$iv : $receiver$iv) {
            Point point = (Point)element$iv;
            dataBuilder.add((JsonValue)JsonProviderSingleton.INSTANCE.getJSON().createObjectBuilder().add("x", point.labelX()).add("y", point.getY()).build());
        }
        JsonObjectBuilder chartDataBuilder = JsonProviderSingleton.INSTANCE.getJSON().createObjectBuilder();
        chartDataBuilder.add("type", this.type);
        chartDataBuilder.add("label", this.label);
        CharSequence charSequence = this.cohort;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            chartDataBuilder.add("cohort", this.cohort);
        }
        chartDataBuilder.add("borderColor", this.getColor(this.label));
        chartDataBuilder.add("backgroundColor", this.getColor(this.label));
        chartDataBuilder.add("fill", false);
        chartDataBuilder.add("data", dataBuilder);
        chartDataBuilder.add("yAxisID", this.yAxisId);
        chartDataBuilder.add("hidden", this.hidden);
        chartDataBuilder.add("lineTension", 0);
        JsonObject jsonObject = chartDataBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"chartDataBuilder.build()");
        return jsonObject;
    }

    private final String getColor(String label) {
        Random random = new Random(label.hashCode());
        int g = random.nextInt(255);
        int r = random.nextInt(255);
        int b = random.nextInt(255);
        return "rgb(" + r + ", " + g + ", " + b + ')';
    }

    @NotNull
    public final List<Point<X>> getData() {
        return this.data;
    }

    public ChartLine(@NotNull List<? extends Point<X>> data, @NotNull String label, @NotNull String type, @NotNull String yAxisId, boolean hidden, @NotNull String cohort) {
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)yAxisId, (String)"yAxisId");
        Intrinsics.checkParameterIsNotNull((Object)cohort, (String)"cohort");
        this.data = data;
        this.label = label;
        this.type = type;
        this.yAxisId = yAxisId;
        this.hidden = hidden;
        this.cohort = cohort;
    }

    public /* synthetic */ ChartLine(List list, String string, String string2, String string3, boolean bl, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            string4 = "";
        }
        this(list, string, string2, string3, bl, string4);
    }
}

