/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.chart;

import com.atlassian.performance.tools.jiraactions.api.ActionMetric;
import com.atlassian.performance.tools.report.chart.Bucket;
import com.atlassian.performance.tools.report.chart.Chart;
import com.atlassian.performance.tools.report.chart.ChartBuilder;
import com.atlassian.performance.tools.report.chart.ChartLine;
import com.atlassian.performance.tools.report.chart.Tick;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0002J.\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0002J\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0002J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/performance/tools/report/chart/ChartBuilder;", "", "()V", "bucketSize", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "aggregate", "", "Lcom/atlassian/performance/tools/report/chart/Bucket;", "metrics", "Lcom/atlassian/performance/tools/jiraactions/api/ActionMetric;", "averageLatencies", "Lcom/atlassian/performance/tools/report/chart/ChartLine;", "Ljava/time/Instant;", "buckets", "label", "", "hidden", "", "averageLatenciesPerLabel", "build", "Lcom/atlassian/performance/tools/report/chart/Chart;", "compact", "countActions", "countActiveVirtualUsers", "countAliveVirtualUsers", "countEncounteredVirtualUsers", "getErrorRate", "slice", "report"})
public final class ChartBuilder {
    private final Duration bucketSize = Duration.ofMinutes(1L);

    @NotNull
    public final Chart<Instant> build(@NotNull List<ActionMetric> metrics) {
        Intrinsics.checkParameterIsNotNull(metrics, (String)"metrics");
        List<Bucket> buckets = this.aggregate(metrics);
        List<Bucket> slicedBuckets = this.aggregate(this.slice(metrics));
        List lines = new ArrayList();
        Collection collection = lines;
        ChartLine<Instant> chartLine = ChartBuilder.averageLatencies$default(this, buckets, "Mean latency", false, 4, null);
        collection.add(chartLine);
        collection = lines;
        chartLine = this.averageLatenciesPerLabel(metrics);
        CollectionsKt.addAll((Collection)collection, (Iterable)((Object)chartLine));
        collection = lines;
        chartLine = this.countActions(buckets);
        collection.add(chartLine);
        collection = lines;
        chartLine = this.countEncounteredVirtualUsers(buckets);
        collection.add(chartLine);
        collection = lines;
        chartLine = this.countActiveVirtualUsers(slicedBuckets);
        collection.add(chartLine);
        collection = lines;
        chartLine = this.countAliveVirtualUsers(slicedBuckets);
        collection.add(chartLine);
        collection = lines;
        chartLine = this.getErrorRate(buckets);
        collection.add(chartLine);
        return new Chart<Instant>(lines);
    }

    private final List<Bucket> aggregate(List<ActionMetric> metrics) {
        Object it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = metrics;
        Iterable iterable = $receiver$iv;
        Object destination$iv$iv = new LinkedHashMap();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = iterator.next();
            it = (ActionMetric)element$iv$iv;
            Instant key$iv$iv = it.getStart().truncatedTo(ChronoUnit.MINUTES);
            Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv.entrySet();
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Object object = destination$iv$iv;
            Object k = it.getKey();
            Intrinsics.checkExpressionValueIsNotNull(k, (String)"it.key");
            Bucket bucket = new Bucket((Instant)k, (List)it.getValue());
            object.add(bucket);
        }
        return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ChartLine<Instant>> averageLatenciesPerLabel(List<ActionMetric> metrics) {
        Object object;
        String it;
        Collection collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = metrics;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            ActionMetric actionMetric = (ActionMetric)item$iv$iv;
            collection = destination$iv$iv;
            object = it.getLabel();
            collection.add(object);
        }
        $receiver$iv = CollectionsKt.sorted((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void label;
            void $receiver$iv$iv2;
            void $receiver$iv2;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            Iterable $i$a$1$map = metrics;
            ChartBuilder chartBuilder = this;
            ChartBuilder chartBuilder2 = this;
            void var11_13 = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                ActionMetric metric = (ActionMetric)element$iv$iv;
                if (!Intrinsics.areEqual((Object)metric.getLabel(), (Object)label)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv2;
            object = chartBuilder2.averageLatencies(chartBuilder.aggregate(list), (String)label, true);
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final ChartLine<Instant> countEncounteredVirtualUsers(List<Bucket> buckets) {
        Collection<Tick> collection;
        Object object;
        void $receiver$iv$iv;
        void $receiver$iv;
        ChartLine<Instant> chartLine;
        Set totalEncountered = new LinkedHashSet();
        Iterable iterable = buckets;
        boolean bl = true;
        String string = "line";
        String string2 = "count-axis";
        String string3 = "Encountered Virtual Users";
        ChartLine<Instant> chartLine2 = chartLine;
        ChartLine<Instant> chartLine3 = chartLine;
        Collection<Tick> collection2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void bucket;
            object = (Bucket)item$iv$iv;
            collection = destination$iv$iv;
            Tick tick = bucket.toPoint((Function1<? super List<ActionMetric>, Double>)((Function1)new Function1<List<? extends ActionMetric>, Double>(totalEncountered){
                final /* synthetic */ Set $totalEncountered$inlined;
                {
                    this.$totalEncountered$inlined = set;
                    super(1);
                }

                public final double invoke(@NotNull List<ActionMetric> metrics) {
                    Intrinsics.checkParameterIsNotNull(metrics, (String)"metrics");
                    Set encountered2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)metrics), (Function1)countEncounteredVirtualUsers.1.encountered.1.INSTANCE));
                    this.$totalEncountered$inlined.addAll(encountered2);
                    return this.$totalEncountered$inlined.size();
                }
            }));
            collection.add(tick);
        }
        collection = (List)destination$iv$iv;
        iterable = null;
        collection2 = collection;
        boolean bl2 = bl;
        String string4 = string;
        String string5 = string2;
        object = string3;
        chartLine2((List)collection2, (String)object, string4, string5, bl2, (String)((Object)iterable), 32, null);
        return chartLine3;
    }

    /*
     * WARNING - void declaration
     */
    private final ChartLine<Instant> countAliveVirtualUsers(List<Bucket> buckets) {
        Collection<Tick> collection;
        Object object;
        void $receiver$iv$iv;
        void $receiver$iv;
        ChartLine<Instant> chartLine;
        Iterable iterable = buckets;
        boolean bl = true;
        String string = "line";
        String string2 = "count-axis";
        String string3 = "Alive Virtual Users";
        ChartLine<Instant> chartLine2 = chartLine;
        ChartLine<Instant> chartLine3 = chartLine;
        Collection<Tick> collection2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void bucket;
            object = (Bucket)item$iv$iv;
            collection = destination$iv$iv;
            Tick tick = bucket.toPoint((Function1<? super List<ActionMetric>, Double>)((Function1)countAliveVirtualUsers.1.1.INSTANCE));
            collection.add(tick);
        }
        collection = (List)destination$iv$iv;
        iterable = null;
        collection2 = collection;
        boolean bl2 = bl;
        String string4 = string;
        String string5 = string2;
        object = string3;
        chartLine2((List)collection2, (String)object, string4, string5, bl2, (String)((Object)iterable), 32, null);
        return chartLine3;
    }

    /*
     * WARNING - void declaration
     */
    private final ChartLine<Instant> countActiveVirtualUsers(List<Bucket> buckets) {
        Collection<Tick> collection;
        Object object;
        void $receiver$iv$iv;
        void $receiver$iv;
        ChartLine<Instant> chartLine;
        Iterable iterable = buckets;
        boolean bl = false;
        String string = "line";
        String string2 = "count-axis";
        String string3 = "Active Virtual Users";
        ChartLine<Instant> chartLine2 = chartLine;
        ChartLine<Instant> chartLine3 = chartLine;
        Collection<Tick> collection2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void bucket;
            object = (Bucket)item$iv$iv;
            collection = destination$iv$iv;
            Tick tick = bucket.toPoint((Function1<? super List<ActionMetric>, Double>)((Function1)new Function1<List<? extends ActionMetric>, Double>(this){
                final /* synthetic */ ChartBuilder this$0;
                {
                    this.this$0 = chartBuilder;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final double invoke(@NotNull List<ActionMetric> metrics) {
                    Duration initial$iv;
                    Object it;
                    Iterable $receiver$iv$iv;
                    Intrinsics.checkParameterIsNotNull(metrics, (String)"metrics");
                    Iterable $receiver$iv = metrics;
                    Iterable iterable = $receiver$iv;
                    Object destination$iv$iv = new LinkedHashMap<K, V>();
                    Iterator<T> iterator = $receiver$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object object;
                        Object $receiver$iv$iv$iv = destination$iv$iv;
                        T element$iv$iv = iterator.next();
                        it = (ActionMetric)element$iv$iv;
                        UUID key$iv$iv = it.getVirtualUser();
                        V value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            ArrayList<E> answer$iv$iv$iv = new ArrayList<E>();
                            $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv = destination$iv$iv.values();
                    $receiver$iv$iv = $receiver$iv;
                    destination$iv$iv = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        it = (List)element$iv$iv;
                        Iterable list$iv$iv = ChartBuilder.access$compact(this.this$0, (List)it);
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    $receiver$iv$iv = $receiver$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        it = (ActionMetric)item$iv$iv;
                        Object object = destination$iv$iv;
                        Duration duration = it.getDuration();
                        object.add(duration);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    Duration accumulator$iv = initial$iv = Duration.ZERO;
                    for (T element$iv : $receiver$iv) {
                        void duration;
                        it = (Duration)element$iv;
                        Duration total = accumulator$iv;
                        accumulator$iv = total.plus((Duration)duration);
                    }
                    return (double)accumulator$iv.toMillis() / (double)ChartBuilder.access$getBucketSize$p(this.this$0).toMillis();
                }
            }));
            collection.add(tick);
        }
        collection = (List)destination$iv$iv;
        iterable = null;
        collection2 = collection;
        boolean bl2 = bl;
        String string4 = string;
        String string5 = string2;
        object = string3;
        chartLine2((List)collection2, (String)object, string4, string5, bl2, (String)((Object)iterable), 32, null);
        return chartLine3;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ActionMetric> slice(List<ActionMetric> metrics) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)metrics;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ActionMetric whole = (ActionMetric)element$iv$iv;
            List slices = new ArrayList();
            Instant sliceStart = whole.getStart();
            Instant wholeEnd = whole.getEnd();
            while (sliceStart.compareTo(wholeEnd) < 0) {
                Duration duration;
                Instant sliceEnd = (Instant)ComparisonsKt.minOf((Comparable)sliceStart.truncatedTo(ChronoUnit.MINUTES).plus(this.bucketSize), (Comparable)wholeEnd);
                Collection collection = slices;
                Intrinsics.checkExpressionValueIsNotNull((Object)Duration.between(sliceStart, sliceEnd), (String)"Duration.between(sliceStart, sliceEnd)");
                ActionMetric actionMetric = null;
                UUID uUID = null;
                Instant instant = sliceStart;
                actionMetric = ActionMetric.copy$default((ActionMetric)whole, null, null, (Duration)duration, (Instant)instant, uUID, actionMetric, (int)51, null);
                collection.add(actionMetric);
                Intrinsics.checkExpressionValueIsNotNull((Object)sliceEnd, (String)"sliceEnd");
            }
            Iterable list$iv$iv = slices;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ActionMetric> compact(List<ActionMetric> metrics) {
        Iterable $receiver$iv = metrics;
        Iterable iterable = $receiver$iv;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                ActionMetric it = (ActionMetric)a;
                Comparable comparable = it.getStart();
                it = (ActionMetric)b;
                Comparable comparable2 = comparable;
                Instant instant = it.getStart();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)instant);
            }
        };
        $receiver$iv = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        List initial$iv = CollectionsKt.emptyList();
        List accumulator$iv = initial$iv;
        for (Object element$iv : $receiver$iv) {
            void metric;
            ActionMetric actionMetric = (ActionMetric)element$iv;
            List compacted = accumulator$iv;
            accumulator$iv = compacted.isEmpty() ? CollectionsKt.listOf((Object)metric) : (metric.getEnd().compareTo(((ActionMetric)CollectionsKt.last((List)compacted)).getEnd()) < 0 ? compacted : CollectionsKt.plus((Collection)compacted, (Object)metric));
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final ChartLine<Instant> countActions(List<Bucket> buckets) {
        Collection<Tick> collection;
        Object object;
        void $receiver$iv$iv;
        void $receiver$iv;
        ChartLine<Instant> chartLine;
        Iterable iterable = buckets;
        boolean bl = false;
        String string = "line";
        String string2 = "count-axis";
        String string3 = "Actions";
        ChartLine<Instant> chartLine2 = chartLine;
        ChartLine<Instant> chartLine3 = chartLine;
        Collection<Tick> collection2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void bucket;
            object = (Bucket)item$iv$iv;
            collection = destination$iv$iv;
            Tick tick = bucket.toPoint((Function1<? super List<ActionMetric>, Double>)((Function1)countActions.1.1.INSTANCE));
            collection.add(tick);
        }
        collection = (List)destination$iv$iv;
        iterable = null;
        collection2 = collection;
        boolean bl2 = bl;
        String string4 = string;
        String string5 = string2;
        object = string3;
        chartLine2((List)collection2, (String)object, string4, string5, bl2, (String)((Object)iterable), 32, null);
        return chartLine3;
    }

    /*
     * WARNING - void declaration
     */
    private final ChartLine<Instant> getErrorRate(List<Bucket> buckets) {
        Collection<Tick> collection;
        Object object;
        void $receiver$iv$iv;
        void $receiver$iv;
        ChartLine<Instant> chartLine;
        Iterable iterable = buckets;
        boolean bl = false;
        String string = "line";
        String string2 = "percentage-axis";
        String string3 = "Error rate";
        ChartLine<Instant> chartLine2 = chartLine;
        ChartLine<Instant> chartLine3 = chartLine;
        Collection<Tick> collection2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void bucket;
            object = (Bucket)item$iv$iv;
            collection = destination$iv$iv;
            Tick tick = bucket.toPoint((Function1<? super List<ActionMetric>, Double>)((Function1)getErrorRate.1.1.INSTANCE));
            collection.add(tick);
        }
        collection = (List)destination$iv$iv;
        iterable = null;
        collection2 = collection;
        boolean bl2 = bl;
        String string4 = string;
        String string5 = string2;
        object = string3;
        chartLine2((List)collection2, (String)object, string4, string5, bl2, (String)((Object)iterable), 32, null);
        return chartLine3;
    }

    /*
     * WARNING - void declaration
     */
    private final ChartLine<Instant> averageLatencies(List<Bucket> buckets, String label, boolean hidden) {
        Collection<Tick> collection;
        Object object;
        void $receiver$iv$iv;
        void $receiver$iv;
        ChartLine<Instant> chartLine;
        Iterable iterable = buckets;
        boolean bl = hidden;
        String string = "line";
        String string2 = "duration-axis";
        String string3 = label;
        ChartLine<Instant> chartLine2 = chartLine;
        ChartLine<Instant> chartLine3 = chartLine;
        Collection<Tick> collection2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void bucket;
            object = (Bucket)item$iv$iv;
            collection = destination$iv$iv;
            Tick tick = bucket.toPoint((Function1<? super List<ActionMetric>, Double>)((Function1)averageLatencies.1.1.INSTANCE));
            collection.add(tick);
        }
        collection = (List)destination$iv$iv;
        iterable = null;
        collection2 = collection;
        boolean bl2 = bl;
        String string4 = string;
        String string5 = string2;
        object = string3;
        chartLine2((List)collection2, (String)object, string4, string5, bl2, (String)((Object)iterable), 32, null);
        return chartLine3;
    }

    static /* bridge */ /* synthetic */ ChartLine averageLatencies$default(ChartBuilder chartBuilder, List list, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return chartBuilder.averageLatencies(list, string, bl);
    }

    @NotNull
    public static final /* synthetic */ List access$compact(ChartBuilder $this, @NotNull List metrics) {
        return $this.compact(metrics);
    }

    public static final /* synthetic */ Duration access$getBucketSize$p(ChartBuilder $this) {
        return $this.bucketSize;
    }
}

