/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api.junit;

import com.atlassian.performance.tools.report.api.junit.JUnitReport;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/atlassian/performance/tools/report/api/junit/SuccessfulJUnitReport;", "Lcom/atlassian/performance/tools/report/api/junit/JUnitReport;", "testName", "", "(Ljava/lang/String;)V", "successful", "", "getSuccessful", "()Z", "getTestName", "()Ljava/lang/String;", "toXml", "testClassName", "report"})
public final class SuccessfulJUnitReport
implements JUnitReport {
    private final boolean successful = true;
    @NotNull
    private final String testName;

    @Override
    public boolean getSuccessful() {
        return this.successful;
    }

    @Override
    @NotNull
    public String toXml(@NotNull String testClassName) {
        Intrinsics.checkParameterIsNotNull((Object)testClassName, (String)"testClassName");
        return StringsKt.trimIndent((String)("\n        <?xml version=\"1.0\" encoding=\"UTF-8\"?>\n        <testsuite name=\"" + testClassName + "\" tests=\"1\" skipped=\"0\" failures=\"0\" errors=\"0\">\n        <testcase name=\"" + this.getTestName() + "\" classname=\"" + testClassName + "\"/>\n        </testsuite>\n        "));
    }

    @Override
    @NotNull
    public String getTestName() {
        return this.testName;
    }

    public SuccessfulJUnitReport(@NotNull String testName) {
        Intrinsics.checkParameterIsNotNull((Object)testName, (String)"testName");
        this.testName = testName;
        this.successful = true;
    }

    @Override
    public void dump(@NotNull String testClassName, @NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)testClassName, (String)"testClassName");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        JUnitReport.DefaultImpls.dump(this, testClassName, path);
    }
}

