/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api.judge;

import com.atlassian.performance.tools.jiraactions.api.ActionType;
import com.atlassian.performance.tools.report.api.SampleSizeCriteria;
import com.atlassian.performance.tools.report.api.judge.Verdict;
import com.atlassian.performance.tools.report.api.junit.FailedAssertionJUnitReport;
import com.atlassian.performance.tools.report.api.junit.JUnitReport;
import com.atlassian.performance.tools.report.api.junit.SuccessfulJUnitReport;
import com.atlassian.performance.tools.report.api.result.InteractionStats;
import com.atlassian.performance.tools.report.api.result.Stats;
import com.atlassian.performance.tools.report.result.PerformanceStats;
import java.util.Iterator;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0016\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\bH\u0007J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\u0016\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n0\bJ\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/performance/tools/report/api/judge/SampleSizeJudge;", "", "()V", "judge", "Lcom/atlassian/performance/tools/report/api/judge/Verdict;", "stats", "Lcom/atlassian/performance/tools/report/api/result/InteractionStats;", "criteria", "", "Lcom/atlassian/performance/tools/jiraactions/api/ActionType;", "Lcom/atlassian/performance/tools/report/api/SampleSizeCriteria;", "Lcom/atlassian/performance/tools/report/api/result/Stats;", "testMethodName", "", "cohort", "action", "report"})
public final class SampleSizeJudge {
    @Deprecated(message="Use the other judge method.")
    @NotNull
    public final Verdict judge(@NotNull InteractionStats stats2, @NotNull Map<ActionType<?>, SampleSizeCriteria> criteria) {
        Intrinsics.checkParameterIsNotNull((Object)stats2, (String)"stats");
        Intrinsics.checkParameterIsNotNull(criteria, (String)"criteria");
        return this.judge(PerformanceStats.Adapter.adapt(stats2), criteria);
    }

    @NotNull
    public final Verdict judge(@NotNull Stats stats2, @NotNull Map<ActionType<?>, SampleSizeCriteria> criteria) {
        Intrinsics.checkParameterIsNotNull((Object)stats2, (String)"stats");
        Intrinsics.checkParameterIsNotNull(criteria, (String)"criteria");
        Verdict.Builder verdict = new Verdict.Builder();
        Map<String, Long> sampleSizes = stats2.getSampleSizes();
        Map<ActionType<?>, SampleSizeCriteria> map2 = criteria;
        Iterator<Map.Entry<ActionType<?>, SampleSizeCriteria>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            JUnitReport jUnitReport;
            long minimumSampleSize;
            Map.Entry<ActionType<?>, SampleSizeCriteria> entry;
            Map.Entry<ActionType<?>, SampleSizeCriteria> entry2 = entry = iterator.next();
            ActionType<?> action = entry2.getKey();
            entry2 = entry;
            SampleSizeCriteria sampleCriteria = entry2.getValue();
            Long l = sampleSizes.get(action.getLabel());
            long sampleSize = l != null ? l : 0L;
            if (sampleSize < (minimumSampleSize = sampleCriteria.getMinimumSampleSize())) {
                String message = "The sample size of " + stats2.getCohort() + ' ' + action.getLabel() + " is " + sampleSize + ',' + " which is under the minimum threshold of " + minimumSampleSize;
                jUnitReport = new FailedAssertionJUnitReport(this.testMethodName(stats2.getCohort(), action), message);
            } else {
                jUnitReport = new SuccessfulJUnitReport(this.testMethodName(stats2.getCohort(), action));
            }
            JUnitReport report = jUnitReport;
            verdict.addReport(report);
        }
        return verdict.build();
    }

    private final String testMethodName(String cohort, ActionType<?> action) {
        return "Sample_size_for_" + cohort + '_' + action.getLabel();
    }
}

