/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api.judge;

import com.atlassian.performance.tools.jiraactions.api.ActionType;
import com.atlassian.performance.tools.report.PercentageExtensionsKt;
import com.atlassian.performance.tools.report.api.judge.LatencyImpact;
import com.atlassian.performance.tools.report.api.judge.Verdict;
import com.atlassian.performance.tools.report.api.junit.FailedAssertionJUnitReport;
import com.atlassian.performance.tools.report.api.junit.JUnitReport;
import com.atlassian.performance.tools.report.api.junit.SuccessfulJUnitReport;
import com.atlassian.performance.tools.report.api.result.InteractionStats;
import com.atlassian.performance.tools.report.api.result.Stats;
import com.atlassian.performance.tools.report.result.PerformanceStats;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0002B\u001b\b\u0002\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\u0002\u0010\u0007J,\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J0\u0010\b\u001a\u00020\u00112\u0016\u0010\u0012\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0014H\u0007J.\u0010\b\u001a\u00020\u00112\u0016\u0010\u0012\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fR\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/performance/tools/report/api/judge/RelativeTypicalPerformanceJudge;", "", "()V", "impactHandlers", "", "Ljava/util/function/Consumer;", "Lcom/atlassian/performance/tools/report/api/judge/LatencyImpact;", "(Ljava/util/List;)V", "judge", "Lcom/atlassian/performance/tools/report/api/junit/JUnitReport;", "action", "Lcom/atlassian/performance/tools/jiraactions/api/ActionType;", "toleranceRatio", "", "baselineStats", "Lcom/atlassian/performance/tools/report/api/result/Stats;", "experimentStats", "Lcom/atlassian/performance/tools/report/api/judge/Verdict;", "toleranceRatios", "", "Lcom/atlassian/performance/tools/report/api/result/InteractionStats;", "Builder", "report"})
public final class RelativeTypicalPerformanceJudge {
    private final List<Consumer<LatencyImpact>> impactHandlers;

    @Deprecated(message="Use the other judge method.")
    @NotNull
    public final Verdict judge(@NotNull Map<ActionType<?>, Float> toleranceRatios, @NotNull InteractionStats baselineStats, @NotNull InteractionStats experimentStats) {
        Intrinsics.checkParameterIsNotNull(toleranceRatios, (String)"toleranceRatios");
        Intrinsics.checkParameterIsNotNull((Object)baselineStats, (String)"baselineStats");
        Intrinsics.checkParameterIsNotNull((Object)experimentStats, (String)"experimentStats");
        return this.judge(toleranceRatios, PerformanceStats.Adapter.adapt(baselineStats), PerformanceStats.Adapter.adapt(experimentStats));
    }

    @NotNull
    public final Verdict judge(@NotNull Map<ActionType<?>, Float> toleranceRatios, @NotNull Stats baselineStats, @NotNull Stats experimentStats) {
        Intrinsics.checkParameterIsNotNull(toleranceRatios, (String)"toleranceRatios");
        Intrinsics.checkParameterIsNotNull((Object)baselineStats, (String)"baselineStats");
        Intrinsics.checkParameterIsNotNull((Object)experimentStats, (String)"experimentStats");
        Verdict.Builder verdict = new Verdict.Builder();
        Map<ActionType<?>, Float> map2 = toleranceRatios;
        Iterator<Map.Entry<ActionType<?>, Float>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ActionType<?>, Float> entry;
            Map.Entry<ActionType<?>, Float> entry2 = entry = iterator.next();
            ActionType<?> action = entry2.getKey();
            entry2 = entry;
            float toleranceRatio = ((Number)entry2.getValue()).floatValue();
            verdict.addReport(this.judge(action, toleranceRatio, baselineStats, experimentStats));
        }
        return verdict.build();
    }

    private final JUnitReport judge(ActionType<?> action, float toleranceRatio, Stats baselineStats, Stats experimentStats) {
        JUnitReport jUnitReport;
        String label = action.getLabel();
        String baselineCohort = baselineStats.getCohort();
        String experimentCohort = experimentStats.getCohort();
        String reportName = "Regression for " + label + ' ' + experimentCohort + " vs " + baselineCohort;
        Duration duration = baselineStats.getLocations().get(label);
        if (duration == null) {
            return new FailedAssertionJUnitReport(reportName, "No action " + label + " results for " + baselineCohort);
        }
        Duration baselineCenter = duration;
        Duration duration2 = experimentStats.getLocations().get(label);
        if (duration2 == null) {
            return new FailedAssertionJUnitReport(reportName, "No action " + label + " results for " + experimentCohort);
        }
        Duration experimentCenter = duration2;
        Duration absoluteDiff = experimentCenter.minus(baselineCenter);
        double relativeDiff = (double)absoluteDiff.toNanos() / (double)baselineCenter.toNanos();
        Duration duration3 = absoluteDiff;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"absoluteDiff");
        double d = relativeDiff;
        LatencyImpact.Builder builder = new LatencyImpact.Builder(action, relativeDiff, duration3);
        double d2 = Math.abs(d);
        LatencyImpact impact = builder.relevant(d2 >= (double)toleranceRatio).build();
        Iterable $receiver$iv = this.impactHandlers;
        for (Object element$iv : $receiver$iv) {
            Consumer it = (Consumer)element$iv;
            it.accept(impact);
        }
        if (impact.getRegression()) {
            String regressionDescription = label + ' ' + PercentageExtensionsKt.toPercentage$default(relativeDiff, 0, false, 2, null) + " typical performance regression";
            String toleranceDescription = PercentageExtensionsKt.toPercentage$default(toleranceRatio, 0, false, 2, null) + " tolerance";
            String message = regressionDescription + " overcame " + toleranceDescription;
            jUnitReport = new FailedAssertionJUnitReport(reportName, message);
        } else {
            jUnitReport = new SuccessfulJUnitReport(reportName);
        }
        return jUnitReport;
    }

    private RelativeTypicalPerformanceJudge(List<? extends Consumer<LatencyImpact>> impactHandlers) {
        this.impactHandlers = impactHandlers;
    }

    @Deprecated(message="Use Builder instead", replaceWith=@ReplaceWith(imports={}, expression="RelativeTypicalPerformanceJudge.Builder().build()"))
    public RelativeTypicalPerformanceJudge() {
        this(CollectionsKt.emptyList());
    }

    public /* synthetic */ RelativeTypicalPerformanceJudge(@NotNull List impactHandlers, DefaultConstructorMarker $constructor_marker) {
        this(impactHandlers);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\t\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/performance/tools/report/api/judge/RelativeTypicalPerformanceJudge$Builder;", "", "()V", "impactHandlers", "", "Ljava/util/function/Consumer;", "Lcom/atlassian/performance/tools/report/api/judge/LatencyImpact;", "build", "Lcom/atlassian/performance/tools/report/api/judge/RelativeTypicalPerformanceJudge;", "handleLatencyImpact", "handler", "report"})
    public static final class Builder {
        private final List<Consumer<LatencyImpact>> impactHandlers;

        @NotNull
        public final Builder handleLatencyImpact(@NotNull Consumer<LatencyImpact> handler) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
            Builder $receiver = builder = this;
            $receiver.impactHandlers.add(handler);
            return builder;
        }

        @NotNull
        public final RelativeTypicalPerformanceJudge build() {
            return new RelativeTypicalPerformanceJudge(this.impactHandlers, null);
        }

        public Builder() {
            List list;
            Builder builder = this;
            builder.impactHandlers = list = (List)new ArrayList();
        }
    }
}

