/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api.judge;

import com.atlassian.performance.tools.jiraactions.api.ActionType;
import com.atlassian.performance.tools.report.ActionMetricsReader;
import com.atlassian.performance.tools.report.PercentageExtensionsKt;
import com.atlassian.performance.tools.report.api.ShiftedDistributionRegressionTest;
import com.atlassian.performance.tools.report.api.judge.ActionReport;
import com.atlassian.performance.tools.report.api.judge.LatencyImpact;
import com.atlassian.performance.tools.report.api.judge.Verdict;
import com.atlassian.performance.tools.report.api.junit.FailedAssertionJUnitReport;
import com.atlassian.performance.tools.report.api.junit.SuccessfulJUnitReport;
import com.atlassian.performance.tools.report.api.result.DurationData;
import com.atlassian.performance.tools.report.api.result.EdibleResult;
import com.atlassian.performance.tools.report.junit.FailedActionJunitReport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0005B#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\u0002\u0010\nJ,\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J.\u0010\u000b\u001a\u00020\u00142\u0016\u0010\u0015\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/performance/tools/report/api/judge/RelativeNonparametricPerformanceJudge;", "", "significance", "", "(D)V", "()V", "impactHandlers", "", "Ljava/util/function/Consumer;", "Lcom/atlassian/performance/tools/report/api/judge/LatencyImpact;", "(DLjava/util/List;)V", "judge", "Lcom/atlassian/performance/tools/report/api/judge/ActionReport;", "action", "Lcom/atlassian/performance/tools/jiraactions/api/ActionType;", "toleranceRatio", "", "baselineResult", "Lcom/atlassian/performance/tools/report/api/result/EdibleResult;", "experimentResult", "Lcom/atlassian/performance/tools/report/api/judge/Verdict;", "toleranceRatios", "", "Builder", "report"})
public final class RelativeNonparametricPerformanceJudge {
    private final double significance;
    private final List<Consumer<LatencyImpact>> impactHandlers;

    @NotNull
    public final Verdict judge(@NotNull Map<ActionType<?>, Float> toleranceRatios, @NotNull EdibleResult baselineResult, @NotNull EdibleResult experimentResult) {
        Intrinsics.checkParameterIsNotNull(toleranceRatios, (String)"toleranceRatios");
        Intrinsics.checkParameterIsNotNull((Object)baselineResult, (String)"baselineResult");
        Intrinsics.checkParameterIsNotNull((Object)experimentResult, (String)"experimentResult");
        Verdict.Builder verdict = new Verdict.Builder();
        Map<ActionType<?>, Float> map2 = toleranceRatios;
        Iterator<Map.Entry<ActionType<?>, Float>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ActionType<?>, Float> entry;
            Map.Entry<ActionType<?>, Float> entry2 = entry = iterator.next();
            ActionType<?> action = entry2.getKey();
            entry2 = entry;
            float toleranceRatio = ((Number)entry2.getValue()).floatValue();
            ActionReport actionReport = this.judge(action, toleranceRatio, baselineResult, experimentResult);
            verdict.addReport(actionReport.getReport());
            if (!actionReport.getNonExceptionalFailure()) continue;
            verdict.addFailedAction(actionReport.getAction());
        }
        return verdict.build();
    }

    private final ActionReport judge(ActionType<?> action, float toleranceRatio, EdibleResult baselineResult, EdibleResult experimentResult) {
        ActionReport actionReport;
        Object object;
        Object baseline;
        ActionMetricsReader reader;
        String reportName;
        String label;
        block12: {
            String experimentCohort;
            block11: {
                Object object2;
                block10: {
                    String baselineCohort;
                    block9: {
                        label = action.getLabel();
                        baselineCohort = baselineResult.getCohort();
                        experimentCohort = experimentResult.getCohort();
                        reportName = "Regression for " + label + ' ' + experimentCohort + " vs " + baselineCohort;
                        reader = new ActionMetricsReader();
                        object2 = reader.read(baselineResult.getActionMetrics()).get(label);
                        if (object2 == null || (object2 = ((DurationData)object2).getStats()) == null) break block9;
                        double[] dArray = object2.getValues();
                        object2 = dArray;
                        if (dArray != null) break block10;
                    }
                    return new ActionReport(new FailedAssertionJUnitReport(reportName, "No action " + label + " results for " + baselineCohort), action, false, 4, null);
                }
                baseline = object2;
                object = reader.read(experimentResult.getActionMetrics()).get(label);
                if (object == null || (object = ((DurationData)object).getStats()) == null) break block11;
                double[] dArray = object.getValues();
                object = dArray;
                if (dArray != null) break block12;
            }
            return new ActionReport(new FailedAssertionJUnitReport(reportName, "No action " + label + " results for " + experimentCohort), action, false, 4, null);
        }
        Object experiment = object;
        ShiftedDistributionRegressionTest test = new ShiftedDistributionRegressionTest((double[])baseline, (double[])experiment, this.significance, 0.0);
        LatencyImpact impact = new LatencyImpact.Builder(action, -test.getPercentageShift(), reader.convertToDuration(-test.getLocationShift())).relevant(test.overcomesTolerance$report(toleranceRatio)).build();
        Iterable $receiver$iv = this.impactHandlers;
        for (Object element$iv : $receiver$iv) {
            Consumer it = (Consumer)element$iv;
            it.accept(impact);
        }
        if (impact.getRegression()) {
            String confidenceLevelPercent = PercentageExtensionsKt.toPercentage(1.0 - this.significance, 0, false);
            String message = "There is a regression in [" + label + "] with " + confidenceLevelPercent + " confidence level. Regression is larger than allowed " + PercentageExtensionsKt.toPercentage$default(toleranceRatio, 2, false, 2, null) + " tolerance";
            actionReport = new ActionReport(new FailedActionJunitReport(reportName, message), action, true);
        } else {
            actionReport = new ActionReport(new SuccessfulJUnitReport(reportName), action, false, 4, null);
        }
        return actionReport;
    }

    private RelativeNonparametricPerformanceJudge(double significance, List<? extends Consumer<LatencyImpact>> impactHandlers) {
        this.significance = significance;
        this.impactHandlers = impactHandlers;
    }

    @Deprecated(message="Use Builder instead", replaceWith=@ReplaceWith(imports={}, expression="RelativeNonparametricPerformanceJudge.Builder().significance(significance).build()"))
    public RelativeNonparametricPerformanceJudge(double significance) {
        this(significance, CollectionsKt.emptyList());
    }

    @Deprecated(message="Use Builder instead", replaceWith=@ReplaceWith(imports={}, expression="RelativeNonparametricPerformanceJudge.Builder().build()"))
    public RelativeNonparametricPerformanceJudge() {
        this(0.05, CollectionsKt.emptyList());
    }

    public /* synthetic */ RelativeNonparametricPerformanceJudge(double significance, @NotNull List impactHandlers, DefaultConstructorMarker $constructor_marker) {
        this(significance, impactHandlers);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\u00020\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bR\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/performance/tools/report/api/judge/RelativeNonparametricPerformanceJudge$Builder;", "", "()V", "impactHandlers", "", "Ljava/util/function/Consumer;", "Lcom/atlassian/performance/tools/report/api/judge/LatencyImpact;", "significance", "", "build", "Lcom/atlassian/performance/tools/report/api/judge/RelativeNonparametricPerformanceJudge;", "handleLatencyImpact", "handler", "report"})
    public static final class Builder {
        private double significance = 0.05;
        private final List<Consumer<LatencyImpact>> impactHandlers;

        @NotNull
        public final Builder significance(double significance) {
            Builder builder;
            Builder $receiver = builder = this;
            $receiver.significance = significance;
            return builder;
        }

        @NotNull
        public final Builder handleLatencyImpact(@NotNull Consumer<LatencyImpact> handler) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
            Builder $receiver = builder = this;
            $receiver.impactHandlers.add(handler);
            return builder;
        }

        @NotNull
        public final RelativeNonparametricPerformanceJudge build() {
            return new RelativeNonparametricPerformanceJudge(this.significance, this.impactHandlers, null);
        }

        public Builder() {
            List list;
            Builder builder = this;
            builder.impactHandlers = list = (List)new ArrayList();
        }
    }
}

