/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api.judge;

import com.atlassian.performance.tools.report.api.PerformanceCriteria;
import com.atlassian.performance.tools.report.api.judge.Verdict;
import com.atlassian.performance.tools.report.api.junit.FailedAssertionJUnitReport;
import com.atlassian.performance.tools.report.api.junit.SuccessfulJUnitReport;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nJ\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/performance/tools/report/api/judge/NodeBalanceJudge;", "", "criteria", "Lcom/atlassian/performance/tools/report/api/PerformanceCriteria;", "cohort", "", "(Lcom/atlassian/performance/tools/report/api/PerformanceCriteria;Ljava/lang/String;)V", "judge", "Lcom/atlassian/performance/tools/report/api/judge/Verdict;", "nodeCounts", "", "", "testMethodName", "report"})
public final class NodeBalanceJudge {
    private final PerformanceCriteria criteria;
    private final String cohort;

    @NotNull
    public final Verdict judge(@NotNull Map<String, Integer> nodeCounts) {
        Object v2;
        Object v0;
        Intrinsics.checkParameterIsNotNull(nodeCounts, (String)"nodeCounts");
        if (nodeCounts.size() != this.criteria.getNodes()) {
            return new Verdict.Builder().addReport(new FailedAssertionJUnitReport(this.testMethodName(this.cohort), "Results are not available for some nodes. " + "There should be " + this.criteria.getNodes() + " results but is " + nodeCounts.size() + ". " + "See node's distribution : " + nodeCounts)).build();
        }
        Map<String, Integer> map2 = nodeCounts;
        Iterable iterable = map2.entrySet();
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            v0 = null;
        } else {
            Object t = iterator.next();
            Map.Entry entry22 = (Map.Entry)t;
            int entry22 = ((Number)entry22.getValue()).intValue();
            while (iterator.hasNext()) {
                Object $i$a$1$maxBy = iterator.next();
                Map.Entry entry32 = (Map.Entry)$i$a$1$maxBy;
                int entry32 = ((Number)entry32.getValue()).intValue();
                if (entry22 >= entry32) continue;
                t = $i$a$1$maxBy;
                entry22 = entry32;
            }
            v0 = t;
        }
        Map.Entry entry = v0;
        if (entry == null) {
            Intrinsics.throwNpe();
        }
        Map.Entry maxVirtualUsers = entry;
        Map<String, Integer> $receiver$iv = nodeCounts;
        Iterable $receiver$iv$iv = $receiver$iv.entrySet();
        Iterator iterator$iv$iv = $receiver$iv$iv.iterator();
        if (!iterator$iv$iv.hasNext()) {
            v2 = null;
        } else {
            Object minElem$iv$iv = iterator$iv$iv.next();
            Map.Entry entry2 = (Map.Entry)minElem$iv$iv;
            int minValue$iv$iv = ((Number)entry2.getValue()).intValue();
            while (iterator$iv$iv.hasNext()) {
                Object e$iv$iv = iterator$iv$iv.next();
                entry2 = (Map.Entry)e$iv$iv;
                int v$iv$iv = ((Number)entry2.getValue()).intValue();
                if (minValue$iv$iv <= v$iv$iv) continue;
                minElem$iv$iv = e$iv$iv;
                minValue$iv$iv = v$iv$iv;
            }
            v2 = minElem$iv$iv;
        }
        Map.Entry entry3 = v2;
        if (entry3 == null) {
            Intrinsics.throwNpe();
        }
        Map.Entry minVirtualUsers = entry3;
        int diff = ((Number)maxVirtualUsers.getValue()).intValue() - ((Number)minVirtualUsers.getValue()).intValue();
        return diff <= this.criteria.getMaxVirtualUsersImbalance() ? new Verdict.Builder().addReport(new SuccessfulJUnitReport(this.testMethodName(this.cohort))).build() : new Verdict.Builder().addReport(new FailedAssertionJUnitReport(this.testMethodName(this.cohort), "More virtual users were testing one node (" + (String)maxVirtualUsers.getKey() + ") than another (" + (String)minVirtualUsers.getKey() + "). " + "See node's distribution : " + nodeCounts)).build();
    }

    private final String testMethodName(String cohort) {
        return "Node_distribution_for_" + cohort;
    }

    public NodeBalanceJudge(@NotNull PerformanceCriteria criteria, @NotNull String cohort) {
        Intrinsics.checkParameterIsNotNull((Object)criteria, (String)"criteria");
        Intrinsics.checkParameterIsNotNull((Object)cohort, (String)"cohort");
        this.criteria = criteria;
        this.cohort = cohort;
    }
}

