/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api.impact;

import com.atlassian.performance.tools.jiraactions.api.ActionType;
import com.atlassian.performance.tools.report.api.impact.ClassifiedLatencyImpact;
import com.atlassian.performance.tools.report.api.impact.ImpactClassification;
import com.atlassian.performance.tools.report.api.judge.LatencyImpact;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u001b\b\u0002\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0017J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0002J\"\u0010\u0014\u001a\u00020\u00052\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004H\u0002R\u001e\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/performance/tools/report/api/impact/LatencyImpactClassifier;", "Ljava/util/function/Consumer;", "Lcom/atlassian/performance/tools/report/api/judge/LatencyImpact;", "handlers", "", "Lcom/atlassian/performance/tools/report/api/impact/ClassifiedLatencyImpact;", "(Ljava/util/List;)V", "classifiedImpacts", "", "Lcom/atlassian/performance/tools/jiraactions/api/ActionType;", "unclassifiedImpacts", "", "absoluteImpact", "Ljava/time/Duration;", "impacts", "accept", "", "newestImpact", "classify", "Lcom/atlassian/performance/tools/report/api/impact/ImpactClassification;", "element", "actionGroup", "relativeImpact", "", "Builder", "report"})
@ThreadSafe
public final class LatencyImpactClassifier
implements Consumer<LatencyImpact> {
    private final List<LatencyImpact> unclassifiedImpacts;
    private final Map<ActionType<?>, ClassifiedLatencyImpact> classifiedImpacts;
    private final List<Consumer<ClassifiedLatencyImpact>> handlers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @GuardedBy(value="unclassifiedImpacts")
    public void accept(@NotNull LatencyImpact newestImpact) {
        Intrinsics.checkParameterIsNotNull((Object)newestImpact, (String)"newestImpact");
        List<LatencyImpact> list = this.unclassifiedImpacts;
        synchronized (list) {
            Object answer$iv$iv$iv;
            ActionType<?> key$iv$iv;
            Object $receiver$iv$iv;
            this.unclassifiedImpacts.add(newestImpact);
            Object $receiver$iv = this.unclassifiedImpacts;
            Iterable iterable = $receiver$iv;
            Object destination$iv$iv = new LinkedHashMap();
            Object object = $receiver$iv$iv.iterator();
            while (object.hasNext()) {
                Object object2;
                Object $receiver$iv$iv$iv = destination$iv$iv;
                Object element$iv$iv = object.next();
                LatencyImpact it = (LatencyImpact)element$iv$iv;
                key$iv$iv = it.getAction();
                Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    answer$iv$iv$iv = new ArrayList();
                    $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList($receiver$iv.size());
            object = $receiver$iv$iv;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void $actionGroup_impacts;
                Map.Entry item$iv$iv;
                Map.Entry $i$a$1$groupBy = item$iv$iv = iterator.next();
                Object object3 = destination$iv$iv;
                key$iv$iv = $actionGroup_impacts;
                ActionType actionGroup = (ActionType)key$iv$iv.getKey();
                key$iv$iv = $actionGroup_impacts;
                List impacts = (List)key$iv$iv.getValue();
                ClassifiedLatencyImpact element = this.element(actionGroup, impacts);
                answer$iv$iv$iv = this.classifiedImpacts;
                ClassifiedLatencyImpact classifiedLatencyImpact = element;
                answer$iv$iv$iv.put(actionGroup, classifiedLatencyImpact);
                Iterable $receiver$iv2 = this.handlers;
                for (Object element$iv : $receiver$iv2) {
                    Consumer it = (Consumer)element$iv;
                    it.accept(element);
                }
                Unit unit = Unit.INSTANCE;
                object3.add(unit);
            }
            iterable = (List)destination$iv$iv;
        }
    }

    private final ClassifiedLatencyImpact element(ActionType<?> actionGroup, List<LatencyImpact> impacts) {
        ImpactClassification classification = this.classify(impacts);
        return new ClassifiedLatencyImpact(actionGroup, classification, this.relativeImpact(impacts), this.absoluteImpact(impacts));
    }

    /*
     * WARNING - void declaration
     */
    private final double relativeImpact(List<LatencyImpact> impacts) {
        Collection<Double> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Median median;
        Median median2 = median = new Median();
        Iterable iterable = impacts;
        Median median3 = median2;
        void var6_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            LatencyImpact latencyImpact = (LatencyImpact)item$iv$iv;
            collection = destination$iv$iv;
            Double d = it.getRelativeDiff();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        median3.setData(CollectionsKt.toDoubleArray((Collection)collection));
        return median.evaluate();
    }

    /*
     * WARNING - void declaration
     */
    private final Duration absoluteImpact(List<LatencyImpact> impacts) {
        Collection<Double> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Median median;
        Median median2 = median = new Median();
        Iterable iterable = impacts;
        Median median3 = median2;
        void var8_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            LatencyImpact latencyImpact = (LatencyImpact)item$iv$iv;
            collection = destination$iv$iv;
            Double d = it.getAbsoluteDiff().toMillis();
            collection.add(d);
        }
        collection = (List)destination$iv$iv;
        median3.setData(CollectionsKt.toDoubleArray((Collection)collection));
        double median4 = median.evaluate();
        Duration duration = Duration.ofMillis((long)median4);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMillis(median.toLong())");
        return duration;
    }

    private final ImpactClassification classify(List<LatencyImpact> impacts) {
        int irrelevants;
        int n;
        int n2;
        int n3;
        Iterable $receiver$iv = impacts;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            n3 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $receiver$iv) {
                LatencyImpact it = (LatencyImpact)element$iv;
                if (!it.getRegression()) continue;
                ++count$iv;
            }
            n3 = count$iv;
        }
        int regressions = n3;
        Iterable $receiver$iv2 = impacts;
        if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $receiver$iv2) {
                LatencyImpact it = (LatencyImpact)element$iv;
                if (!it.getImprovement()) continue;
                ++count$iv;
            }
            n2 = count$iv;
        }
        int improvements = n2;
        Iterable $receiver$iv3 = impacts;
        if ($receiver$iv3 instanceof Collection && ((Collection)$receiver$iv3).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $receiver$iv3) {
                LatencyImpact it = (LatencyImpact)element$iv;
                if (!it.getIrrelevant()) continue;
                ++count$iv;
            }
            n = irrelevants = count$iv;
        }
        return regressions > improvements + irrelevants ? new ImpactClassification(ImpactClassification.ImpactType.REGRESSION, regressions, improvements + irrelevants) : (improvements > regressions + irrelevants ? new ImpactClassification(ImpactClassification.ImpactType.IMPROVEMENT, improvements, regressions + irrelevants) : (irrelevants > improvements + regressions ? new ImpactClassification(ImpactClassification.ImpactType.NO_IMPACT, irrelevants, improvements + regressions) : new ImpactClassification(ImpactClassification.ImpactType.INCONCLUSIVE, 0, 0)));
    }

    @NotNull
    public final List<ClassifiedLatencyImpact> classify() {
        return new ArrayList<ClassifiedLatencyImpact>(this.classifiedImpacts.values());
    }

    private LatencyImpactClassifier(List<? extends Consumer<ClassifiedLatencyImpact>> handlers) {
        this.handlers = handlers;
        LatencyImpactClassifier latencyImpactClassifier = this;
        Object object = new ArrayList();
        latencyImpactClassifier.unclassifiedImpacts = object;
        latencyImpactClassifier = this;
        latencyImpactClassifier.classifiedImpacts = object = (Map)new LinkedHashMap();
    }

    public /* synthetic */ LatencyImpactClassifier(@NotNull List handlers, DefaultConstructorMarker $constructor_marker) {
        this(handlers);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\t\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/performance/tools/report/api/impact/LatencyImpactClassifier$Builder;", "", "()V", "handlers", "", "Ljava/util/function/Consumer;", "Lcom/atlassian/performance/tools/report/api/impact/ClassifiedLatencyImpact;", "build", "Lcom/atlassian/performance/tools/report/api/impact/LatencyImpactClassifier;", "handleLatencyImpact", "handler", "report"})
    public static final class Builder {
        private final List<Consumer<ClassifiedLatencyImpact>> handlers;

        @NotNull
        public final Builder handleLatencyImpact(@NotNull Consumer<ClassifiedLatencyImpact> handler) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
            Builder $receiver = builder = this;
            this.handlers.add(handler);
            return builder;
        }

        @NotNull
        public final LatencyImpactClassifier build() {
            return new LatencyImpactClassifier(this.handlers, null);
        }

        public Builder() {
            List list;
            Builder builder = this;
            builder.handlers = list = (List)new ArrayList();
        }
    }
}

