/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api;

import com.atlassian.performance.tools.jiraactions.api.ActionMetric;
import com.atlassian.performance.tools.report.chart.waterfall.WaterfallChart;
import com.atlassian.performance.tools.workspace.api.TestWorkspace;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\t\u001a\u00020\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\t"}, d2={"Lcom/atlassian/performance/tools/report/api/WaterfallHighlightReport;", "", "()V", "getPercentile", "Lcom/atlassian/performance/tools/jiraactions/api/ActionMetric;", "metrics", "", "quantile", "", "report", "", "workspace", "Lcom/atlassian/performance/tools/workspace/api/TestWorkspace;", "summarize", "Lcom/atlassian/performance/tools/report/api/WaterfallHighlightReport$ActionTypeSummary;", "waterfall", "label", "", "summary", "reports", "Ljava/nio/file/Path;", "ActionTypeSummary"})
public final class WaterfallHighlightReport {
    /*
     * WARNING - void declaration
     */
    public final void report(@NotNull List<ActionMetric> metrics, @NotNull TestWorkspace workspace) {
        Object value$iv$iv$iv;
        Map $receiver$iv$iv;
        Map $receiver$iv;
        Intrinsics.checkParameterIsNotNull(metrics, (String)"metrics");
        Intrinsics.checkParameterIsNotNull((Object)workspace, (String)"workspace");
        Path reportDirectory = workspace.getDirectory().resolve("waterfalls");
        Iterable iterable = metrics;
        Map map2 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Map $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = iterator.next();
            ActionMetric it = (ActionMetric)element$iv$iv;
            String key$iv$iv = it.getLabel();
            value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry $i$a$1$groupBy = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map4 = map3;
            ActionTypeSummary actionTypeSummary = this.summarize((List)it.getValue());
            map4.put(k2, actionTypeSummary);
        }
        $receiver$iv = destination$iv$iv;
        map2 = $receiver$iv;
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            String string = (String)it.getKey();
            ActionTypeSummary actionTypeSummary = (ActionTypeSummary)it.getValue();
            Path path = reportDirectory;
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"reportDirectory");
            this.waterfall(string, actionTypeSummary, path);
        }
    }

    private final ActionTypeSummary summarize(List<ActionMetric> metrics) {
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)metrics;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                ActionMetric it = (ActionMetric)a;
                Comparable comparable = it.getDuration();
                it = (ActionMetric)b;
                Comparable comparable2 = comparable;
                Duration duration = it.getDuration();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)duration);
            }
        };
        List sortedMetrics = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        return new ActionTypeSummary(this.getPercentile(sortedMetrics, 0.5), this.getPercentile(sortedMetrics, 0.99));
    }

    private final ActionMetric getPercentile(List<ActionMetric> metrics, double quantile) {
        return metrics.get((int)((double)metrics.size() * quantile));
    }

    private final void waterfall(String label, ActionTypeSummary summary, Path reports) {
        WaterfallChart waterfall = new WaterfallChart();
        ActionMetric actionMetric = summary.getTypicalLatency();
        File file = reports.resolve(label).resolve("typical-waterfall.html").toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"reports.resolve(label).r\u2026waterfall.html\").toFile()");
        waterfall.plot(actionMetric, file);
        ActionMetric actionMetric2 = summary.getPessimisticLatency();
        File file2 = reports.resolve(label).resolve("pessimistic-waterfall.html").toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"reports.resolve(label).r\u2026waterfall.html\").toFile()");
        waterfall.plot(actionMetric2, file2);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/atlassian/performance/tools/report/api/WaterfallHighlightReport$ActionTypeSummary;", "", "typicalLatency", "Lcom/atlassian/performance/tools/jiraactions/api/ActionMetric;", "pessimisticLatency", "(Lcom/atlassian/performance/tools/jiraactions/api/ActionMetric;Lcom/atlassian/performance/tools/jiraactions/api/ActionMetric;)V", "getPessimisticLatency", "()Lcom/atlassian/performance/tools/jiraactions/api/ActionMetric;", "getTypicalLatency", "report"})
    private static final class ActionTypeSummary {
        @NotNull
        private final ActionMetric typicalLatency;
        @NotNull
        private final ActionMetric pessimisticLatency;

        @NotNull
        public final ActionMetric getTypicalLatency() {
            return this.typicalLatency;
        }

        @NotNull
        public final ActionMetric getPessimisticLatency() {
            return this.pessimisticLatency;
        }

        public ActionTypeSummary(@NotNull ActionMetric typicalLatency, @NotNull ActionMetric pessimisticLatency) {
            Intrinsics.checkParameterIsNotNull((Object)typicalLatency, (String)"typicalLatency");
            Intrinsics.checkParameterIsNotNull((Object)pessimisticLatency, (String)"pessimisticLatency");
            this.typicalLatency = typicalLatency;
            this.pessimisticLatency = pessimisticLatency;
        }
    }
}

