/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api;

import com.atlassian.performance.tools.jiraactions.api.ActionMetricStatistics;
import com.atlassian.performance.tools.report.api.Report;
import java.time.Duration;
import java.util.Formatter;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/atlassian/performance/tools/report/api/PlaintextReport;", "Lcom/atlassian/performance/tools/report/api/Report;", "actionMetricStatistics", "Lcom/atlassian/performance/tools/jiraactions/api/ActionMetricStatistics;", "(Lcom/atlassian/performance/tools/jiraactions/api/ActionMetricStatistics;)V", "getActionMetricStatistics", "()Lcom/atlassian/performance/tools/jiraactions/api/ActionMetricStatistics;", "generate", "", "report"})
public final class PlaintextReport
implements Report {
    @NotNull
    private final ActionMetricStatistics actionMetricStatistics;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String generate() {
        void $receiver$iv;
        Map p95 = this.actionMetricStatistics.percentile(95);
        StringBuilder report = new StringBuilder();
        Formatter formatter = new Formatter(report);
        String lineFormat = "| %-25s | %-13d | %-8d | %-20d |\n";
        formatter.format("\n", new Object[0]);
        formatter.format("+---------------------------+---------------+----------+----------------------+\n", new Object[0]);
        formatter.format("| Action name               | sample size   | errors   | 95th percentile [ms] |\n", new Object[0]);
        formatter.format("+---------------------------+---------------+----------+----------------------+\n", new Object[0]);
        Iterable iterable = CollectionsKt.sorted((Iterable)this.actionMetricStatistics.getSampleSize().keySet());
        for (Object element$iv : $receiver$iv) {
            String action = (String)element$iv;
            Object[] objectArray = new Object[4];
            objectArray[0] = StringUtils.abbreviate((String)action, (int)25);
            objectArray[1] = this.actionMetricStatistics.getSampleSize().get(action);
            objectArray[2] = this.actionMetricStatistics.getErrors().get(action);
            Duration duration = (Duration)p95.get(action);
            objectArray[3] = duration != null ? Long.valueOf(duration.toMillis()) : null;
            formatter.format(lineFormat, objectArray);
        }
        formatter.format("+---------------------------+---------------+----------+----------------------+\n", new Object[0]);
        String string = report.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"report.toString()");
        return string;
    }

    @NotNull
    public final ActionMetricStatistics getActionMetricStatistics() {
        return this.actionMetricStatistics;
    }

    public PlaintextReport(@NotNull ActionMetricStatistics actionMetricStatistics) {
        Intrinsics.checkParameterIsNotNull((Object)actionMetricStatistics, (String)"actionMetricStatistics");
        this.actionMetricStatistics = actionMetricStatistics;
    }
}

