/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/performance/tools/report/api/OutlierTrimming;", "", "lowerTrim", "", "upperTrim", "(DD)V", "measureWithoutOutliers", "data", "Lorg/apache/commons/math3/stat/descriptive/DescriptiveStatistics;", "metric", "Lorg/apache/commons/math3/stat/descriptive/UnivariateStatistic;", "report"})
public final class OutlierTrimming {
    private final double lowerTrim;
    private final double upperTrim;

    public final double measureWithoutOutliers(@NotNull DescriptiveStatistics data, @NotNull UnivariateStatistic metric) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)metric, (String)"metric");
        int lowerBound = (int)Math.floor((double)data.getN() * this.lowerTrim);
        int upperBound = (int)Math.ceil((double)data.getN() * this.upperTrim);
        int length = upperBound - lowerBound;
        return metric.evaluate(data.getSortedValues(), lowerBound, length);
    }

    public OutlierTrimming(double lowerTrim, double upperTrim) {
        this.lowerTrim = lowerTrim;
        this.upperTrim = upperTrim;
    }
}

