/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api;

import com.atlassian.performance.tools.io.api.DirectoriesKt;
import com.atlassian.performance.tools.jiraactions.api.ActionMetric;
import com.atlassian.performance.tools.jiraactions.api.ActionMetricStatistics;
import com.atlassian.performance.tools.report.api.CSVReport;
import com.atlassian.performance.tools.report.api.CohortStatsSummary;
import com.atlassian.performance.tools.report.api.CohortsSummaryTable;
import com.atlassian.performance.tools.report.api.PlaintextReport;
import com.atlassian.performance.tools.report.api.WaterfallHighlightReport;
import com.atlassian.performance.tools.report.api.action.EditedIssuesReport;
import com.atlassian.performance.tools.report.api.action.SearchJqlReport;
import com.atlassian.performance.tools.report.api.result.EdibleResult;
import com.atlassian.performance.tools.report.api.result.Stats;
import com.atlassian.performance.tools.report.chart.MeanLatencyChart;
import com.atlassian.performance.tools.report.chart.TimelineChart;
import com.atlassian.performance.tools.report.distribution.DistributionComparison;
import com.atlassian.performance.tools.workspace.api.TestWorkspace;
import com.atlassian.performance.tools.workspace.api.git.GitRepo;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/performance/tools/report/api/FullReport;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "repo", "Lcom/atlassian/performance/tools/workspace/api/git/GitRepo;", "dump", "", "results", "", "Lcom/atlassian/performance/tools/report/api/result/EdibleResult;", "workspace", "Lcom/atlassian/performance/tools/workspace/api/TestWorkspace;", "labels", "", "report"})
public final class FullReport {
    private final GitRepo repo = GitRepo.Locator.findFromCurrentDirectory();
    private final Logger logger = LogManager.getLogger(this.getClass());

    /*
     * WARNING - void declaration
     */
    public final void dump(@NotNull List<EdibleResult> results, @NotNull TestWorkspace workspace, @NotNull List<String> labels) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(results, (String)"results");
        Intrinsics.checkParameterIsNotNull((Object)workspace, (String)"workspace");
        Intrinsics.checkParameterIsNotNull(labels, (String)"labels");
        Iterable<EdibleResult> $receiver$iv = results;
        Object object = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            EdibleResult edibleResult = (EdibleResult)item$iv$iv;
            Collection collection2 = collection;
            Stats stats2 = it.getStats();
            collection2.add(stats2);
        }
        List stats3 = (List)collection;
        File file = workspace.getDirectory().resolve("summary-per-cohort.csv").toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"workspace.directory.reso\u2026per-cohort.csv\").toFile()");
        new CohortStatsSummary(file, labels).report(stats3);
        File file2 = workspace.getDirectory().resolve("summary-per-cohort.html").toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"workspace.directory.reso\u2026er-cohort.html\").toFile()");
        new CohortsSummaryTable(file2, labels).report(stats3);
        MeanLatencyChart meanLatencyChart = new MeanLatencyChart();
        Collection collection3 = stats3;
        File file3 = workspace.getDirectory().resolve("mean-latency-chart.html").toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"workspace.directory.reso\u2026ncy-chart.html\").toFile()");
        meanLatencyChart.plot(collection3, labels, file3);
        DistributionComparison distributionComparison = new DistributionComparison(this.repo);
        Path path = workspace.getDirectory().resolve("distribution-comparison.html");
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"workspace.directory.reso\u2026ibution-comparison.html\")");
        $receiver$iv = results;
        object = path;
        distributionComparison.compare((List<EdibleResult>)$receiver$iv, (Path)object);
        EditedIssuesReport editedIssuesReport = new EditedIssuesReport();
        Path path2 = workspace.getDirectory().resolve("edited-issues.csv");
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"workspace.directory.resolve(\"edited-issues.csv\")");
        $receiver$iv = results;
        object = path2;
        editedIssuesReport.report((List<EdibleResult>)$receiver$iv, (Path)object);
        $receiver$iv = results;
        for (Object e : $receiver$iv) {
            EdibleResult result = (EdibleResult)e;
            List<ActionMetric> actionMetrics = result.getActionMetrics();
            Path cohortWorkspace = workspace.getDirectory().resolve(result.getCohort());
            TimelineChart timelineChart = new TimelineChart(this.repo);
            Path path3 = cohortWorkspace.resolve("time-series-chart.html");
            Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"cohortWorkspace.resolve(\"time-series-chart.html\")");
            timelineChart.generate(path3, actionMetrics, result.getSystemMetrics());
            ActionMetricStatistics actionStats2 = new ActionMetricStatistics(result.getActionMetrics());
            String plaintextReport = new PlaintextReport(actionStats2).generate();
            String csvReport = new CSVReport(actionStats2).generate();
            this.logger.info("Plain text report:\n" + plaintextReport);
            this.logger.info("CSV report:\n" + csvReport);
            SearchJqlReport searchJqlReport = new SearchJqlReport(actionMetrics);
            Path path4 = cohortWorkspace;
            Intrinsics.checkExpressionValueIsNotNull((Object)path4, (String)"cohortWorkspace");
            searchJqlReport.report(path4);
            WaterfallHighlightReport waterfallHighlightReport = new WaterfallHighlightReport();
            Path path5 = cohortWorkspace.resolve("WaterfallHighlight");
            Intrinsics.checkExpressionValueIsNotNull((Object)path5, (String)"cohortWorkspace.resolve(\"WaterfallHighlight\")");
            waterfallHighlightReport.report(actionMetrics, new TestWorkspace(DirectoriesKt.ensureDirectory((Path)path5)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static /* bridge */ /* synthetic */ void dump$default(FullReport fullReport, List list, TestWorkspace testWorkspace, List list2, int n, Object object) {
        if ((n & 4) != 0) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                EdibleResult it = (EdibleResult)element$iv$iv;
                Iterable list$iv$iv = it.getActionLabels();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list2 = CollectionsKt.sorted((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        }
        fullReport.dump(list, testWorkspace, list2);
    }
}

