/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api;

import com.atlassian.performance.tools.report.api.ErrorCriteria;
import com.atlassian.performance.tools.report.api.OutlierTrimming;
import com.atlassian.performance.tools.report.api.SampleSizeCriteria;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B7\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB-\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0012R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/performance/tools/report/api/Criteria;", "", "toleranceRatio", "", "minimumSampleSize", "", "acceptableErrorCount", "", "maxDispersionDifference", "Ljava/time/Duration;", "outlierTrimming", "Lcom/atlassian/performance/tools/report/api/OutlierTrimming;", "(FJILjava/time/Duration;Lcom/atlassian/performance/tools/report/api/OutlierTrimming;)V", "centerToleranceRatio", "sampleSizeCriteria", "Lcom/atlassian/performance/tools/report/api/SampleSizeCriteria;", "errorCriteria", "Lcom/atlassian/performance/tools/report/api/ErrorCriteria;", "(FLjava/time/Duration;Lcom/atlassian/performance/tools/report/api/SampleSizeCriteria;Lcom/atlassian/performance/tools/report/api/ErrorCriteria;Lcom/atlassian/performance/tools/report/api/OutlierTrimming;)V", "getCenterToleranceRatio", "()F", "getErrorCriteria", "()Lcom/atlassian/performance/tools/report/api/ErrorCriteria;", "getMaxDispersionDifference", "()Ljava/time/Duration;", "getOutlierTrimming", "()Lcom/atlassian/performance/tools/report/api/OutlierTrimming;", "getSampleSizeCriteria", "()Lcom/atlassian/performance/tools/report/api/SampleSizeCriteria;", "report"})
public final class Criteria {
    private final float centerToleranceRatio;
    @NotNull
    private final Duration maxDispersionDifference;
    @NotNull
    private final SampleSizeCriteria sampleSizeCriteria;
    @NotNull
    private final ErrorCriteria errorCriteria;
    @NotNull
    private final OutlierTrimming outlierTrimming;

    public final float getCenterToleranceRatio() {
        return this.centerToleranceRatio;
    }

    @NotNull
    public final Duration getMaxDispersionDifference() {
        return this.maxDispersionDifference;
    }

    @NotNull
    public final SampleSizeCriteria getSampleSizeCriteria() {
        return this.sampleSizeCriteria;
    }

    @NotNull
    public final ErrorCriteria getErrorCriteria() {
        return this.errorCriteria;
    }

    @NotNull
    public final OutlierTrimming getOutlierTrimming() {
        return this.outlierTrimming;
    }

    public Criteria(float centerToleranceRatio, @NotNull Duration maxDispersionDifference, @NotNull SampleSizeCriteria sampleSizeCriteria, @NotNull ErrorCriteria errorCriteria, @NotNull OutlierTrimming outlierTrimming) {
        Intrinsics.checkParameterIsNotNull((Object)maxDispersionDifference, (String)"maxDispersionDifference");
        Intrinsics.checkParameterIsNotNull((Object)sampleSizeCriteria, (String)"sampleSizeCriteria");
        Intrinsics.checkParameterIsNotNull((Object)errorCriteria, (String)"errorCriteria");
        Intrinsics.checkParameterIsNotNull((Object)outlierTrimming, (String)"outlierTrimming");
        this.centerToleranceRatio = centerToleranceRatio;
        this.maxDispersionDifference = maxDispersionDifference;
        this.sampleSizeCriteria = sampleSizeCriteria;
        this.errorCriteria = errorCriteria;
        this.outlierTrimming = outlierTrimming;
    }

    @JvmOverloads
    public Criteria(float toleranceRatio, long minimumSampleSize, int acceptableErrorCount, @NotNull Duration maxDispersionDifference, @NotNull OutlierTrimming outlierTrimming) {
        Intrinsics.checkParameterIsNotNull((Object)maxDispersionDifference, (String)"maxDispersionDifference");
        Intrinsics.checkParameterIsNotNull((Object)outlierTrimming, (String)"outlierTrimming");
        this(toleranceRatio, maxDispersionDifference, new SampleSizeCriteria(minimumSampleSize), new ErrorCriteria(acceptableErrorCount), outlierTrimming);
    }

    @JvmOverloads
    public /* synthetic */ Criteria(float f, long l, int n, Duration duration, OutlierTrimming outlierTrimming, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            f = FloatCompanionObject.INSTANCE.getNaN();
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            Duration duration2 = Duration.ofMillis(500L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofMillis(500)");
            duration = duration2;
        }
        if ((n2 & 0x10) != 0) {
            outlierTrimming = new OutlierTrimming(0.01, 0.99);
        }
        this(f, l, n, duration, outlierTrimming);
    }

    @JvmOverloads
    public Criteria(float toleranceRatio, long minimumSampleSize, int acceptableErrorCount, @NotNull Duration maxDispersionDifference) {
        this(toleranceRatio, minimumSampleSize, acceptableErrorCount, maxDispersionDifference, null, 16, null);
    }

    @JvmOverloads
    public Criteria(float toleranceRatio, long minimumSampleSize, int acceptableErrorCount) {
        this(toleranceRatio, minimumSampleSize, acceptableErrorCount, null, null, 24, null);
    }

    @JvmOverloads
    public Criteria(float toleranceRatio, long minimumSampleSize) {
        this(toleranceRatio, minimumSampleSize, 0, null, null, 28, null);
    }

    @JvmOverloads
    public Criteria(long minimumSampleSize) {
        this(0.0f, minimumSampleSize, 0, null, null, 29, null);
    }
}

