/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.report.api;

import com.atlassian.performance.tools.jiraactions.api.ActionMetricStatistics;
import com.atlassian.performance.tools.report.api.Report;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\r\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/performance/tools/report/api/CSVReport;", "Lcom/atlassian/performance/tools/report/api/Report;", "actionMetricStatistics", "Lcom/atlassian/performance/tools/jiraactions/api/ActionMetricStatistics;", "(Lcom/atlassian/performance/tools/jiraactions/api/ActionMetricStatistics;)V", "percentileLevels", "", "", "percentiles", "", "", "Ljava/time/Duration;", "actionReportLine", "actionName", "actionTimingPercentiles", "", "generate", "report"})
public final class CSVReport
implements Report {
    private final List<Integer> percentileLevels;
    private final Map<Integer, Map<String, Duration>> percentiles;
    private final ActionMetricStatistics actionMetricStatistics;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String generate() {
        void $receiver$iv$iv;
        StringBuilder report = new StringBuilder();
        report.append("actionName,sampleSize,errors,total,p50,p95,p99,max\n");
        Iterable $receiver$iv = CollectionsKt.sorted((Iterable)this.actionMetricStatistics.getSampleSize().keySet());
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string2 = this.actionReportLine((String)it);
            collection.add(string2);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            String it = (String)element$iv;
            report.append(it);
        }
        String string = report.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"report.toString()");
        return string;
    }

    private final String actionReportLine(String actionName) {
        Integer n = (Integer)this.actionMetricStatistics.getSampleSize().get(actionName);
        int samples = n != null ? n : 0;
        Integer n2 = (Integer)this.actionMetricStatistics.getErrors().get(actionName);
        int errors = n2 != null ? n2 : 0;
        int total = samples + errors;
        Map<Integer, Object> p = this.actionTimingPercentiles(actionName);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s,%d,%d,%d,%s,%s,%s,%s\n";
        Object[] objectArray = new Object[]{actionName, samples, errors, total, p.get(50), p.get(95), p.get(99), p.get(100)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, Object> actionTimingPercentiles(String actionName) {
        void $receiver$iv$iv;
        Map<Integer, Map<String, Duration>> $receiver$iv;
        Map<Integer, Map<String, Duration>> map2 = $receiver$iv = this.percentiles;
        Collection destination$iv$iv = new ArrayList($receiver$iv.size());
        void var5_5 = $receiver$iv$iv;
        Iterator iterator = var5_5.entrySet().iterator();
        while (iterator.hasNext()) {
            void byNumber;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            Duration duration = (Duration)((Map)byNumber.getValue()).get(actionName);
            Pair pair = TuplesKt.to(byNumber.getKey(), (Object)(duration != null ? Long.valueOf(duration.toMillis()) : ""));
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    public CSVReport(@NotNull ActionMetricStatistics actionMetricStatistics) {
        Collection<Pair> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)actionMetricStatistics, (String)"actionMetricStatistics");
        this.actionMetricStatistics = actionMetricStatistics;
        this.percentileLevels = CollectionsKt.listOf((Object[])new Integer[]{50, 95, 99, 100});
        Iterable iterable = this.percentileLevels;
        CSVReport cSVReport = this;
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            Pair pair = TuplesKt.to((Object)((int)it), (Object)this.actionMetricStatistics.percentile((int)it));
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        cSVReport.percentiles = MapsKt.toMap((Iterable)collection);
    }
}

