/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jvmtasks.api;

import com.atlassian.performance.tools.jvmtasks.api.TaskScope;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.jcip.annotations.ThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="Use TaskScope instead")
@ThreadSafe
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0003\u001c\u001d\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ'\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/atlassian/performance/tools/jvmtasks/api/TaskTimer;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "taskFailedHandlers", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/atlassian/performance/tools/jvmtasks/api/TaskTimer$TaskFailedHandler;", "taskStartedHandlers", "Lcom/atlassian/performance/tools/jvmtasks/api/TaskTimer$TaskStartedHandler;", "taskSucceededHandlers", "Lcom/atlassian/performance/tools/jvmtasks/api/TaskTimer$TaskSucceededHandler;", "subTaskFailed", "", "handler", "subTaskStarted", "subTaskSucceeded", "time", "T", "label", "", "task", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "unsubTaskFailed", "unsubTaskStarted", "unsubTaskSucceeded", "TaskFailedHandler", "TaskStartedHandler", "TaskSucceededHandler", "jvm-tasks"})
public final class TaskTimer {
    private static final Logger logger;
    private static final CopyOnWriteArrayList<TaskStartedHandler> taskStartedHandlers;
    private static final CopyOnWriteArrayList<TaskSucceededHandler> taskSucceededHandlers;
    private static final CopyOnWriteArrayList<TaskFailedHandler> taskFailedHandlers;
    public static final TaskTimer INSTANCE;

    public final <T> T time(@NotNull String label, @NotNull Function0<? extends T> task) {
        Intrinsics.checkParameterIsNotNull((Object)label, (String)"label");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        return TaskScope.INSTANCE.task$jvm_tasks(label, (Function0)new Function0<T>(task){
            final /* synthetic */ Function0 $task;

            public final T invoke() {
                Object element$iv;
                List path = ThreadContext.cloneStack().asList();
                Iterable $receiver$iv = TaskTimer.access$getTaskStartedHandlers$p(TaskTimer.INSTANCE);
                Iterator<T> iterator = $receiver$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    TaskStartedHandler it = (TaskStartedHandler)element$iv;
                    boolean bl = false;
                    List list = path;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"path");
                    it.onTaskStarted(list);
                }
                Instant start = Instant.now();
                try {
                    element$iv = this.$task.invoke();
                }
                catch (Exception e) {
                    Duration duration = Duration.between(start, Instant.now());
                    Iterable $receiver$iv2 = TaskTimer.access$getTaskFailedHandlers$p(TaskTimer.INSTANCE);
                    for (T element$iv2 : $receiver$iv2) {
                        TaskFailedHandler it = (TaskFailedHandler)element$iv2;
                        boolean bl = false;
                        List list = path;
                        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"path");
                        Duration duration2 = duration;
                        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"duration");
                        it.onTaskFailed(list, duration2, e);
                    }
                    throw (Throwable)e;
                }
                Object result = element$iv;
                Duration duration = Duration.between(start, Instant.now());
                Iterable $receiver$iv3 = TaskTimer.access$getTaskSucceededHandlers$p(TaskTimer.INSTANCE);
                for (T element$iv3 : $receiver$iv3) {
                    TaskSucceededHandler it = (TaskSucceededHandler)element$iv3;
                    boolean bl = false;
                    List list = path;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"path");
                    Duration duration3 = duration;
                    Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"duration");
                    it.onTaskSucceeded(list, duration3);
                }
                TaskTimer.access$getLogger$p(TaskTimer.INSTANCE).debug("The task took " + duration);
                return (T)iterator;
            }
            {
                this.$task = function0;
                super(0);
            }
        });
    }

    public final void subTaskStarted(@NotNull TaskStartedHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        taskStartedHandlers.add(handler);
    }

    public final void subTaskSucceeded(@NotNull TaskSucceededHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        taskSucceededHandlers.add(handler);
    }

    public final void subTaskFailed(@NotNull TaskFailedHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        taskFailedHandlers.add(handler);
    }

    public final void unsubTaskStarted(@NotNull TaskStartedHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        taskStartedHandlers.remove(handler);
    }

    public final void unsubTaskSucceeded(@NotNull TaskSucceededHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        taskSucceededHandlers.remove(handler);
    }

    public final void unsubTaskFailed(@NotNull TaskFailedHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        taskFailedHandlers.remove(handler);
    }

    private TaskTimer() {
    }

    static {
        TaskTimer taskTimer;
        INSTANCE = taskTimer = new TaskTimer();
        logger = LogManager.getLogger(taskTimer.getClass());
        taskStartedHandlers = new CopyOnWriteArrayList();
        taskSucceededHandlers = new CopyOnWriteArrayList();
        taskFailedHandlers = new CopyOnWriteArrayList();
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getTaskStartedHandlers$p(TaskTimer $this) {
        TaskTimer taskTimer = $this;
        return taskStartedHandlers;
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getTaskFailedHandlers$p(TaskTimer $this) {
        TaskTimer taskTimer = $this;
        return taskFailedHandlers;
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getTaskSucceededHandlers$p(TaskTimer $this) {
        TaskTimer taskTimer = $this;
        return taskSucceededHandlers;
    }

    public static final /* synthetic */ Logger access$getLogger$p(TaskTimer $this) {
        TaskTimer taskTimer = $this;
        return logger;
    }

    @ThreadSafe
    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\bg\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/performance/tools/jvmtasks/api/TaskTimer$TaskStartedHandler;", "", "onTaskStarted", "", "path", "", "", "jvm-tasks"})
    public static interface TaskStartedHandler {
        public void onTaskStarted(@NotNull List<String> var1);
    }

    @ThreadSafe
    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\t"}, d2={"Lcom/atlassian/performance/tools/jvmtasks/api/TaskTimer$TaskSucceededHandler;", "", "onTaskSucceeded", "", "path", "", "", "duration", "Ljava/time/Duration;", "jvm-tasks"})
    public static interface TaskSucceededHandler {
        public void onTaskSucceeded(@NotNull List<String> var1, @NotNull Duration var2);
    }

    @ThreadSafe
    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\bg\u0018\u00002\u00020\u0001J&\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/performance/tools/jvmtasks/api/TaskTimer$TaskFailedHandler;", "", "onTaskFailed", "", "path", "", "", "duration", "Ljava/time/Duration;", "fail", "", "jvm-tasks"})
    public static interface TaskFailedHandler {
        public void onTaskFailed(@NotNull List<String> var1, @NotNull Duration var2, @NotNull Throwable var3);
    }
}

