/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jvmtasks.api;

import com.atlassian.performance.tools.jvmtasks.api.Backoff;
import java.time.Duration;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/performance/tools/jvmtasks/api/JitterBackoff;", "Lcom/atlassian/performance/tools/jvmtasks/api/Backoff;", "max", "Ljava/time/Duration;", "(Ljava/time/Duration;)V", "random", "Ljava/util/Random;", "(Ljava/time/Duration;Ljava/util/Random;)V", "backOff", "attempt", "", "jvm-tasks"})
public final class JitterBackoff
implements Backoff {
    private final Duration max;
    private final Random random;

    @Override
    @NotNull
    public Duration backOff(int attempt) {
        long l = this.random.nextLong();
        long randomMillis = Math.abs(l) % this.max.toMillis();
        Duration duration = Duration.ofMillis(randomMillis);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMillis(randomMillis)");
        return duration;
    }

    public JitterBackoff(@NotNull Duration max, @NotNull Random random) {
        Intrinsics.checkParameterIsNotNull((Object)max, (String)"max");
        Intrinsics.checkParameterIsNotNull((Object)random, (String)"random");
        this.max = max;
        this.random = random;
    }

    public JitterBackoff(@NotNull Duration max) {
        Intrinsics.checkParameterIsNotNull((Object)max, (String)"max");
        this(max, new Random());
    }
}

