/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraperformancetests.api;

import com.atlassian.performance.tools.io.api.DirectoriesKt;
import com.atlassian.performance.tools.jiraperformancetests.api.VisitableJira;
import com.atlassian.performance.tools.workspace.api.RootWorkspace;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.json.Json;
import javax.json.JsonObject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/performance/tools/jiraperformancetests/api/VisitableJiraRegistry;", "", "workspace", "Lcom/atlassian/performance/tools/workspace/api/RootWorkspace;", "(Lcom/atlassian/performance/tools/workspace/api/RootWorkspace;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "memory", "Ljava/io/File;", "kotlin.jvm.PlatformType", "memorize", "", "jira", "Lcom/atlassian/performance/tools/jiraperformancetests/api/VisitableJira;", "recall", "jira-performance-tests"})
public final class VisitableJiraRegistry {
    private final Logger logger;
    private final File memory;

    public final void memorize(@NotNull VisitableJira jira) {
        Intrinsics.checkParameterIsNotNull((Object)jira, (String)"jira");
        this.logger.info("I'll remember how to automatically visit " + jira);
        File file = this.memory;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"memory");
        FilesKt.writeText$default((File)DirectoriesKt.ensureParentDirectory((File)file), (String)jira.toJson(), null, (int)2, null);
    }

    @Nullable
    public final VisitableJira recall() {
        VisitableJira visitableJira;
        if (this.memory.exists()) {
            VisitableJira visitableJira2;
            File file = this.memory;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"memory");
            File file2 = file;
            VisitableJira visitableJira3 = visitableJira2;
            VisitableJira visitableJira4 = visitableJira2;
            Charset charset = Charsets.UTF_8;
            Object object = file2;
            object = new FileInputStream((File)object);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object, charset);
            visitableJira = visitableJira4;
            JsonObject jsonObject = Json.createReader((Reader)inputStreamReader).readObject();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"Json.createReader(memory.reader()).readObject()");
            visitableJira3(jsonObject);
        } else {
            this.logger.info("I don't remember a Jira you can automatically visit. I checked in " + this.memory + " .");
            visitableJira = null;
        }
        return visitableJira;
    }

    public VisitableJiraRegistry(@NotNull RootWorkspace workspace) {
        Intrinsics.checkParameterIsNotNull((Object)workspace, (String)"workspace");
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        this.memory = workspace.getDirectory().resolve("visitable-jira.json").toFile();
    }
}

