/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraperformancetests.api;

import com.atlassian.performance.tools.infrastructure.api.virtualusers.LocalVirtualUsers;
import com.atlassian.performance.tools.jiraactions.api.scenario.Scenario;
import com.atlassian.performance.tools.jirasoftwareactions.api.JiraSoftwareScenario;
import com.atlassian.performance.tools.report.api.FullReport;
import com.atlassian.performance.tools.report.api.FullTimeline;
import com.atlassian.performance.tools.report.api.HistoricalCohortsReporter;
import com.atlassian.performance.tools.report.api.Timeline;
import com.atlassian.performance.tools.report.api.result.EdibleResult;
import com.atlassian.performance.tools.report.api.result.RawCohortResult;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserLoad;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserOptions;
import com.atlassian.performance.tools.virtualusers.api.browsers.Browser;
import com.atlassian.performance.tools.virtualusers.api.browsers.HeadlessChromeBrowser;
import com.atlassian.performance.tools.virtualusers.api.config.VirtualUserBehavior;
import com.atlassian.performance.tools.virtualusers.api.config.VirtualUserTarget;
import com.atlassian.performance.tools.workspace.api.RootWorkspace;
import com.atlassian.performance.tools.workspace.api.TestWorkspace;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010,\u001a\u00020-R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\"\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0012\"\u0004\b\u0019\u0010\u0014R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u0006."}, d2={"Lcom/atlassian/performance/tools/jiraperformancetests/api/OnPremisePerformanceTest;", "", "jira", "Ljava/net/URI;", "(Ljava/net/URI;)V", "adminLogin", "", "getAdminLogin", "()Ljava/lang/String;", "setAdminLogin", "(Ljava/lang/String;)V", "adminPassword", "getAdminPassword", "setAdminPassword", "browser", "Ljava/lang/Class;", "Lcom/atlassian/performance/tools/virtualusers/api/browsers/Browser;", "getBrowser", "()Ljava/lang/Class;", "setBrowser", "(Ljava/lang/Class;)V", "cohortName", "scenario", "Lcom/atlassian/performance/tools/jiraactions/api/scenario/Scenario;", "getScenario", "setScenario", "testDuration", "Ljava/time/Duration;", "getTestDuration", "()Ljava/time/Duration;", "setTestDuration", "(Ljava/time/Duration;)V", "virtualUsers", "", "getVirtualUsers", "()I", "setVirtualUsers", "(I)V", "workspace", "Lcom/atlassian/performance/tools/workspace/api/RootWorkspace;", "getWorkspace", "()Lcom/atlassian/performance/tools/workspace/api/RootWorkspace;", "setWorkspace", "(Lcom/atlassian/performance/tools/workspace/api/RootWorkspace;)V", "run", "", "jira-performance-tests"})
public final class OnPremisePerformanceTest {
    @NotNull
    private String adminLogin;
    @NotNull
    private String adminPassword;
    @NotNull
    private Class<? extends Scenario> scenario;
    @NotNull
    private Class<? extends Browser> browser;
    private int virtualUsers;
    @NotNull
    private Duration testDuration;
    @NotNull
    private RootWorkspace workspace;
    private final String cohortName = "my-jira";
    private final URI jira;

    @NotNull
    public final String getAdminLogin() {
        return this.adminLogin;
    }

    public final void setAdminLogin(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.adminLogin = string;
    }

    @NotNull
    public final String getAdminPassword() {
        return this.adminPassword;
    }

    public final void setAdminPassword(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.adminPassword = string;
    }

    @NotNull
    public final Class<? extends Scenario> getScenario() {
        return this.scenario;
    }

    public final void setScenario(@NotNull Class<? extends Scenario> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"<set-?>");
        this.scenario = clazz;
    }

    @NotNull
    public final Class<? extends Browser> getBrowser() {
        return this.browser;
    }

    public final void setBrowser(@NotNull Class<? extends Browser> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"<set-?>");
        this.browser = clazz;
    }

    public final int getVirtualUsers() {
        return this.virtualUsers;
    }

    public final void setVirtualUsers(int n) {
        this.virtualUsers = n;
    }

    @NotNull
    public final Duration getTestDuration() {
        return this.testDuration;
    }

    public final void setTestDuration(@NotNull Duration duration) {
        Intrinsics.checkParameterIsNotNull((Object)duration, (String)"<set-?>");
        this.testDuration = duration;
    }

    @NotNull
    public final RootWorkspace getWorkspace() {
        return this.workspace;
    }

    public final void setWorkspace(@NotNull RootWorkspace rootWorkspace) {
        Intrinsics.checkParameterIsNotNull((Object)rootWorkspace, (String)"<set-?>");
        this.workspace = rootWorkspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        VirtualUserLoad load2 = new VirtualUserLoad.Builder().virtualUsers(this.virtualUsers).flat(this.testDuration).build();
        VirtualUserBehavior virtualUserBehavior = new VirtualUserBehavior.Builder(this.scenario).load(load2).browser(this.browser).diagnosticsLimit(64).seed(new Random().nextLong()).build();
        VirtualUserTarget virtualUserTarget = new VirtualUserTarget(this.jira, this.adminLogin, this.adminPassword);
        VirtualUserOptions options = new VirtualUserOptions(virtualUserTarget, virtualUserBehavior);
        LocalVirtualUsers localVirtualUsers = new LocalVirtualUsers(this.workspace.getCurrentTask().getDirectory());
        try {
            localVirtualUsers.applyLoad(options);
        }
        finally {
            localVirtualUsers.gatherResults();
        }
        EdibleResult result = new RawCohortResult.Factory().fullResult(this.cohortName, this.workspace.getCurrentTask().getDirectory()).prepareForJudgement((Timeline)new FullTimeline());
        FullReport.dump$default((FullReport)new FullReport(), (List)CollectionsKt.listOf((Object)result), (TestWorkspace)new TestWorkspace(this.workspace.getCurrentTask().getDirectory()), null, (int)4, null);
        new HistoricalCohortsReporter(this.workspace).dump();
    }

    public OnPremisePerformanceTest(@NotNull URI jira) {
        Intrinsics.checkParameterIsNotNull((Object)jira, (String)"jira");
        this.jira = jira;
        this.adminLogin = "admin";
        this.adminPassword = "admin";
        this.scenario = JiraSoftwareScenario.class;
        this.browser = HeadlessChromeBrowser.class;
        this.virtualUsers = 10;
        Duration duration = Duration.ofMinutes(30L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(30)");
        this.testDuration = duration;
        this.workspace = new RootWorkspace(null, 1, null);
        this.cohortName = "my-jira";
    }
}

