/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraperformancetests.api;

import com.atlassian.performance.tools.aws.api.Aws;
import com.atlassian.performance.tools.aws.api.Investment;
import com.atlassian.performance.tools.awsinfrastructure.api.DatasetCatalogue;
import com.atlassian.performance.tools.awsinfrastructure.api.InfrastructureFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.TargetingVirtualUserOptions;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.JiraFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.StandaloneFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.virtualusers.StackVirtualUsersFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.virtualusers.VirtualUsersFormula;
import com.atlassian.performance.tools.infrastructure.api.app.AppSource;
import com.atlassian.performance.tools.infrastructure.api.app.Apps;
import com.atlassian.performance.tools.infrastructure.api.app.MavenApp;
import com.atlassian.performance.tools.infrastructure.api.app.NoApp;
import com.atlassian.performance.tools.infrastructure.api.dataset.Dataset;
import com.atlassian.performance.tools.infrastructure.api.distribution.ProductDistribution;
import com.atlassian.performance.tools.infrastructure.api.distribution.PublicJiraSoftwareDistribution;
import com.atlassian.performance.tools.jiraactions.api.ActionType;
import com.atlassian.performance.tools.jiraactions.api.scenario.Scenario;
import com.atlassian.performance.tools.jiraperformancetests.CountingThreadFactory;
import com.atlassian.performance.tools.jiraperformancetests.RawRegressionResults;
import com.atlassian.performance.tools.jiraperformancetests.api.ProvisioningPerformanceTest;
import com.atlassian.performance.tools.jirasoftwareactions.api.JiraSoftwareScenario;
import com.atlassian.performance.tools.report.api.Criteria;
import com.atlassian.performance.tools.report.api.PerformanceCriteria;
import com.atlassian.performance.tools.report.api.judge.MaximumCoverageJudge;
import com.atlassian.performance.tools.report.api.judge.Verdict;
import com.atlassian.performance.tools.report.api.result.RawCohortResult;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserLoad;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserOptions;
import com.atlassian.performance.tools.virtualusers.api.browsers.Browser;
import com.atlassian.performance.tools.virtualusers.api.browsers.HeadlessChromeBrowser;
import com.atlassian.performance.tools.virtualusers.api.config.VirtualUserBehavior;
import com.atlassian.performance.tools.virtualusers.api.config.VirtualUserTarget;
import com.atlassian.performance.tools.workspace.api.RootWorkspace;
import com.atlassian.performance.tools.workspace.api.TestWorkspace;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0002J\u0006\u0010>\u001a\u000209J\u0010\u0010?\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0002J\u0018\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R*\u0010\u0014\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\"\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u0002010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0011\"\u0004\b3\u0010\u0013R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107\u00a8\u0006C"}, d2={"Lcom/atlassian/performance/tools/jiraperformancetests/api/AppImpactTest;", "", "app", "Lcom/atlassian/performance/tools/infrastructure/api/app/MavenApp;", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "(Lcom/atlassian/performance/tools/infrastructure/api/app/MavenApp;Lcom/atlassian/performance/tools/aws/api/Aws;)V", "Lcom/atlassian/performance/tools/infrastructure/api/app/AppSource;", "testJar", "Ljava/io/File;", "(Lcom/atlassian/performance/tools/infrastructure/api/app/AppSource;Lcom/atlassian/performance/tools/aws/api/Aws;Ljava/io/File;)V", "appLabel", "", "browser", "Ljava/lang/Class;", "Lcom/atlassian/performance/tools/virtualusers/api/browsers/Browser;", "getBrowser", "()Ljava/lang/Class;", "setBrowser", "(Ljava/lang/Class;)V", "criteria", "", "Lcom/atlassian/performance/tools/jiraactions/api/ActionType;", "Lcom/atlassian/performance/tools/report/api/Criteria;", "getCriteria", "()Ljava/util/Map;", "setCriteria", "(Ljava/util/Map;)V", "dataset", "Lcom/atlassian/performance/tools/infrastructure/api/dataset/Dataset;", "getDataset", "()Lcom/atlassian/performance/tools/infrastructure/api/dataset/Dataset;", "setDataset", "(Lcom/atlassian/performance/tools/infrastructure/api/dataset/Dataset;)V", "duration", "Ljava/time/Duration;", "getDuration", "()Ljava/time/Duration;", "setDuration", "(Ljava/time/Duration;)V", "outputDirectory", "Ljava/nio/file/Path;", "productDistribution", "Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;", "getProductDistribution", "()Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;", "setProductDistribution", "(Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;)V", "scenario", "Lcom/atlassian/performance/tools/jiraactions/api/scenario/Scenario;", "getScenario", "setScenario", "getTestJar", "()Ljava/io/File;", "setTestJar", "(Ljava/io/File;)V", "assertNoRegression", "", "results", "Lcom/atlassian/performance/tools/jiraperformancetests/RawRegressionResults;", "load", "Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserLoad;", "run", "runRegression", "testCohort", "Lcom/atlassian/performance/tools/jiraperformancetests/api/ProvisioningPerformanceTest;", "cohort", "jira-performance-tests"})
public final class AppImpactTest {
    @NotNull
    private Class<? extends Scenario> scenario;
    @NotNull
    private Class<? extends Browser> browser;
    @NotNull
    private Map<ActionType<?>, Criteria> criteria;
    @NotNull
    private ProductDistribution productDistribution;
    @NotNull
    private Duration duration;
    @NotNull
    private Dataset dataset;
    private final Path outputDirectory;
    private final String appLabel;
    private final AppSource app;
    private final Aws aws;
    @NotNull
    private File testJar;

    @NotNull
    public final Class<? extends Scenario> getScenario() {
        return this.scenario;
    }

    public final void setScenario(@NotNull Class<? extends Scenario> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"<set-?>");
        this.scenario = clazz;
    }

    @NotNull
    public final Class<? extends Browser> getBrowser() {
        return this.browser;
    }

    public final void setBrowser(@NotNull Class<? extends Browser> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"<set-?>");
        this.browser = clazz;
    }

    @NotNull
    public final Map<ActionType<?>, Criteria> getCriteria() {
        return this.criteria;
    }

    public final void setCriteria(@NotNull Map<ActionType<?>, Criteria> map2) {
        Intrinsics.checkParameterIsNotNull(map2, (String)"<set-?>");
        this.criteria = map2;
    }

    @NotNull
    public final ProductDistribution getProductDistribution() {
        return this.productDistribution;
    }

    public final void setProductDistribution(@NotNull ProductDistribution productDistribution) {
        Intrinsics.checkParameterIsNotNull((Object)productDistribution, (String)"<set-?>");
        this.productDistribution = productDistribution;
    }

    @NotNull
    public final Duration getDuration() {
        return this.duration;
    }

    public final void setDuration(@NotNull Duration duration) {
        Intrinsics.checkParameterIsNotNull((Object)duration, (String)"<set-?>");
        this.duration = duration;
    }

    @NotNull
    public final Dataset getDataset() {
        return this.dataset;
    }

    public final void setDataset(@NotNull Dataset dataset) {
        Intrinsics.checkParameterIsNotNull((Object)dataset, (String)"<set-?>");
        this.dataset = dataset;
    }

    public final void run() {
        VirtualUserLoad.Builder builder = new VirtualUserLoad.Builder().virtualUsers(10);
        Duration duration = Duration.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ZERO");
        VirtualUserLoad.Builder builder2 = builder.hold(duration);
        Duration duration2 = Duration.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ZERO");
        VirtualUserLoad load2 = builder2.ramp(duration2).flat(this.duration).build();
        RawRegressionResults results = this.runRegression(load2);
        this.assertNoRegression(results, load2);
    }

    private final RawRegressionResults runRegression(VirtualUserLoad load2) {
        ExecutorService executor;
        TestWorkspace workspace = new RootWorkspace(this.outputDirectory).getCurrentTask().isolateTest("App impact test");
        ProvisioningPerformanceTest baseline = this.testCohort("without " + this.appLabel, (AppSource)new NoApp(null, 1, null));
        ProvisioningPerformanceTest experiment = this.testCohort("with " + this.appLabel, this.app);
        VirtualUserBehavior virtualUserBehavior = new VirtualUserBehavior.Builder(this.scenario).load(load2).browser(this.browser).diagnosticsLimit(255).seed(123L).build();
        TargetingVirtualUserOptions virtualUserOptions2 = new TargetingVirtualUserOptions(virtualUserBehavior){
            final /* synthetic */ VirtualUserBehavior $virtualUserBehavior;

            @NotNull
            public VirtualUserOptions target(@NotNull URI jira) {
                Intrinsics.checkParameterIsNotNull((Object)jira, (String)"jira");
                return new VirtualUserOptions(new VirtualUserTarget(jira, "admin", "admin"), this.$virtualUserBehavior);
            }
            {
                this.$virtualUserBehavior = $captured_local_variable$0;
            }
        };
        ExecutorService executorService = executor = Executors.newFixedThreadPool(2, new CountingThreadFactory("standalone-stability-test"));
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"executor");
        CompletableFuture<RawCohortResult> futureBaselineResults = baseline.executeAsync(workspace, executorService, virtualUserOptions2);
        CompletableFuture<RawCohortResult> futureExperimentResults = experiment.executeAsync(workspace, executor, virtualUserOptions2);
        RawCohortResult baselineResults = futureBaselineResults.get();
        RawCohortResult experimentResults = futureExperimentResults.get();
        executor.shutdownNow();
        RawCohortResult rawCohortResult = baselineResults;
        Intrinsics.checkExpressionValueIsNotNull((Object)rawCohortResult, (String)"baselineResults");
        RawCohortResult rawCohortResult2 = experimentResults;
        Intrinsics.checkExpressionValueIsNotNull((Object)rawCohortResult2, (String)"experimentResults");
        return new RawRegressionResults(rawCohortResult, rawCohortResult2);
    }

    private final ProvisioningPerformanceTest testCohort(String cohort, AppSource app) {
        InfrastructureFormula.Builder builder = new InfrastructureFormula.Builder(this.aws, (VirtualUsersFormula)new StackVirtualUsersFormula.Builder(this.testJar).build());
        String string = "Measure app impact of " + this.appLabel;
        Duration duration = Duration.ofHours(1L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofHours(1)");
        InfrastructureFormula infrastructureFormula = builder.investment(new Investment(string, duration, false, null, 12, null)).jiraFormula((JiraFormula)new StandaloneFormula.Builder(this.productDistribution, this.dataset.getJiraHomeSource(), this.dataset.getDatabase()).apps(new Apps(CollectionsKt.listOf((Object)app))).build()).build();
        String string2 = cohort;
        return new ProvisioningPerformanceTest(infrastructureFormula, string2);
    }

    private final void assertNoRegression(RawRegressionResults results, VirtualUserLoad load2) {
        Path reportWorkspace = this.outputDirectory.resolve("surefire-reports");
        MaximumCoverageJudge maximumCoverageJudge = new MaximumCoverageJudge();
        RawCohortResult rawCohortResult = results.getBaseline();
        RawCohortResult rawCohortResult2 = results.getExperiment();
        PerformanceCriteria performanceCriteria = new PerformanceCriteria(this.criteria, load2, 0, 0, 0, 28, null);
        Path path = reportWorkspace;
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"reportWorkspace");
        TestWorkspace testWorkspace = new TestWorkspace(path);
        PerformanceCriteria performanceCriteria2 = performanceCriteria;
        Verdict verdict = maximumCoverageJudge.judge(rawCohortResult, rawCohortResult2, testWorkspace, performanceCriteria2);
        String string = this.getClass().getCanonicalName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.canonicalName");
        Verdict.assertAccepted$default((Verdict)verdict, (String)string, (Path)reportWorkspace, null, (int)4, null);
    }

    @NotNull
    public final File getTestJar() {
        return this.testJar;
    }

    public final void setTestJar(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.testJar = file;
    }

    public AppImpactTest(@NotNull AppSource app, @NotNull Aws aws, @NotNull File testJar) {
        Intrinsics.checkParameterIsNotNull((Object)app, (String)"app");
        Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
        Intrinsics.checkParameterIsNotNull((Object)testJar, (String)"testJar");
        this.app = app;
        this.aws = aws;
        this.testJar = testJar;
        this.scenario = JiraSoftwareScenario.class;
        this.browser = HeadlessChromeBrowser.class;
        this.criteria = MapsKt.emptyMap();
        this.productDistribution = (ProductDistribution)new PublicJiraSoftwareDistribution("7.5.0");
        Duration duration = Duration.ofMinutes(20L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(20)");
        this.duration = duration;
        this.dataset = new DatasetCatalogue().largeJiraSeven();
        Path path = Paths.get("target", new String[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(\"target\")");
        this.outputDirectory = path;
        this.appLabel = this.app.getLabel();
    }

    public AppImpactTest(@NotNull MavenApp app, @NotNull Aws aws) {
        Intrinsics.checkParameterIsNotNull((Object)app, (String)"app");
        Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
        this((AppSource)app, aws, new File("target/" + app.getArtifactId() + "-performance-tests-" + app.getVersion() + "-fat-tests.jar"));
    }
}

