/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraperformancetests.api;

import com.atlassian.performance.tools.awsinfrastructure.api.CustomDatasetSource;
import com.atlassian.performance.tools.awsinfrastructure.api.Infrastructure;
import com.atlassian.performance.tools.awsinfrastructure.api.RemoteLocation;
import com.atlassian.performance.tools.io.api.DirectoriesKt;
import com.atlassian.performance.tools.workspace.api.RootWorkspace;
import com.atlassian.performance.tools.workspace.api.TaskWorkspace;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Comparator;
import javax.json.Json;
import javax.json.JsonObject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\r\u001a\u0004\u0018\u00010\bJ\u0012\u0010\u000e\u001a\u00020\b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/performance/tools/jiraperformancetests/api/CustomDatasetSourceRegistry;", "", "workspace", "Lcom/atlassian/performance/tools/workspace/api/RootWorkspace;", "(Lcom/atlassian/performance/tools/workspace/api/RootWorkspace;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "extractSource", "Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource;", "task", "Lcom/atlassian/performance/tools/workspace/api/TaskWorkspace;", "jsonFile", "Ljava/io/File;", "load", "register", "infrastructure", "Lcom/atlassian/performance/tools/awsinfrastructure/api/Infrastructure;", "getCreationTime", "Ljava/nio/file/attribute/FileTime;", "Ljava/nio/file/Path;", "jira-performance-tests"})
public final class CustomDatasetSourceRegistry {
    private final Logger logger;
    private final RootWorkspace workspace;

    private final File jsonFile(TaskWorkspace task) {
        File file = task.getDirectory().resolve("dataset-source.json").toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"task\n        .directory\n\u2026.json\")\n        .toFile()");
        return file;
    }

    @NotNull
    public final CustomDatasetSource register(@NotNull Infrastructure<?> infrastructure) {
        Intrinsics.checkParameterIsNotNull(infrastructure, (String)"infrastructure");
        RemoteLocation remoteLocation = infrastructure.getJira().getJiraHome();
        RemoteLocation remoteLocation2 = infrastructure.getJira().getDatabase();
        if (remoteLocation2 == null) {
            Intrinsics.throwNpe();
        }
        CustomDatasetSource datasetSource = new CustomDatasetSource.Builder(remoteLocation, remoteLocation2).build();
        this.logger.info("Registering dataset source");
        FilesKt.writeText$default((File)DirectoriesKt.ensureParentDirectory((File)this.jsonFile(this.workspace.getCurrentTask())), (String)datasetSource.toJson().toString(), null, (int)2, null);
        return datasetSource;
    }

    @Nullable
    public final CustomDatasetSource load() {
        Iterable $receiver$iv = this.workspace.listTasks();
        Iterable iterable = $receiver$iv;
        Comparator comparator = new Comparator<T>(this){
            final /* synthetic */ CustomDatasetSourceRegistry this$0;
            {
                this.this$0 = customDatasetSourceRegistry;
            }

            public final int compare(T a, T b) {
                TaskWorkspace it = (TaskWorkspace)b;
                Comparable comparable = CustomDatasetSourceRegistry.access$getCreationTime(this.this$0, it.getDirectory());
                it = (TaskWorkspace)a;
                Comparable comparable2 = comparable;
                FileTime fileTime = CustomDatasetSourceRegistry.access$getCreationTime(this.this$0, it.getDirectory());
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)fileTime);
            }
        };
        return (CustomDatasetSource)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator)), (Function1)((Function1)new Function1<TaskWorkspace, CustomDatasetSource>(this){
            final /* synthetic */ CustomDatasetSourceRegistry this$0;

            @Nullable
            public final CustomDatasetSource invoke(@NotNull TaskWorkspace it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return CustomDatasetSourceRegistry.access$extractSource(this.this$0, it);
            }
            {
                this.this$0 = customDatasetSourceRegistry;
                super(1);
            }
        })));
    }

    private final FileTime getCreationTime(@NotNull Path $receiver) {
        FileTime fileTime = Files.readAttributes($receiver, BasicFileAttributes.class, new LinkOption[0]).creationTime();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileTime, (String)"Files.readAttributes(\n  \u2026java\n    ).creationTime()");
        return fileTime;
    }

    private final CustomDatasetSource extractSource(TaskWorkspace task) {
        CustomDatasetSource customDatasetSource;
        try {
            JsonObject json;
            File file = this.jsonFile(task);
            Charset charset = Charsets.UTF_8;
            Object object = file;
            object = new FileInputStream((File)object);
            InputStreamReader fileReader = new InputStreamReader((InputStream)object, charset);
            JsonObject jsonObject = json = Json.createReader((Reader)fileReader).readObject();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"json");
            CustomDatasetSource source = new CustomDatasetSource.Builder(jsonObject).build();
            this.logger.info("Found a custom dataset source in " + task.getDirectory());
            customDatasetSource = source;
        }
        catch (Exception e) {
            this.logger.debug("Failed to extract a custom dataset source from " + task, (Throwable)e);
            customDatasetSource = null;
        }
        return customDatasetSource;
    }

    public CustomDatasetSourceRegistry(@NotNull RootWorkspace workspace) {
        Intrinsics.checkParameterIsNotNull((Object)workspace, (String)"workspace");
        this.workspace = workspace;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }

    @NotNull
    public static final /* synthetic */ FileTime access$getCreationTime(CustomDatasetSourceRegistry $this, @NotNull Path $receiver) {
        return $this.getCreationTime($receiver);
    }

    @Nullable
    public static final /* synthetic */ CustomDatasetSource access$extractSource(CustomDatasetSourceRegistry $this, @NotNull TaskWorkspace task) {
        return $this.extractSource(task);
    }
}

