/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraperformancetests.api;

import com.amazonaws.services.cloudformation.model.Stack;
import com.atlassian.performance.tools.aws.api.Aws;
import com.atlassian.performance.tools.aws.api.InvestmentKt;
import com.atlassian.performance.tools.aws.api.ProvisionedStack;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/performance/tools/jiraperformancetests/api/AwsHousekeeping;", "", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "(Lcom/atlassian/performance/tools/aws/api/Aws;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "cleanAllExpired", "", "deleteMyStacks", "listMyStacks", "ListedStack", "jira-performance-tests"})
public final class AwsHousekeeping {
    private final Logger logger;
    private final Aws aws;

    public final void listMyStacks() {
        ProvisionedStack it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = this.aws.listDisposableStacks();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Stack stack = (Stack)item$iv$iv;
            Collection collection = destination$iv$iv;
            ProvisionedStack provisionedStack = new ProvisionedStack((Stack)it, this.aws);
            collection.add(provisionedStack);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (ProvisionedStack)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getUser(), (Object)InvestmentKt.currentUser())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List stacks = (List)destination$iv$iv;
        this.logger.info("Below is the list of AWS stacks that were provisioned by the current user:");
        $receiver$iv = stacks;
        if (!$receiver$iv.isEmpty()) {
            $receiver$iv = stacks;
            for (Object element$iv : $receiver$iv) {
                String string;
                ProvisionedStack it2 = (ProvisionedStack)element$iv;
                Duration remainingTime = Duration.between(Instant.now(), it2.getExpiry());
                String string2 = it2.getStackName();
                String string3 = it2.getUser();
                Duration duration = remainingTime;
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"remainingTime");
                if (duration.isNegative()) {
                    string = "EXPIRED";
                } else {
                    String string4 = remainingTime.toString();
                    string = string4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"remainingTime.toString()");
                }
                ListedStack listedStack = new ListedStack(string2, string3, string, it2.getStatus());
                this.logger.info(it2.getUser() + ": " + listedStack);
            }
        } else {
            this.logger.info("No stacks found");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void deleteMyStacks() {
        Object object;
        ProvisionedStack it;
        Collection collection;
        Iterable $receiver$iv$iv;
        this.logger.info("Retrieving stacks for the current user...");
        Iterable $receiver$iv = this.aws.listDisposableStacks();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Stack stack = (Stack)item$iv$iv;
            collection = destination$iv$iv;
            object = new ProvisionedStack((Stack)it, this.aws);
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (ProvisionedStack)element$iv$iv;
            if (!Intrinsics.areEqual((Object)it.getUser(), (Object)InvestmentKt.currentUser())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List stacks = (List)destination$iv$iv;
        $receiver$iv = stacks;
        if (!$receiver$iv.isEmpty()) {
            this.logger.info("Deleting stacks...");
            $receiver$iv = stacks;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void stack;
                it = (ProvisionedStack)item$iv$iv;
                collection = destination$iv$iv;
                object = stack.release().thenAccept(new Consumer<Object>((ProvisionedStack)stack, this){
                    final /* synthetic */ ProvisionedStack $stack;
                    final /* synthetic */ AwsHousekeeping this$0;
                    {
                        this.$stack = provisionedStack;
                        this.this$0 = awsHousekeeping;
                    }

                    public final void accept(Object it) {
                        AwsHousekeeping.access$getLogger$p(this.this$0).info("Deleted " + this.$stack.getStackName() + ' ');
                    }
                });
                collection.add(object);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                CompletableFuture it2 = (CompletableFuture)element$iv;
                it2.get();
            }
            this.logger.info("All stacks of the current user have been deleted");
        } else {
            this.logger.info("No stacks to delete");
        }
    }

    public final void cleanAllExpired() {
        this.logger.info("Cleaning expired resources...");
        this.aws.cleanLeftovers();
        this.logger.info("All expired resources have been cleaned");
    }

    public AwsHousekeeping(@NotNull Aws aws) {
        Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
        this.aws = aws;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(AwsHousekeeping $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J3\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/performance/tools/jiraperformancetests/api/AwsHousekeeping$ListedStack;", "", "name", "", "user", "timeLeft", "status", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getStatus", "getTimeLeft", "getUser", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "jira-performance-tests"})
    private static final class ListedStack {
        @NotNull
        private final String name;
        @Nullable
        private final String user;
        @NotNull
        private final String timeLeft;
        @NotNull
        private final String status;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getUser() {
            return this.user;
        }

        @NotNull
        public final String getTimeLeft() {
            return this.timeLeft;
        }

        @NotNull
        public final String getStatus() {
            return this.status;
        }

        public ListedStack(@NotNull String name, @Nullable String user, @NotNull String timeLeft, @NotNull String status) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)timeLeft, (String)"timeLeft");
            Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
            this.name = name;
            this.user = user;
            this.timeLeft = timeLeft;
            this.status = status;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final String component2() {
            return this.user;
        }

        @NotNull
        public final String component3() {
            return this.timeLeft;
        }

        @NotNull
        public final String component4() {
            return this.status;
        }

        @NotNull
        public final ListedStack copy(@NotNull String name, @Nullable String user, @NotNull String timeLeft, @NotNull String status) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)timeLeft, (String)"timeLeft");
            Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
            return new ListedStack(name, user, timeLeft, status);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ListedStack copy$default(ListedStack listedStack, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = listedStack.name;
            }
            if ((n & 2) != 0) {
                string2 = listedStack.user;
            }
            if ((n & 4) != 0) {
                string3 = listedStack.timeLeft;
            }
            if ((n & 8) != 0) {
                string4 = listedStack.status;
            }
            return listedStack.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "ListedStack(name=" + this.name + ", user=" + this.user + ", timeLeft=" + this.timeLeft + ", status=" + this.status + ")";
        }

        public int hashCode() {
            String string = this.name;
            String string2 = this.user;
            String string3 = this.timeLeft;
            String string4 = this.status;
            return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ListedStack)) break block3;
                    ListedStack listedStack = (ListedStack)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)listedStack.name) || !Intrinsics.areEqual((Object)this.user, (Object)listedStack.user) || !Intrinsics.areEqual((Object)this.timeLeft, (Object)listedStack.timeLeft) || !Intrinsics.areEqual((Object)this.status, (Object)listedStack.status)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

