/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.page;

import com.atlassian.performance.tools.jiraactions.api.page.WebDriverUtils;
import com.atlassian.performance.tools.jiraactions.api.webdriver.HardenedKeyboardKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.pagefactory.ByChained;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J \u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\r\u0012\u0004\u0012\u00020\u000b0\u0012J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/performance/tools/jiraactions/page/SingleSelect;", "", "driver", "Lorg/openqa/selenium/WebDriver;", "locator", "Lorg/openqa/selenium/By;", "(Lorg/openqa/selenium/WebDriver;Lorg/openqa/selenium/By;)V", "inputLocator", "Lorg/openqa/selenium/support/pagefactory/ByChained;", "parent", "getCurrentValue", "", "getSuggestions", "", "parseSuggestions", "select", "", "picker", "Lkotlin/Function1;", "value", "jira-actions"})
public final class SingleSelect {
    private final By parent;
    private final ByChained inputLocator;
    private final WebDriver driver;

    public final void select(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        WebElement webElement = this.driver.findElement((By)this.inputLocator);
        Intrinsics.checkExpressionValueIsNotNull((Object)webElement, (String)"driver.findElement(inputLocator)");
        HardenedKeyboardKt.sendKeysWhenClickable(webElement, this.driver, (CharSequence)Keys.BACK_SPACE, value, (CharSequence)Keys.TAB);
    }

    public final void select(@NotNull Function1<? super List<String>, String> picker) {
        Intrinsics.checkParameterIsNotNull(picker, (String)"picker");
        ExpectedCondition expectedCondition = ExpectedConditions.elementToBeClickable((By)((By)this.inputLocator));
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"elementToBeClickable(inputLocator)");
        WebElement inputElement = (WebElement)WebDriverUtils.wait(this.driver, expectedCondition);
        inputElement.click();
        Collection collection = this.parseSuggestions();
        String string = inputElement.getAttribute("value");
        if (string == null) {
            Intrinsics.throwNpe();
        }
        List availableValues = CollectionsKt.plus((Collection)collection, (Object)string);
        inputElement.sendKeys(new CharSequence[]{(CharSequence)Keys.BACK_SPACE, (CharSequence)picker.invoke((Object)availableValues), (CharSequence)Keys.TAB});
    }

    @NotNull
    public final List<String> getSuggestions() {
        ExpectedCondition expectedCondition = ExpectedConditions.elementToBeClickable((By)((By)new ByChained(new By[]{this.parent, By.className((String)"drop-menu")})));
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"elementToBeClickable(\n  \u2026menu\"))\n                )");
        WebElement dropMenuArrow = (WebElement)WebDriverUtils.wait(this.driver, expectedCondition);
        dropMenuArrow.click();
        List<String> suggestions = this.parseSuggestions();
        dropMenuArrow.click();
        new Actions(this.driver).sendKeys(new CharSequence[]{(CharSequence)Keys.TAB, (CharSequence)Keys.TAB}).build().perform();
        return suggestions;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> parseSuggestions() {
        void var3_3;
        void $receiver$iv$iv;
        ExpectedCondition expectedCondition = ExpectedConditions.presenceOfElementLocated((By)By.cssSelector((String)".ajs-layer.active"));
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"presenceOfElementLocated\u2026tor(\".ajs-layer.active\"))");
        List list = ((WebElement)WebDriverUtils.wait(this.driver, expectedCondition)).findElements(By.className((String)"aui-list-item-link"));
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"driver\n                .\u2026me(\"aui-list-item-link\"))");
        Iterable $receiver$iv = list;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            WebElement webElement = (WebElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            String string = v2.getText();
            collection.add(string);
        }
        return (List)var3_3;
    }

    @NotNull
    public final String getCurrentValue() {
        String string = this.driver.findElement((By)this.inputLocator).getAttribute("value");
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    public SingleSelect(@NotNull WebDriver driver, @NotNull By locator) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull((Object)locator, (String)"locator");
        this.driver = driver;
        this.parent = (By)new ByChained(new By[]{locator, By.xpath((String)"..")});
        this.inputLocator = new ByChained(new By[]{this.parent, By.tagName((String)"input")});
    }
}

