/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api.w3c;

import com.atlassian.performance.tools.jiraactions.api.w3c.RecordedPerformanceEntries;
import com.atlassian.performance.tools.jiraactions.api.w3c.W3cPerformanceTimeline;
import com.atlassian.performance.tools.jiraactions.w3c.harvesters.CommonKt;
import com.atlassian.performance.tools.jiraactions.w3c.harvesters.JsElementsKt;
import com.atlassian.performance.tools.jiraactions.w3c.harvesters.JsNavigationsKt;
import com.atlassian.performance.tools.jiraactions.w3c.harvesters.JsResourcesKt;
import java.time.Instant;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.JavascriptExecutor;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/w3c/JavascriptW3cPerformanceTimeline;", "Lcom/atlassian/performance/tools/jiraactions/api/w3c/W3cPerformanceTimeline;", "javascript", "Lorg/openqa/selenium/JavascriptExecutor;", "(Lorg/openqa/selenium/JavascriptExecutor;)V", "recordNavigation", "", "recordResources", "recordElements", "(Lorg/openqa/selenium/JavascriptExecutor;ZZZ)V", "getTimeOrigin", "Ljava/time/Instant;", "record", "Lcom/atlassian/performance/tools/jiraactions/api/w3c/RecordedPerformanceEntries;", "Builder", "jira-actions"})
public final class JavascriptW3cPerformanceTimeline
implements W3cPerformanceTimeline {
    private final JavascriptExecutor javascript;
    private final boolean recordNavigation;
    private final boolean recordResources;
    private final boolean recordElements;

    @Override
    @NotNull
    public RecordedPerformanceEntries record() {
        return new RecordedPerformanceEntries(this.recordNavigation ? JsNavigationsKt.getJsNavigationsPerformance(this.javascript) : CollectionsKt.emptyList(), this.recordResources ? JsResourcesKt.getJsResourcesPerformance(this.javascript) : CollectionsKt.emptyList(), this.recordElements ? JsElementsKt.getJsElementsPerformance(this.javascript) : CollectionsKt.emptyList(), this.getTimeOrigin(this.javascript));
    }

    private final Instant getTimeOrigin(JavascriptExecutor javascript) {
        return CommonKt.parseInstantMilli(javascript.executeScript("return window.performance.timeOrigin;", new Object[0]));
    }

    private JavascriptW3cPerformanceTimeline(JavascriptExecutor javascript, boolean recordNavigation, boolean recordResources, boolean recordElements) {
        this.javascript = javascript;
        this.recordNavigation = recordNavigation;
        this.recordResources = recordResources;
        this.recordElements = recordElements;
    }

    @Deprecated(message="Use JavascriptW3cPerformanceTimeline.Builder instead.")
    public JavascriptW3cPerformanceTimeline(@NotNull JavascriptExecutor javascript) {
        Intrinsics.checkParameterIsNotNull((Object)javascript, (String)"javascript");
        this(javascript, true, true, false);
    }

    public /* synthetic */ JavascriptW3cPerformanceTimeline(@NotNull JavascriptExecutor javascript, boolean recordNavigation, boolean recordResources, boolean recordElements, DefaultConstructorMarker $constructor_marker) {
        this(javascript, recordNavigation, recordResources, recordElements);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u000b\u001a\u00020\u0000J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/w3c/JavascriptW3cPerformanceTimeline$Builder;", "", "javascript", "Lorg/openqa/selenium/JavascriptExecutor;", "(Lorg/openqa/selenium/JavascriptExecutor;)V", "recordElements", "", "recordNavigation", "recordResources", "build", "Lcom/atlassian/performance/tools/jiraactions/api/w3c/W3cPerformanceTimeline;", "recordAll", "jira-actions"})
    public static final class Builder {
        private boolean recordNavigation;
        private boolean recordResources;
        private boolean recordElements;
        private JavascriptExecutor javascript;

        @NotNull
        public final Builder javascript(@NotNull JavascriptExecutor javascript) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)javascript, (String)"javascript");
            Builder $receiver = builder = this;
            $receiver.javascript = javascript;
            return builder;
        }

        @NotNull
        public final Builder recordNavigation(boolean recordNavigation) {
            Builder builder;
            Builder $receiver = builder = this;
            $receiver.recordNavigation = recordNavigation;
            return builder;
        }

        @NotNull
        public final Builder recordResources(boolean recordResources) {
            Builder builder;
            Builder $receiver = builder = this;
            $receiver.recordResources = recordResources;
            return builder;
        }

        @NotNull
        public final Builder recordElements(boolean recordElements) {
            Builder builder;
            Builder $receiver = builder = this;
            $receiver.recordElements = recordElements;
            return builder;
        }

        @NotNull
        public final Builder recordAll() {
            Builder builder;
            Builder $receiver = builder = this;
            $receiver.recordNavigation = true;
            $receiver.recordResources = true;
            $receiver.recordElements = true;
            return builder;
        }

        @NotNull
        public final W3cPerformanceTimeline build() {
            return new JavascriptW3cPerformanceTimeline(this.javascript, this.recordNavigation, this.recordResources, this.recordElements, null);
        }

        public Builder(@NotNull JavascriptExecutor javascript) {
            Intrinsics.checkParameterIsNotNull((Object)javascript, (String)"javascript");
            this.javascript = javascript;
            this.recordNavigation = true;
            this.recordResources = true;
        }
    }
}

