/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api.page.form;

import com.atlassian.performance.tools.jiraactions.api.page.WebDriverUtils;
import com.atlassian.performance.tools.jiraactions.page.form.ComboBox;
import com.atlassian.performance.tools.jiraactions.page.form.FormField;
import com.atlassian.performance.tools.jiraactions.page.form.FormFieldFactory;
import com.atlassian.performance.tools.jiraactions.page.form.FromFieldType;
import com.atlassian.performance.tools.jiraactions.page.form.Select;
import com.atlassian.performance.tools.jiraactions.page.form.TextArea;
import com.atlassian.performance.tools.jiraactions.page.form.TextInput;
import com.atlassian.performance.tools.jiraactions.page.form.TextSelectField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\u0000J\u0010\u0010\n\u001a\n \b*\u0004\u0018\u00010\u000b0\u000bH\u0002J\u001f\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/page/form/IssueForm;", "", "formLocator", "Lorg/openqa/selenium/By;", "driver", "Lorg/openqa/selenium/WebDriver;", "(Lorg/openqa/selenium/By;Lorg/openqa/selenium/WebDriver;)V", "requiredFieldGroupsLocator", "kotlin.jvm.PlatformType", "fillRequiredFields", "getForm", "Lorg/openqa/selenium/WebElement;", "waitForRefresh", "T", "action", "Ljava/util/function/Supplier;", "(Ljava/util/function/Supplier;)Ljava/lang/Object;", "jira-actions"})
public final class IssueForm {
    private final By requiredFieldGroupsLocator;
    private final By formLocator;
    private final WebDriver driver;

    public final <T> T waitForRefresh(@NotNull Supplier<T> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        WebElement form = this.getForm();
        T result = action.get();
        ExpectedCondition expectedCondition = ExpectedConditions.invisibilityOf((WebElement)form);
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"invisibilityOf(form)");
        WebDriverUtils.wait(this.driver, expectedCondition);
        return result;
    }

    @NotNull
    public final IssueForm fillRequiredFields() {
        Object it;
        Iterable $receiver$iv$iv;
        WebElement form = this.getForm();
        FormFieldFactory formFieldFactory = new FormFieldFactory(this.driver, CollectionsKt.listOf((Object[])new FromFieldType[]{new TextInput.Descriptor(), new ComboBox.Descriptor(), new TextSelectField.Descriptor(), new Select.Descriptor(), new TextArea.Descriptor()}));
        List list = form.findElements(this.requiredFieldGroupsLocator);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"form.findElements(requiredFieldGroupsLocator)");
        Iterable $receiver$iv = list;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (WebElement)element$iv$iv;
            WebElement webElement = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)webElement, (String)"it");
            if (!webElement.isDisplayed()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (WebElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            WebElement webElement = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)webElement, (String)"it");
            FormField formField = formFieldFactory.getFormField(webElement);
            collection.add(formField);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (FormField)element$iv$iv;
            if (!(!it.hasValue())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            FormField it2 = (FormField)element$iv;
            it2.fillWithAnyValue();
        }
        return this;
    }

    private final WebElement getForm() {
        return this.driver.findElement(this.formLocator);
    }

    public IssueForm(@NotNull By formLocator, @NotNull WebDriver driver) {
        Intrinsics.checkParameterIsNotNull((Object)formLocator, (String)"formLocator");
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        this.formLocator = formLocator;
        this.driver = driver;
        this.requiredFieldGroupsLocator = By.xpath((String)"//span[contains(@class,'icon-required')]/ancestor::div[contains(@class,'field-group')]");
    }
}

