/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api.page;

import com.atlassian.performance.tools.jiraactions.Patience;
import com.atlassian.performance.tools.jiraactions.api.page.AdminAccess;
import com.atlassian.performance.tools.jiraactions.api.page.WebDriverUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\u0000J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\n \t*\u0004\u0018\u00010\u00100\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/page/RichTextEditorConfiguration;", "", "driver", "Lorg/openqa/selenium/WebDriver;", "access", "Lcom/atlassian/performance/tools/jiraactions/api/page/AdminAccess;", "(Lorg/openqa/selenium/WebDriver;Lcom/atlassian/performance/tools/jiraactions/api/page/AdminAccess;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "switchLocator", "Lorg/openqa/selenium/By;", "disable", "ensureSwitchIsOff", "", "getSwitchInput", "Lorg/openqa/selenium/WebElement;", "isSwitchPresent", "", "jira-actions"})
public final class RichTextEditorConfiguration {
    private final Logger logger;
    private final By switchLocator;
    private final WebDriver driver;
    private final AdminAccess access;

    @NotNull
    public final RichTextEditorConfiguration disable() {
        this.access.runWithAccess$jira_actions((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RichTextEditorConfiguration this$0;

            public final void invoke() {
                if (RichTextEditorConfiguration.access$isSwitchPresent(this.this$0)) {
                    RichTextEditorConfiguration.access$ensureSwitchIsOff(this.this$0);
                } else {
                    RichTextEditorConfiguration.access$getLogger$p(this.this$0).info("This Jira does not support RTE configuration, so RTE should be de facto disabled");
                }
            }
            {
                this.this$0 = richTextEditorConfiguration;
                super(0);
            }
        }));
        return this;
    }

    private final boolean isSwitchPresent() {
        return new Patience(null, 1, null).test((Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ RichTextEditorConfiguration this$0;

            public final boolean invoke() {
                WebDriver webDriver = RichTextEditorConfiguration.access$getDriver$p(this.this$0);
                By by = RichTextEditorConfiguration.access$getSwitchLocator$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"switchLocator");
                return WebDriverUtils.isElementPresent(webDriver, by);
            }
            {
                this.this$0 = richTextEditorConfiguration;
                super(0);
            }
        }));
    }

    private final void ensureSwitchIsOff() {
        WebElement webElement = this.getSwitchInput();
        Intrinsics.checkExpressionValueIsNotNull((Object)webElement, (String)"getSwitchInput()");
        if (webElement.isSelected()) {
            this.logger.info("RTE is enabled, disabling...");
            if (this.access.isGranted()) {
                this.logger.info("Admin access already granted, clicking the RTE switch...");
                ExpectedCondition expectedCondition = ExpectedConditions.elementToBeClickable((By)this.switchLocator);
                Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"elementToBeClickable(switchLocator)");
                ((WebElement)WebDriverUtils.wait(this.driver, expectedCondition)).click();
                ExpectedCondition expectedCondition2 = ExpectedConditions.not((ExpectedCondition)ExpectedConditions.attributeToBe((WebElement)this.getSwitchInput(), (String)"aria-busy", (String)"true"));
                Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition2, (String)"not(attributeToBe(getSwi\u2026(), \"aria-busy\", \"true\"))");
                WebDriverUtils.wait(this.driver, expectedCondition2);
                ExpectedCondition expectedCondition3 = ExpectedConditions.not((ExpectedCondition)ExpectedConditions.elementToBeSelected((WebElement)this.getSwitchInput()));
                Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition3, (String)"not(elementToBeSelected(getSwitchInput()))");
                WebDriverUtils.wait(this.driver, expectedCondition3);
                this.logger.info("RTE should be disabled now");
            } else {
                this.logger.info("Admin access not granted yet, gaining access proactively and retrying...");
                this.access.gainProactively();
                this.ensureSwitchIsOff();
            }
        } else {
            this.logger.info("RTE is already disabled");
        }
    }

    private final WebElement getSwitchInput() {
        ExpectedCondition expectedCondition = ExpectedConditions.elementToBeClickable((By)By.id((String)"rte-switch-input"));
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"elementToBeClickable(By.id(\"rte-switch-input\"))");
        return (WebElement)WebDriverUtils.wait(this.driver, expectedCondition);
    }

    public RichTextEditorConfiguration(@NotNull WebDriver driver, @NotNull AdminAccess access) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull((Object)access, (String)"access");
        this.driver = driver;
        this.access = access;
        this.logger = LogManager.getLogger(this.getClass());
        this.switchLocator = By.id((String)"rte-switch");
    }

    public static final /* synthetic */ boolean access$isSwitchPresent(RichTextEditorConfiguration $this) {
        return $this.isSwitchPresent();
    }

    public static final /* synthetic */ void access$ensureSwitchIsOff(RichTextEditorConfiguration $this) {
        $this.ensureSwitchIsOff();
    }

    public static final /* synthetic */ Logger access$getLogger$p(RichTextEditorConfiguration $this) {
        return $this.logger;
    }

    @NotNull
    public static final /* synthetic */ WebDriver access$getDriver$p(RichTextEditorConfiguration $this) {
        return $this.driver;
    }

    public static final /* synthetic */ By access$getSwitchLocator$p(RichTextEditorConfiguration $this) {
        return $this.switchLocator;
    }
}

