/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api.page;

import com.atlassian.performance.seleniumjs.NativeExpectedCondition;
import com.atlassian.performance.seleniumjs.NativeExpectedConditions;
import com.atlassian.performance.tools.jiraactions.api.memories.Project;
import com.atlassian.performance.tools.jiraactions.api.page.CommentTabPanel;
import com.atlassian.performance.tools.jiraactions.api.page.HistoryTabPanel;
import com.atlassian.performance.tools.jiraactions.api.page.JiraErrors;
import com.atlassian.performance.tools.jiraactions.api.page.WebDriverUtils;
import com.atlassian.performance.tools.jiraactions.page.UserProfilePage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0012J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\b\u0010\u0015\u001a\u0004\u0018\u00010\fJ\u0006\u0010\u0016\u001a\u00020\fJ\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u000f\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u0006\u0010 \u001a\u00020\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/page/IssuePage;", "", "driver", "Lorg/openqa/selenium/WebDriver;", "(Lorg/openqa/selenium/WebDriver;)V", "assigneeUserField", "Lorg/openqa/selenium/By;", "kotlin.jvm.PlatformType", "projectNameInBreadcrumbs", "reporterUserField", "summaryField", "getAssignee", "", "getDescription", "getIssueId", "", "getIssueType", "getPossiblePriorities", "", "getProject", "Lcom/atlassian/performance/tools/jiraactions/api/memories/Project;", "getReporter", "getSummary", "isEditable", "", "openCommentTabPanel", "Lcom/atlassian/performance/tools/jiraactions/api/page/CommentTabPanel;", "openHistoryTabPanel", "Lcom/atlassian/performance/tools/jiraactions/api/page/HistoryTabPanel;", "visitReporterProfile", "Lcom/atlassian/performance/tools/jiraactions/page/UserProfilePage;", "visitReporterProfile$jira_actions", "waitForSummary", "jira-actions"})
public final class IssuePage {
    private final By reporterUserField;
    private final By assigneeUserField;
    private final By projectNameInBreadcrumbs;
    private final By summaryField;
    private final WebDriver driver;

    @NotNull
    public final IssuePage waitForSummary() {
        this.driver.findElements(By.id((String)"summary-val")).stream().findFirst();
        JiraErrors jiraErrors = new JiraErrors(this.driver);
        NativeExpectedCondition[] nativeExpectedConditionArray = new NativeExpectedCondition[2];
        By by = this.summaryField;
        Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"summaryField");
        nativeExpectedConditionArray[0] = NativeExpectedConditions.Companion.visibilityOfElementLocated(by);
        nativeExpectedConditionArray[1] = jiraErrors.anyCommonErrorNative();
        WebDriverUtils.wait$default(this.driver, null, NativeExpectedConditions.Companion.or(nativeExpectedConditionArray), null, 5, null);
        jiraErrors.assertNoErrors();
        return this;
    }

    public final boolean isEditable() {
        List list = this.driver.findElements(By.id((String)"edit-issue"));
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"driver\n            .find\u2026ents(By.id(\"edit-issue\"))");
        WebElement webElement = (WebElement)CollectionsKt.firstOrNull((List)list);
        return (webElement != null ? webElement.getAttribute("href") : null) != null;
    }

    @Nullable
    public final String getReporter() {
        List list = this.driver.findElements(this.reporterUserField);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"driver.findElements(reporterUserField)");
        WebElement webElement = (WebElement)CollectionsKt.firstOrNull((List)list);
        return webElement != null ? webElement.getAttribute("rel") : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<String> getPossiblePriorities() {
        void var3_3;
        void $receiver$iv$iv;
        List list = this.driver.findElements(By.id((String)"priority-val"));
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"driver\n            .find\u2026ts(By.id(\"priority-val\"))");
        WebElement webElement = (WebElement)CollectionsKt.firstOrNull((List)list);
        if (webElement == null) {
            return null;
        }
        webElement.click();
        ExpectedCondition expectedCondition = ExpectedConditions.visibilityOfElementLocated((By)By.id((String)"priority-suggestions"));
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"visibilityOfElementLocat\u2026(\"priority-suggestions\"))");
        List list2 = ((WebElement)WebDriverUtils.wait(this.driver, expectedCondition)).findElements(By.tagName((String)"a"));
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"driver\n            .wait\u2026Elements(By.tagName(\"a\"))");
        Iterable $receiver$iv = list2;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            WebElement webElement2 = (WebElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            void v4 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"it");
            String string = v4.getText();
            collection.add(string);
        }
        return (List)var3_3;
    }

    @Nullable
    public final Project getProject() {
        WebElement projectNameElement;
        WebElement webElement = projectNameElement = this.driver.findElement(this.projectNameInBreadcrumbs);
        Intrinsics.checkExpressionValueIsNotNull((Object)webElement, (String)"projectNameElement");
        String projectName = webElement.getText();
        String string = projectNameElement.getAttribute("href");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"projectNameElement.getAttribute(\"href\")");
        String projectKey = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])new String[]{"/browse/"}, (boolean)false, (int)0, (int)6, null));
        String string2 = projectName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"projectName");
        return new Project(projectKey, string2);
    }

    @Nullable
    public final String getAssignee() {
        List list = this.driver.findElements(this.assigneeUserField);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"driver.findElements(assigneeUserField)");
        WebElement webElement = (WebElement)CollectionsKt.firstOrNull((List)list);
        return webElement != null ? webElement.getAttribute("rel") : null;
    }

    @Nullable
    public final UserProfilePage visitReporterProfile$jira_actions() {
        String string = this.getReporter();
        if (string == null) {
            return null;
        }
        String reporter = string;
        return new UserProfilePage(this.driver).navigateTo(reporter).waitForPageLoad();
    }

    @NotNull
    public final String getSummary() {
        WebElement webElement = this.driver.findElement(By.id((String)"summary-val"));
        Intrinsics.checkExpressionValueIsNotNull((Object)webElement, (String)"driver.findElement(By.id(\"summary-val\"))");
        String string = webElement.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"driver.findElement(By.id(\"summary-val\")).text");
        return string;
    }

    @NotNull
    public final String getDescription() {
        WebElement webElement = this.driver.findElement(By.cssSelector((String)"#description-val .user-content-block"));
        Intrinsics.checkExpressionValueIsNotNull((Object)webElement, (String)"driver.findElement(By.cs\u2026al .user-content-block\"))");
        String string = webElement.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"driver.findElement(By.cs\u2026ser-content-block\")).text");
        return string;
    }

    public final long getIssueId() {
        String string = this.driver.findElement(By.id((String)"key-val")).getAttribute("rel");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"driver.findElement(By.id\u2026al\")).getAttribute(\"rel\")");
        String string2 = string;
        return Long.parseLong(string2);
    }

    @NotNull
    public final String getIssueType() {
        WebElement webElement = this.driver.findElement(By.id((String)"type-val"));
        Intrinsics.checkExpressionValueIsNotNull((Object)webElement, (String)"driver.findElement(By.id(\"type-val\"))");
        String string = webElement.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"driver.findElement(By.id(\"type-val\")).text");
        return string;
    }

    @NotNull
    public final CommentTabPanel openCommentTabPanel() {
        return new CommentTabPanel(this.driver).waitForActive();
    }

    @NotNull
    public final HistoryTabPanel openHistoryTabPanel() {
        return new HistoryTabPanel(this.driver).waitForActive();
    }

    public IssuePage(@NotNull WebDriver driver) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        this.driver = driver;
        this.reporterUserField = By.cssSelector((String)"#reporter-val span");
        this.assigneeUserField = By.cssSelector((String)"#assignee-val span");
        this.projectNameInBreadcrumbs = By.id((String)"project-name-val");
        this.summaryField = By.id((String)"summary-val");
    }
}

