/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api.page;

import com.atlassian.performance.seleniumjs.NativeExpectedCondition;
import com.atlassian.performance.seleniumjs.NativeExpectedConditions;
import com.atlassian.performance.tools.jiraactions.api.page.IssuePage;
import com.atlassian.performance.tools.jiraactions.api.page.JiraErrors;
import com.atlassian.performance.tools.jiraactions.api.page.WebDriverUtils;
import com.atlassian.performance.tools.jiraactions.api.page.issuenav.IssueNavResultsView;
import com.atlassian.performance.tools.jiraactions.page.issuenav.UnknownView;
import java.time.Duration;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0003H\u0004J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u0017J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0000H\u0007J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/page/IssueNavigatorPage;", "", "driver", "Lorg/openqa/selenium/WebDriver;", "jql", "", "(Lorg/openqa/selenium/WebDriver;Ljava/lang/String;)V", "emptyResults", "Lcom/atlassian/performance/seleniumjs/NativeExpectedCondition;", "getJql", "()Ljava/lang/String;", "getDriver", "getIssueKeys", "", "getTotalResults", "", "issueView", "Lcom/atlassian/performance/tools/jiraactions/api/page/IssuePage;", "selectedIssueId", "", "waitForIssueNavigator", "waitForResults", "results", "Lcom/atlassian/performance/tools/jiraactions/api/page/issuenav/IssueNavResultsView;", "jira-actions"})
public class IssueNavigatorPage {
    private final NativeExpectedCondition emptyResults;
    private final WebDriver driver;
    @NotNull
    private final String jql;

    @Deprecated(message="Waiting for results depend on the results view", replaceWith=@ReplaceWith(imports={}, expression="waitForResults"))
    @NotNull
    public final IssueNavigatorPage waitForIssueNavigator() {
        return this.waitForResults(new UnknownView(this.driver));
    }

    @NotNull
    public final IssueNavigatorPage waitForResults(@NotNull IssueNavResultsView results) {
        Intrinsics.checkParameterIsNotNull((Object)results, (String)"results");
        JiraErrors jiraErrors = new JiraErrors(this.driver);
        Duration duration = Duration.ofSeconds(10L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(10)");
        WebDriverUtils.wait$default(this.driver, duration, NativeExpectedConditions.Companion.or(new NativeExpectedCondition[]{results.detectResults(), this.emptyResults, jiraErrors.anyCommonErrorNative()}), null, 4, null);
        return this;
    }

    @Deprecated(message="Issue keys depend on the results view", replaceWith=@ReplaceWith(imports={}, expression="IssueNavResultsView.listIssueKeys().toSet()"))
    @NotNull
    public Set<String> getIssueKeys() {
        return CollectionsKt.toSet((Iterable)new UnknownView(this.driver).listIssueKeys());
    }

    @NotNull
    public final IssuePage issueView() {
        return new IssuePage(this.driver);
    }

    public final long selectedIssueId() {
        return new IssuePage(this.driver).getIssueId();
    }

    @NotNull
    protected final WebDriver getDriver() {
        return this.driver;
    }

    @Deprecated(message="Total results depend on the results view", replaceWith=@ReplaceWith(imports={}, expression="IssueNavResultsView.countResults()"))
    public final int getTotalResults() {
        Integer n = new UnknownView(this.driver).countResults();
        return n != null ? n : 0;
    }

    @NotNull
    public final String getJql() {
        return this.jql;
    }

    public IssueNavigatorPage(@NotNull WebDriver driver, @NotNull String jql) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull((Object)jql, (String)"jql");
        this.driver = driver;
        this.jql = jql;
        By by = By.className((String)"no-results-hint");
        Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"By.className(\"no-results-hint\")");
        this.emptyResults = NativeExpectedConditions.Companion.presenceOfElementLocated(by);
    }
}

