/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api.page;

import com.atlassian.performance.tools.jiraactions.api.page.IssuePage;
import com.atlassian.performance.tools.jiraactions.api.page.JiraErrors;
import com.atlassian.performance.tools.jiraactions.api.page.RichTextEditorTextArea;
import com.atlassian.performance.tools.jiraactions.api.page.WebDriverUtils;
import com.atlassian.performance.tools.jiraactions.api.page.form.IssueForm;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\u0000J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0000J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/page/EditIssuePage;", "", "driver", "Lorg/openqa/selenium/WebDriver;", "(Lorg/openqa/selenium/WebDriver;)V", "descriptionFieldLocator", "Lorg/openqa/selenium/By;", "kotlin.jvm.PlatformType", "form", "Lcom/atlassian/performance/tools/jiraactions/api/page/form/IssueForm;", "summaryLocator", "updateButtonLocator", "fillForm", "submit", "Lcom/atlassian/performance/tools/jiraactions/api/page/IssuePage;", "waitForEditIssueForm", "clearAndTypeIfPresent", "", "text", "", "jira-actions"})
public final class EditIssuePage {
    private final IssueForm form;
    private final By summaryLocator;
    private final By updateButtonLocator;
    private final By descriptionFieldLocator;
    private final WebDriver driver;

    @NotNull
    public final EditIssuePage waitForEditIssueForm() {
        JiraErrors jiraErrors = new JiraErrors(this.driver);
        ExpectedCondition expectedCondition = ExpectedConditions.or((ExpectedCondition[])new ExpectedCondition[]{ExpectedConditions.presenceOfElementLocated((By)this.updateButtonLocator), jiraErrors.anyCommonError(), jiraErrors.anyCommonWarning()});
        Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"or(\n                pres\u2026onWarning()\n            )");
        WebDriverUtils.wait(this.driver, expectedCondition);
        jiraErrors.assertNoErrors();
        WebDriverUtils.tolerateDirtyFormsOnCurrentPage(this.driver);
        return this;
    }

    @NotNull
    public final EditIssuePage fillForm() {
        By by = this.summaryLocator;
        Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"summaryLocator");
        this.clearAndTypeIfPresent(by, "summary");
        By by2 = this.descriptionFieldLocator;
        Intrinsics.checkExpressionValueIsNotNull((Object)by2, (String)"descriptionFieldLocator");
        if (WebDriverUtils.isElementPresent(this.driver, by2)) {
            WebElement webElement = this.driver.findElement(this.descriptionFieldLocator);
            Intrinsics.checkExpressionValueIsNotNull((Object)webElement, (String)"driver.findElement(descriptionFieldLocator)");
            new RichTextEditorTextArea(this.driver, webElement).overwriteIfPresent("description");
        }
        this.form.fillRequiredFields();
        return this;
    }

    @NotNull
    public final IssuePage submit() {
        this.driver.findElement(this.updateButtonLocator).click();
        return new IssuePage(this.driver).waitForSummary();
    }

    private final void clearAndTypeIfPresent(@NotNull By $receiver, String text) {
        if (WebDriverUtils.isElementPresent(this.driver, $receiver)) {
            WebElement webElement = this.driver.findElement($receiver);
            ExpectedCondition expectedCondition = ExpectedConditions.elementToBeClickable((WebElement)webElement);
            Intrinsics.checkExpressionValueIsNotNull((Object)expectedCondition, (String)"elementToBeClickable(webElement)");
            WebDriverUtils.wait(this.driver, expectedCondition);
            webElement.clear();
            webElement.sendKeys(new CharSequence[]{text});
        }
    }

    public EditIssuePage(@NotNull WebDriver driver) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        this.driver = driver;
        By by = By.id((String)"issue-edit");
        Intrinsics.checkExpressionValueIsNotNull((Object)by, (String)"By.id(\"issue-edit\")");
        this.form = new IssueForm(by, this.driver);
        this.summaryLocator = By.id((String)"summary");
        this.updateButtonLocator = By.id((String)"issue-edit-submit");
        this.descriptionFieldLocator = By.id((String)"description");
    }
}

