/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api.measure;

import com.atlassian.performance.tools.concurrency.api.GracefulTerminationKt;
import com.atlassian.performance.tools.jiraactions.api.ActionMetric;
import com.atlassian.performance.tools.jiraactions.api.ActionResult;
import com.atlassian.performance.tools.jiraactions.api.ActionType;
import com.atlassian.performance.tools.jiraactions.api.measure.ActionMeter;
import com.atlassian.performance.tools.jiraactions.api.measure.DrillDownHook;
import com.atlassian.performance.tools.jiraactions.api.measure.PostMetricHook;
import com.atlassian.performance.tools.jiraactions.api.measure.output.ActionMetricOutput;
import com.atlassian.performance.tools.jiraactions.api.measure.output.ThrowawayActionMetricOutput;
import com.atlassian.performance.tools.jiraactions.api.w3c.W3cPerformanceTimeline;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.json.JsonObject;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001 B'\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bB-\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ+\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0015\u00a2\u0006\u0002\u0010\u0016JA\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u00152\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u0002H\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u001c\u001a\u00020\u001d*\u00060\u001ej\u0002`\u001fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/measure/ActionMeter;", "", "virtualUser", "Ljava/util/UUID;", "output", "Lcom/atlassian/performance/tools/jiraactions/api/measure/output/ActionMetricOutput;", "clock", "Ljava/time/Clock;", "w3cPerformanceTimeline", "Lcom/atlassian/performance/tools/jiraactions/api/w3c/W3cPerformanceTimeline;", "(Ljava/util/UUID;Lcom/atlassian/performance/tools/jiraactions/api/measure/output/ActionMetricOutput;Ljava/time/Clock;Lcom/atlassian/performance/tools/jiraactions/api/w3c/W3cPerformanceTimeline;)V", "(Ljava/util/UUID;Lcom/atlassian/performance/tools/jiraactions/api/measure/output/ActionMetricOutput;Ljava/time/Clock;)V", "postMetricHooks", "", "Lcom/atlassian/performance/tools/jiraactions/api/measure/PostMetricHook;", "(Ljava/util/UUID;Lcom/atlassian/performance/tools/jiraactions/api/measure/output/ActionMetricOutput;Ljava/time/Clock;Ljava/util/List;)V", "measure", "T", "key", "Lcom/atlassian/performance/tools/jiraactions/api/ActionType;", "action", "Lkotlin/Function0;", "(Lcom/atlassian/performance/tools/jiraactions/api/ActionType;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "observation", "Lkotlin/Function1;", "Ljavax/json/JsonObject;", "(Lcom/atlassian/performance/tools/jiraactions/api/ActionType;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withW3cPerformanceTimeline", "toActionResult", "Lcom/atlassian/performance/tools/jiraactions/api/ActionResult;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Builder", "jira-actions"})
public final class ActionMeter {
    private final UUID virtualUser;
    private final ActionMetricOutput output;
    private final Clock clock;
    private final List<PostMetricHook> postMetricHooks;

    public final <T> T measure(@NotNull ActionType<?> key, @NotNull Function0<? extends T> action) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        return this.measure(key, action, measure.1.INSTANCE);
    }

    public final <T> T measure(@NotNull ActionType<?> key, @NotNull Function0<? extends T> action, @NotNull Function1<? super T, ? extends JsonObject> observation) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        Intrinsics.checkParameterIsNotNull(observation, (String)"observation");
        Instant start = this.clock.instant();
        try {
            Object result = action.invoke();
            Duration duration = Duration.between(start, this.clock.instant());
            String string = key.getLabel();
            Instant instant = start;
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"start");
            Duration duration2 = duration;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"duration");
            ActionResult actionResult = ActionResult.OK;
            Object object = duration2;
            Instant instant2 = instant;
            ActionMetric.Builder actionMetricBuilder = new ActionMetric.Builder(string, actionResult, (Duration)object, instant2).virtualUser(this.virtualUser);
            Object $receiver$iv = this.postMetricHooks;
            object = $receiver$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                PostMetricHook it2 = (PostMetricHook)element$iv;
                it2.run(actionMetricBuilder);
            }
            Object object2 = result;
            if (object2 != null) {
                Object it = $receiver$iv = object2;
                actionMetricBuilder.observation((JsonObject)observation.invoke(result));
            }
            this.output.write(actionMetricBuilder.build());
            return (T)result;
        }
        catch (Exception e) {
            Duration duration = Duration.between(start, this.clock.instant());
            ActionResult failedResult = this.toActionResult(e);
            String string = key.getLabel();
            Instant instant = start;
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"start");
            Duration duration3 = duration;
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"duration");
            ActionResult it = failedResult;
            Duration duration4 = duration3;
            Instant it2 = instant;
            ActionMetric.Builder actionMetricBuilder = new ActionMetric.Builder(string, it, duration4, it2).virtualUser(this.virtualUser);
            Iterable $receiver$iv = this.postMetricHooks;
            for (Object element$iv : $receiver$iv) {
                PostMetricHook it3 = (PostMetricHook)element$iv;
                it3.run(actionMetricBuilder);
            }
            this.output.write(actionMetricBuilder.build());
            throw (Throwable)new Exception("Action '" + key.getLabel() + "' " + (Object)((Object)failedResult), e);
        }
    }

    private final ActionResult toActionResult(@NotNull Exception $receiver) {
        return GracefulTerminationKt.representsInterrupt((Throwable)$receiver) ? ActionResult.INTERRUPTED : ActionResult.ERROR;
    }

    @Deprecated(message="Use ActionMeter.Builder instead")
    @NotNull
    public final ActionMeter withW3cPerformanceTimeline(@NotNull W3cPerformanceTimeline w3cPerformanceTimeline) {
        Intrinsics.checkParameterIsNotNull((Object)w3cPerformanceTimeline, (String)"w3cPerformanceTimeline");
        return new ActionMeter(this.virtualUser, this.output, this.clock, CollectionsKt.emptyList());
    }

    private ActionMeter(UUID virtualUser, ActionMetricOutput output, Clock clock, List<? extends PostMetricHook> postMetricHooks) {
        this.virtualUser = virtualUser;
        this.output = output;
        this.clock = clock;
        this.postMetricHooks = postMetricHooks;
    }

    @Deprecated(message="Use ActionMeter.Builder instead", replaceWith=@ReplaceWith(imports={"com.atlassian.performance.tools.jiraactions.api.measure.DrillDownHook"}, expression="ActionMeter.Builder(\noutput = output\n)\n.clock(clock)\n.virtualUser(virtualUser)\n.build()"))
    public ActionMeter(@NotNull UUID virtualUser, @NotNull ActionMetricOutput output, @NotNull Clock clock, @NotNull W3cPerformanceTimeline w3cPerformanceTimeline) {
        Intrinsics.checkParameterIsNotNull((Object)virtualUser, (String)"virtualUser");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        Intrinsics.checkParameterIsNotNull((Object)w3cPerformanceTimeline, (String)"w3cPerformanceTimeline");
        this(virtualUser, output, clock, CollectionsKt.listOf((Object)new DrillDownHook(w3cPerformanceTimeline)));
    }

    @Deprecated(message="Use ActionMeter.Builder instead", replaceWith=@ReplaceWith(imports={}, expression="ActionMeter.Builder(\noutput = output\n)\n.clock(clock)\n.virtualUser(virtualUser)\n.build()"))
    public ActionMeter(@NotNull UUID virtualUser, @NotNull ActionMetricOutput output, @NotNull Clock clock) {
        Intrinsics.checkParameterIsNotNull((Object)virtualUser, (String)"virtualUser");
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        this(virtualUser, output, clock, CollectionsKt.emptyList());
    }

    @Deprecated(message="Use ActionMeter.Builder instead", replaceWith=@ReplaceWith(imports={}, expression="ActionMeter.Builder(\noutput = output\n)\n.clock(clock)\n.virtualUser(virtualUser)\n.build()"))
    public /* synthetic */ ActionMeter(UUID uUID, ActionMetricOutput actionMetricOutput, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            actionMetricOutput = new ThrowawayActionMetricOutput();
        }
        if ((n & 4) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkExpressionValueIsNotNull((Object)clock2, (String)"Clock.systemUTC()");
            clock = clock2;
        }
        this(uUID, actionMetricOutput, clock);
    }

    public /* synthetic */ ActionMeter(@NotNull UUID virtualUser, @NotNull ActionMetricOutput output, @NotNull Clock clock, @NotNull List postMetricHooks, DefaultConstructorMarker $constructor_marker) {
        this(virtualUser, output, clock, postMetricHooks);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\rJ\u0006\u0010\u0012\u001a\u00020\u0003J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\u0013\u001a\u00020\u00002\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0015J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fR\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/measure/ActionMeter$Builder;", "", "meter", "Lcom/atlassian/performance/tools/jiraactions/api/measure/ActionMeter;", "(Lcom/atlassian/performance/tools/jiraactions/api/measure/ActionMeter;)V", "output", "Lcom/atlassian/performance/tools/jiraactions/api/measure/output/ActionMetricOutput;", "(Lcom/atlassian/performance/tools/jiraactions/api/measure/output/ActionMetricOutput;)V", "clock", "Ljava/time/Clock;", "kotlin.jvm.PlatformType", "postMetricHooks", "", "Lcom/atlassian/performance/tools/jiraactions/api/measure/PostMetricHook;", "virtualUser", "Ljava/util/UUID;", "appendPostMetricHook", "postMetricHook", "build", "overrideOutput", "outputProvider", "Lkotlin/Function1;", "jira-actions"})
    public static final class Builder {
        private UUID virtualUser;
        private Clock clock;
        private List<PostMetricHook> postMetricHooks;
        private ActionMetricOutput output;

        @NotNull
        public final Builder clock(@NotNull Clock clock) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
            Builder $receiver = builder = this;
            $receiver.clock = clock;
            return builder;
        }

        @NotNull
        public final Builder appendPostMetricHook(@NotNull PostMetricHook postMetricHook) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)postMetricHook, (String)"postMetricHook");
            Builder $receiver = builder = this;
            $receiver.postMetricHooks.add(postMetricHook);
            return builder;
        }

        @NotNull
        public final Builder virtualUser(@NotNull UUID virtualUser) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)virtualUser, (String)"virtualUser");
            Builder $receiver = builder = this;
            $receiver.virtualUser = virtualUser;
            return builder;
        }

        @NotNull
        public final Builder overrideOutput(@NotNull Function1<? super ActionMetricOutput, ? extends ActionMetricOutput> outputProvider) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(outputProvider, (String)"outputProvider");
            Builder $receiver = builder = this;
            $receiver.output = (ActionMetricOutput)outputProvider.invoke((Object)$receiver.output);
            return builder;
        }

        @NotNull
        public final ActionMeter build() {
            Clock clock = this.clock;
            Intrinsics.checkExpressionValueIsNotNull((Object)clock, (String)"clock");
            return new ActionMeter(this.virtualUser, this.output, clock, this.postMetricHooks, null);
        }

        public Builder(@NotNull ActionMetricOutput output) {
            List list;
            Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
            this.output = output;
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.randomUUID()");
            this.virtualUser = uUID;
            this.clock = Clock.systemUTC();
            Builder builder = this;
            builder.postMetricHooks = list = (List)new ArrayList();
        }

        public Builder(@NotNull ActionMeter meter) {
            Intrinsics.checkParameterIsNotNull((Object)meter, (String)"meter");
            this(meter.output);
            this.clock = meter.clock;
            this.virtualUser = meter.virtualUser;
        }
    }
}

