/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api.action;

import com.atlassian.performance.tools.jiraactions.JsonProviderSingleton;
import com.atlassian.performance.tools.jiraactions.api.ActionType;
import com.atlassian.performance.tools.jiraactions.api.ActionTypes;
import com.atlassian.performance.tools.jiraactions.api.SeededRandom;
import com.atlassian.performance.tools.jiraactions.api.WebJira;
import com.atlassian.performance.tools.jiraactions.api.action.Action;
import com.atlassian.performance.tools.jiraactions.api.action.SearchIssues;
import com.atlassian.performance.tools.jiraactions.api.measure.ActionMeter;
import com.atlassian.performance.tools.jiraactions.api.memories.IssueKeyMemory;
import com.atlassian.performance.tools.jiraactions.api.memories.JqlMemory;
import com.atlassian.performance.tools.jiraactions.api.memories.adaptive.AdaptiveIssueKeyMemory;
import com.atlassian.performance.tools.jiraactions.api.memories.adaptive.AdaptiveJqlMemory;
import com.atlassian.performance.tools.jiraactions.api.observation.SearchJqlObservation;
import com.atlassian.performance.tools.jiraactions.api.page.IssueNavigatorPage;
import com.atlassian.performance.tools.jiraactions.api.page.issuenav.DetailView;
import com.atlassian.performance.tools.jiraactions.api.page.issuenav.IssueNavResultsView;
import java.util.Collection;
import java.util.List;
import javax.json.JsonObject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB=\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0019H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/action/SearchIssues;", "Lcom/atlassian/performance/tools/jiraactions/api/action/Action;", "jira", "Lcom/atlassian/performance/tools/jiraactions/api/WebJira;", "meter", "Lcom/atlassian/performance/tools/jiraactions/api/measure/ActionMeter;", "actionType", "Lcom/atlassian/performance/tools/jiraactions/api/ActionType;", "Lcom/atlassian/performance/tools/jiraactions/api/observation/SearchJqlObservation;", "jqlMemory", "Lcom/atlassian/performance/tools/jiraactions/api/memories/JqlMemory;", "issueKeyMemory", "Lcom/atlassian/performance/tools/jiraactions/api/memories/IssueKeyMemory;", "desiredView", "Lcom/atlassian/performance/tools/jiraactions/api/page/issuenav/IssueNavResultsView;", "(Lcom/atlassian/performance/tools/jiraactions/api/WebJira;Lcom/atlassian/performance/tools/jiraactions/api/measure/ActionMeter;Lcom/atlassian/performance/tools/jiraactions/api/ActionType;Lcom/atlassian/performance/tools/jiraactions/api/memories/JqlMemory;Lcom/atlassian/performance/tools/jiraactions/api/memories/IssueKeyMemory;Lcom/atlassian/performance/tools/jiraactions/api/page/issuenav/IssueNavResultsView;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "switchActionType", "Lcom/atlassian/performance/tools/jiraactions/api/action/SearchIssues$SwitchObservation;", "observe", "Ljavax/json/JsonObject;", "page", "Lcom/atlassian/performance/tools/jiraactions/api/page/IssueNavigatorPage;", "run", "", "search", "jqlQuery", "", "switchResultsView", "Builder", "SwitchObservation", "jira-actions"})
public final class SearchIssues
implements Action {
    private final Logger logger;
    private final ActionType<SwitchObservation> switchActionType;
    private final WebJira jira;
    private final ActionMeter meter;
    private final ActionType<SearchJqlObservation> actionType;
    private final JqlMemory jqlMemory;
    private final IssueKeyMemory issueKeyMemory;
    private final IssueNavResultsView desiredView;

    @Override
    public void run() {
        String jqlQuery = (String)this.jqlMemory.recall();
        if (jqlQuery == null) {
            this.logger.debug("Skipping " + this.actionType.getLabel() + " action, because I cannot recall any JQL queries.");
            return;
        }
        this.meter.measure(this.actionType, (Function0)new Function0<IssueNavigatorPage>(this, jqlQuery){
            final /* synthetic */ SearchIssues this$0;
            final /* synthetic */ String $jqlQuery;

            @NotNull
            public final IssueNavigatorPage invoke() {
                return SearchIssues.access$search(this.this$0, this.$jqlQuery);
            }
            {
                this.this$0 = searchIssues;
                this.$jqlQuery = string;
                super(0);
            }
        }, (Function1)new Function1<IssueNavigatorPage, JsonObject>(this){

            @NotNull
            public final JsonObject invoke(@NotNull IssueNavigatorPage p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return SearchIssues.access$observe((SearchIssues)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SearchIssues.class);
            }

            public final String getName() {
                return "observe";
            }

            public final String getSignature() {
                return "observe(Lcom/atlassian/performance/tools/jiraactions/api/page/IssueNavigatorPage;)Ljavax/json/JsonObject;";
            }
        });
    }

    private final IssueNavigatorPage search(String jqlQuery) {
        IssueNavigatorPage issueNavigatorPage;
        IssueNavigatorPage it = issueNavigatorPage = this.jira.goToIssueNavigator(jqlQuery);
        this.switchResultsView();
        return issueNavigatorPage.waitForResults(this.desiredView);
    }

    private final void switchResultsView() {
        this.meter.measure(this.switchActionType, (Function0)new Function0<SwitchObservation.Builder>(this){
            final /* synthetic */ SearchIssues this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final SwitchObservation.Builder invoke() {
                void var1_1;
                String string = SearchIssues.access$getDesiredView$p(this.this$0).getClass().getSimpleName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"desiredView.javaClass.simpleName");
                SwitchObservation.Builder observation = new SwitchObservation.Builder(string);
                boolean selectedBefore = SearchIssues.access$getDesiredView$p(this.this$0).isSelected();
                observation.selectedBefore(selectedBefore);
                if (!selectedBefore) {
                    SearchIssues.access$getDesiredView$p(this.this$0).switchToView();
                    observation.switched();
                }
                return var1_1;
            }
            {
                this.this$0 = searchIssues;
                super(0);
            }
        }, (Function1)new Function1<SwitchObservation.Builder, JsonObject>(this){
            final /* synthetic */ SearchIssues this$0;

            @NotNull
            public final JsonObject invoke(@NotNull SwitchObservation.Builder observation) {
                Intrinsics.checkParameterIsNotNull((Object)observation, (String)"observation");
                return observation.selectedAfter(SearchIssues.access$getDesiredView$p(this.this$0).isSelected()).build().serialize();
            }
            {
                this.this$0 = searchIssues;
                super(1);
            }
        });
    }

    private final JsonObject observe(IssueNavigatorPage page) {
        List<String> issueKeys = this.desiredView.listIssueKeys();
        this.issueKeyMemory.remember((Collection)issueKeys);
        Integer n = this.desiredView.countResults();
        return new SearchJqlObservation(page.getJql(), issueKeys.size(), n != null ? n : -1).serialize();
    }

    private SearchIssues(WebJira jira, ActionMeter meter, ActionType<SearchJqlObservation> actionType, JqlMemory jqlMemory, IssueKeyMemory issueKeyMemory, IssueNavResultsView desiredView) {
        this.jira = jira;
        this.meter = meter;
        this.actionType = actionType;
        this.jqlMemory = jqlMemory;
        this.issueKeyMemory = issueKeyMemory;
        this.desiredView = desiredView;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        this.switchActionType = new ActionType("Switch issue nav view", switchActionType.1.INSTANCE);
    }

    public /* synthetic */ SearchIssues(@NotNull WebJira jira, @NotNull ActionMeter meter, @NotNull ActionType actionType, @NotNull JqlMemory jqlMemory, @NotNull IssueKeyMemory issueKeyMemory, @NotNull IssueNavResultsView desiredView, DefaultConstructorMarker $constructor_marker) {
        this(jira, meter, actionType, jqlMemory, issueKeyMemory, desiredView);
    }

    @NotNull
    public static final /* synthetic */ IssueNavigatorPage access$search(SearchIssues $this, @NotNull String jqlQuery) {
        return $this.search(jqlQuery);
    }

    @NotNull
    public static final /* synthetic */ JsonObject access$observe(SearchIssues $this, @NotNull IssueNavigatorPage page) {
        return $this.observe(page);
    }

    @NotNull
    public static final /* synthetic */ IssueNavResultsView access$getDesiredView$p(SearchIssues $this) {
        return $this.desiredView;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\t\u001a\u00020\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/action/SearchIssues$Builder;", "", "jira", "Lcom/atlassian/performance/tools/jiraactions/api/WebJira;", "meter", "Lcom/atlassian/performance/tools/jiraactions/api/measure/ActionMeter;", "seededRandom", "Lcom/atlassian/performance/tools/jiraactions/api/SeededRandom;", "(Lcom/atlassian/performance/tools/jiraactions/api/WebJira;Lcom/atlassian/performance/tools/jiraactions/api/measure/ActionMeter;Lcom/atlassian/performance/tools/jiraactions/api/SeededRandom;)V", "actionType", "Lcom/atlassian/performance/tools/jiraactions/api/ActionType;", "Lcom/atlassian/performance/tools/jiraactions/api/observation/SearchJqlObservation;", "desiredView", "Lcom/atlassian/performance/tools/jiraactions/api/page/issuenav/IssueNavResultsView;", "issueKeyMemory", "Lcom/atlassian/performance/tools/jiraactions/api/memories/IssueKeyMemory;", "jqlMemory", "Lcom/atlassian/performance/tools/jiraactions/api/memories/JqlMemory;", "build", "Lcom/atlassian/performance/tools/jiraactions/api/action/Action;", "jira-actions"})
    public static final class Builder {
        private ActionType<SearchJqlObservation> actionType;
        private JqlMemory jqlMemory;
        private IssueKeyMemory issueKeyMemory;
        private IssueNavResultsView desiredView;
        private WebJira jira;
        private ActionMeter meter;

        @NotNull
        public final Builder actionType(@NotNull ActionType<SearchJqlObservation> actionType) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(actionType, (String)"actionType");
            Builder $receiver = builder = this;
            $receiver.actionType = actionType;
            return builder;
        }

        @NotNull
        public final Builder jqlMemory(@NotNull JqlMemory jqlMemory) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)jqlMemory, (String)"jqlMemory");
            Builder $receiver = builder = this;
            $receiver.jqlMemory = jqlMemory;
            return builder;
        }

        @NotNull
        public final Builder issueKeyMemory(@NotNull IssueKeyMemory issueKeyMemory) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)issueKeyMemory, (String)"issueKeyMemory");
            Builder $receiver = builder = this;
            $receiver.issueKeyMemory = issueKeyMemory;
            return builder;
        }

        @NotNull
        public final Builder desiredView(@NotNull IssueNavResultsView desiredView) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)desiredView, (String)"desiredView");
            Builder $receiver = builder = this;
            $receiver.desiredView = desiredView;
            return builder;
        }

        @NotNull
        public final Action build() {
            return new SearchIssues(this.jira, this.meter, this.actionType, this.jqlMemory, this.issueKeyMemory, this.desiredView, null);
        }

        public Builder(@NotNull WebJira jira, @NotNull ActionMeter meter, @NotNull SeededRandom seededRandom) {
            Intrinsics.checkParameterIsNotNull((Object)jira, (String)"jira");
            Intrinsics.checkParameterIsNotNull((Object)meter, (String)"meter");
            Intrinsics.checkParameterIsNotNull((Object)seededRandom, (String)"seededRandom");
            this.jira = jira;
            this.meter = meter;
            this.actionType = ActionTypes.SEARCH_WITH_JQL;
            this.jqlMemory = new AdaptiveJqlMemory(seededRandom);
            this.issueKeyMemory = new AdaptiveIssueKeyMemory(seededRandom);
            this.desiredView = new DetailView(this.jira.getDriver());
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0012\u001a\u00020\u0003R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/action/SearchIssues$SwitchObservation;", "", "json", "Ljavax/json/JsonObject;", "(Ljavax/json/JsonObject;)V", "desiredView", "", "selectedBefore", "", "selectedAfter", "switched", "(Ljava/lang/String;ZZZ)V", "getDesiredView", "()Ljava/lang/String;", "getSelectedAfter", "()Z", "getSelectedBefore", "getSwitched", "serialize", "Builder", "jira-actions"})
    private static final class SwitchObservation {
        @NotNull
        private final String desiredView;
        private final boolean selectedBefore;
        private final boolean selectedAfter;
        private final boolean switched;

        @NotNull
        public final JsonObject serialize() {
            JsonObject jsonObject = JsonProviderSingleton.INSTANCE.getJSON().createObjectBuilder().add("desiredView", this.desiredView).add("selectedBefore", this.selectedBefore).add("selectedAfter", this.selectedAfter).add("switched", this.switched).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"JSON.createObjectBuilder\u2026hed)\n            .build()");
            return jsonObject;
        }

        @NotNull
        public final String getDesiredView() {
            return this.desiredView;
        }

        public final boolean getSelectedBefore() {
            return this.selectedBefore;
        }

        public final boolean getSelectedAfter() {
            return this.selectedAfter;
        }

        public final boolean getSwitched() {
            return this.switched;
        }

        public SwitchObservation(@NotNull String desiredView, boolean selectedBefore, boolean selectedAfter, boolean switched) {
            Intrinsics.checkParameterIsNotNull((Object)desiredView, (String)"desiredView");
            this.desiredView = desiredView;
            this.selectedBefore = selectedBefore;
            this.selectedAfter = selectedAfter;
            this.switched = switched;
        }

        public SwitchObservation(@NotNull JsonObject json) {
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            String string = json.getString("desiredView");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"json.getString(\"desiredView\")");
            this(string, json.getBoolean("selectedBefore"), json.getBoolean("selectedAfter"), json.getBoolean("switched"));
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006J\u0006\u0010\b\u001a\u00020\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/action/SearchIssues$SwitchObservation$Builder;", "", "desiredView", "", "(Ljava/lang/String;)V", "selectedAfter", "", "selectedBefore", "switched", "build", "Lcom/atlassian/performance/tools/jiraactions/api/action/SearchIssues$SwitchObservation;", "jira-actions"})
        public static final class Builder {
            private boolean selectedBefore;
            private boolean selectedAfter;
            private boolean switched;
            private String desiredView;

            @NotNull
            public final Builder selectedBefore(boolean selectedBefore) {
                Builder builder;
                Builder $receiver = builder = this;
                $receiver.selectedBefore = selectedBefore;
                return builder;
            }

            @NotNull
            public final Builder selectedAfter(boolean selectedAfter) {
                Builder builder;
                Builder $receiver = builder = this;
                $receiver.selectedAfter = selectedAfter;
                return builder;
            }

            @NotNull
            public final Builder switched() {
                Builder builder;
                Builder $receiver = builder = this;
                $receiver.switched = true;
                return builder;
            }

            @NotNull
            public final SwitchObservation build() {
                return new SwitchObservation(this.desiredView, this.switched, this.selectedBefore, this.selectedAfter);
            }

            public Builder(@NotNull String desiredView) {
                Intrinsics.checkParameterIsNotNull((Object)desiredView, (String)"desiredView");
                this.desiredView = desiredView;
            }
        }
    }
}

