/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.jiraactions.api;

import com.atlassian.performance.tools.jiraactions.administration.JiraAdministrationMenu;
import com.atlassian.performance.tools.jiraactions.api.page.AdminAccess;
import com.atlassian.performance.tools.jiraactions.api.page.BackupConfiguration;
import com.atlassian.performance.tools.jiraactions.api.page.BrowseProjectsPage;
import com.atlassian.performance.tools.jiraactions.api.page.CommentForm;
import com.atlassian.performance.tools.jiraactions.api.page.CommentTabPanel;
import com.atlassian.performance.tools.jiraactions.api.page.DashboardPage;
import com.atlassian.performance.tools.jiraactions.api.page.EditIssuePage;
import com.atlassian.performance.tools.jiraactions.api.page.IssueNavigatorPage;
import com.atlassian.performance.tools.jiraactions.api.page.IssuePage;
import com.atlassian.performance.tools.jiraactions.api.page.LoginPage;
import com.atlassian.performance.tools.jiraactions.api.page.NotificationPopUps;
import com.atlassian.performance.tools.jiraactions.api.page.ProjectSummaryPage;
import com.atlassian.performance.tools.jiraactions.api.page.RichTextEditorConfiguration;
import com.atlassian.performance.tools.jiraactions.api.page.TopNav;
import com.atlassian.performance.tools.jiraactions.api.page.WebDriverUtils;
import java.net.URI;
import java.net.URLEncoder;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\r\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ'\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u001f\u001a\u00020\u0007J\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0007J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u0002002\u0006\u0010+\u001a\u00020,J\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0007J\u000e\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0007J\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0007J\u0006\u0010<\u001a\u00020=J\t\u0010>\u001a\u00020%H\u00d6\u0001J\u000e\u0010?\u001a\u00020=2\u0006\u0010@\u001a\u00020\u0007J\t\u0010A\u001a\u00020\u0007H\u00d6\u0001J\b\u0010B\u001a\u00020=H\u0002J\b\u0010C\u001a\u00020=H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006D"}, d2={"Lcom/atlassian/performance/tools/jiraactions/api/WebJira;", "", "driver", "Lorg/openqa/selenium/WebDriver;", "base", "Ljava/net/URI;", "adminPassword", "", "(Lorg/openqa/selenium/WebDriver;Ljava/net/URI;Ljava/lang/String;)V", "getAdminPassword", "()Ljava/lang/String;", "getBase", "()Ljava/net/URI;", "getDriver", "()Lorg/openqa/selenium/WebDriver;", "accessAdmin", "Lcom/atlassian/performance/tools/jiraactions/api/page/AdminAccess;", "administrate", "Lcom/atlassian/performance/tools/jiraactions/administration/JiraAdministrationMenu;", "administrate$jira_actions", "component1", "component2", "component3", "configureBackupPolicy", "Lcom/atlassian/performance/tools/jiraactions/api/page/BackupConfiguration;", "configureRichTextEditor", "Lcom/atlassian/performance/tools/jiraactions/api/page/RichTextEditorConfiguration;", "copy", "equals", "", "other", "getJiraNode", "getTopNav", "Lcom/atlassian/performance/tools/jiraactions/api/page/TopNav;", "goToBrowseProjects", "Lcom/atlassian/performance/tools/jiraactions/api/page/BrowseProjectsPage;", "page", "", "goToComment", "Lcom/atlassian/performance/tools/jiraactions/api/page/CommentTabPanel;", "commentUrl", "goToCommentForm", "Lcom/atlassian/performance/tools/jiraactions/api/page/CommentForm;", "issueId", "", "goToDashboard", "Lcom/atlassian/performance/tools/jiraactions/api/page/DashboardPage;", "goToEditIssue", "Lcom/atlassian/performance/tools/jiraactions/api/page/EditIssuePage;", "goToIssue", "Lcom/atlassian/performance/tools/jiraactions/api/page/IssuePage;", "issueKey", "goToIssueNavigator", "Lcom/atlassian/performance/tools/jiraactions/api/page/IssueNavigatorPage;", "jqlQuery", "goToLogin", "Lcom/atlassian/performance/tools/jiraactions/api/page/LoginPage;", "goToProjectSummary", "Lcom/atlassian/performance/tools/jiraactions/api/page/ProjectSummaryPage;", "projectKey", "goToSystemInfo", "", "hashCode", "navigateTo", "path", "toString", "waitForAdminCog", "waitForDomComplete", "jira-actions"})
public final class WebJira {
    @NotNull
    private final WebDriver driver;
    @NotNull
    private final URI base;
    @NotNull
    private final String adminPassword;

    @NotNull
    public final LoginPage goToLogin() {
        this.navigateTo("login.jsp");
        return new LoginPage(this.driver);
    }

    @NotNull
    public final RichTextEditorConfiguration configureRichTextEditor() {
        this.navigateTo("secure/admin/ConfigureRTE!default.jspa");
        return new RichTextEditorConfiguration(this.driver, this.accessAdmin());
    }

    @NotNull
    public final BackupConfiguration configureBackupPolicy() {
        this.navigateTo("secure/admin/ViewServices!default.jspa");
        return new BackupConfiguration(this.driver, this.accessAdmin());
    }

    @NotNull
    public final AdminAccess accessAdmin() {
        return new AdminAccess(this.driver, this, this.adminPassword);
    }

    public final void goToSystemInfo() {
        this.navigateTo("secure/admin/ViewSystemInfo.jspa");
    }

    @NotNull
    public final IssuePage goToIssue(@NotNull String issueKey) {
        Intrinsics.checkParameterIsNotNull((Object)issueKey, (String)"issueKey");
        this.navigateTo("browse/" + issueKey);
        return new IssuePage(this.driver);
    }

    @NotNull
    public final TopNav getTopNav() {
        return new TopNav(this.driver);
    }

    @NotNull
    public final DashboardPage goToDashboard() {
        this.navigateTo("secure/Dashboard.jspa");
        return new DashboardPage(this.driver);
    }

    @NotNull
    public final ProjectSummaryPage goToProjectSummary(@NotNull String projectKey) {
        Intrinsics.checkParameterIsNotNull((Object)projectKey, (String)"projectKey");
        this.navigateTo("browse/" + projectKey + "/summary");
        return new ProjectSummaryPage(this.driver);
    }

    @NotNull
    public final IssueNavigatorPage goToIssueNavigator(@NotNull String jqlQuery) {
        Intrinsics.checkParameterIsNotNull((Object)jqlQuery, (String)"jqlQuery");
        String encodedJqlQuery = URLEncoder.encode(jqlQuery, "UTF-8");
        this.navigateTo("issues/?jql=" + encodedJqlQuery);
        return new IssueNavigatorPage(this.driver, jqlQuery);
    }

    @NotNull
    public final BrowseProjectsPage goToBrowseProjects(int page) {
        this.navigateTo("secure/BrowseProjects.jspa?selectedCategory=all&selectedProjectType=all&page=" + page);
        return new BrowseProjectsPage(this.driver);
    }

    @NotNull
    public final CommentForm goToCommentForm(long issueId) {
        this.navigateTo("secure/AddComment!default.jspa?id=" + issueId);
        return new CommentForm(this.driver);
    }

    @NotNull
    public final EditIssuePage goToEditIssue(long issueId) {
        this.navigateTo("secure/EditIssue!default.jspa?id=" + issueId);
        return new EditIssuePage(this.driver);
    }

    @NotNull
    public final String getJiraNode() {
        WebElement webElement = this.driver.findElement(By.id((String)"footer-build-information"));
        Intrinsics.checkExpressionValueIsNotNull((Object)webElement, (String)"driver.findElement(By.id\u2026oter-build-information\"))");
        String string = webElement.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"driver.findElement(By.id\u2026build-information\")).text");
        return string;
    }

    @NotNull
    public final CommentTabPanel goToComment(@NotNull String commentUrl) {
        Intrinsics.checkParameterIsNotNull((Object)commentUrl, (String)"commentUrl");
        this.driver.navigate().to(commentUrl);
        return new CommentTabPanel(this.driver);
    }

    public final void navigateTo(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.driver.navigate().to(this.base.resolve(path).toURL());
    }

    @NotNull
    public final JiraAdministrationMenu administrate$jira_actions() {
        WebElement menu;
        new NotificationPopUps(this.driver).waitUntilAuiFlagsAreGone();
        By adminCog = By.id((String)"admin_menu");
        this.waitForAdminCog();
        this.driver.findElement(adminCog).click();
        WebElement webElement = menu = this.driver.findElement(By.id((String)"system-admin-menu-content"));
        Intrinsics.checkExpressionValueIsNotNull((Object)webElement, (String)"menu");
        return new JiraAdministrationMenu(this.driver, webElement);
    }

    private final void waitForAdminCog() {
        this.waitForDomComplete();
    }

    private final void waitForDomComplete() {
        WebDriver webDriver = this.driver;
        if (webDriver == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.openqa.selenium.JavascriptExecutor");
        }
        JavascriptExecutor js = (JavascriptExecutor)webDriver;
        ExpectedCondition domComplete2 = (ExpectedCondition)new ExpectedCondition<Boolean>(js){
            final /* synthetic */ JavascriptExecutor $js;

            public final boolean apply(@Nullable WebDriver it) {
                String state = (String)this.$js.executeScript("return document.readyState", new Object[0]);
                return Intrinsics.areEqual((Object)state, (Object)"complete");
            }
            {
                this.$js = javascriptExecutor;
            }
        };
        WebDriverUtils.wait(this.driver, domComplete2);
    }

    @NotNull
    public final WebDriver getDriver() {
        return this.driver;
    }

    @NotNull
    public final URI getBase() {
        return this.base;
    }

    @NotNull
    public final String getAdminPassword() {
        return this.adminPassword;
    }

    public WebJira(@NotNull WebDriver driver, @NotNull URI base, @NotNull String adminPassword) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Intrinsics.checkParameterIsNotNull((Object)adminPassword, (String)"adminPassword");
        this.driver = driver;
        this.base = base;
        this.adminPassword = adminPassword;
    }

    @NotNull
    public final WebDriver component1() {
        return this.driver;
    }

    @NotNull
    public final URI component2() {
        return this.base;
    }

    @NotNull
    public final String component3() {
        return this.adminPassword;
    }

    @NotNull
    public final WebJira copy(@NotNull WebDriver driver, @NotNull URI base, @NotNull String adminPassword) {
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Intrinsics.checkParameterIsNotNull((Object)adminPassword, (String)"adminPassword");
        return new WebJira(driver, base, adminPassword);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ WebJira copy$default(WebJira webJira, WebDriver webDriver, URI uRI, String string, int n, Object object) {
        if ((n & 1) != 0) {
            webDriver = webJira.driver;
        }
        if ((n & 2) != 0) {
            uRI = webJira.base;
        }
        if ((n & 4) != 0) {
            string = webJira.adminPassword;
        }
        return webJira.copy(webDriver, uRI, string);
    }

    @NotNull
    public String toString() {
        return "WebJira(driver=" + this.driver + ", base=" + this.base + ", adminPassword=" + this.adminPassword + ")";
    }

    public int hashCode() {
        WebDriver webDriver = this.driver;
        URI uRI = this.base;
        String string = this.adminPassword;
        return ((webDriver != null ? webDriver.hashCode() : 0) * 31 + (uRI != null ? ((Object)uRI).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof WebJira)) break block3;
                WebJira webJira = (WebJira)object;
                if (!Intrinsics.areEqual((Object)this.driver, (Object)webJira.driver) || !Intrinsics.areEqual((Object)this.base, (Object)webJira.base) || !Intrinsics.areEqual((Object)this.adminPassword, (Object)webJira.adminPassword)) break block3;
            }
            return true;
        }
        return false;
    }
}

